/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Route<E extends Exchange> {
    private final Map<String, Object> properties = new HashMap<String, Object>(16);
    private Endpoint<E> endpoint;
    private List<Service> services = new ArrayList<Service>();

    public Route(Endpoint<E> endpoint) {
        this.endpoint = endpoint;
    }

    public Endpoint<E> getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint<E> endpoint) {
        this.endpoint = endpoint;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public List<Service> getServicesForRoute() throws Exception {
        ArrayList<Service> servicesForRoute = new ArrayList<Service>(this.getServices());
        this.addServices(servicesForRoute);
        return servicesForRoute;
    }

    public List<Service> getServices() throws Exception {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    protected abstract void addServices(List<Service> var1) throws Exception;
}

