/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.schemata.tpch;

public class TpchSchema {
    public final Customer[] customer = new Customer[]{TpchSchema.c(1), TpchSchema.c(2)};
    public final LineItem[] lineitem = new LineItem[]{TpchSchema.li(1), TpchSchema.li(2)};
    public final Part[] part = new Part[]{TpchSchema.p(1), TpchSchema.p(2)};
    public final PartSupp[] partsupp = new PartSupp[]{TpchSchema.ps(1, 250), TpchSchema.ps(2, 100)};

    public static Customer c(int custId) {
        return new Customer(custId);
    }

    public static LineItem li(int custId) {
        return new LineItem(custId);
    }

    public static PartSupp ps(int pPartkey, int pSupplyCost) {
        return new PartSupp(pPartkey, pSupplyCost);
    }

    public static Part p(int pPartkey) {
        return new Part(pPartkey);
    }

    public static class PartSupp {
        public final int psPartkey;
        public final int psSupplyCost;

        public PartSupp(int psPartkey, int psSupplyCost) {
            this.psPartkey = psPartkey;
            this.psSupplyCost = psSupplyCost;
        }

        public String toString() {
            return "PartSupp [pSupplyCost=" + this.psPartkey + ", pSupplyCost=" + this.psSupplyCost + "]";
        }
    }

    public static class Part {
        public final int pPartkey;
        public final String p_brand;

        public Part(int pPartkey) {
            this.pPartkey = pPartkey;
            this.p_brand = "brand" + pPartkey;
        }

        public String toString() {
            return "Part [pPartkey=" + this.pPartkey + "]";
        }
    }

    public static class LineItem {
        public final int custId;

        public LineItem(int custId) {
            this.custId = custId;
        }

        public String toString() {
            return "LineItem [custId=" + this.custId + "]";
        }
    }

    public static class Customer {
        public final int custId;
        public final String nation_name;

        public Customer(int custId) {
            this.custId = custId;
            this.nation_name = "USA";
        }

        public String toString() {
            return "Customer [custId=" + this.custId + "]";
        }
    }
}

