/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.schemata.catchall;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.adapter.java.Array;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.test.schemata.hr.Employee;
import org.apache.calcite.test.schemata.hr.HrSchema;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CatchallSchema {
    public final Enumerable<Employee> enumerable;
    public final List<Employee> list;
    public final BitSet bitSet;
    public final EveryType[] everyTypes;
    public final AllPrivate[] allPrivates;
    public final BadType[] badTypes;
    public final Employee[] prefixEmps;
    public final Integer[] primesBoxed;
    public final int[] primes;
    public final IntHolder[] primesCustomBoxed;
    public final IntAndString[] nullables;
    public final IntAndString[] bools;

    public CatchallSchema() {
        this.enumerable = Linq4j.asEnumerable(Arrays.asList(new HrSchema().emps));
        this.list = Arrays.asList(new HrSchema().emps);
        this.bitSet = new BitSet(1);
        this.everyTypes = new EveryType[]{new EveryType(false, 0, '\u0000', 0, 0, 0L, 0.0f, 0.0, false, (byte)0, Character.valueOf('\u0000'), (short)0, 0, 0L, Float.valueOf(0.0f), 0.0, new Date(0L), new Time(0L), new Timestamp(0L), new java.util.Date(0L), "1", BigDecimal.ZERO, Collections.emptyList()), new EveryType(true, 127, '\uffff', Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.MAX_VALUE, Double.MAX_VALUE, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null)};
        this.allPrivates = new AllPrivate[]{new AllPrivate()};
        this.badTypes = new BadType[]{new BadType()};
        this.prefixEmps = new Employee[]{new Employee(1, 10, "A", 0.0f, null), new Employee(2, 10, "Ab", 0.0f, null), new Employee(3, 10, "Abc", 0.0f, null), new Employee(4, 10, "Abd", 0.0f, null)};
        this.primesBoxed = new Integer[]{1, 3, 5};
        this.primes = new int[]{1, 3, 5};
        this.primesCustomBoxed = new IntHolder[]{new IntHolder(1), new IntHolder(3), new IntHolder(5)};
        this.nullables = new IntAndString[]{new IntAndString(1, "A"), new IntAndString(2, "B"), new IntAndString(2, "C"), new IntAndString(3, null)};
        this.bools = new IntAndString[]{new IntAndString(1, "T"), new IntAndString(2, "F"), new IntAndString(3, null)};
    }

    private static boolean isNumeric(Class type) {
        switch (Primitive.flavor((Type)type)) {
            case BOX: {
                return Primitive.ofBox((Type)type).isNumeric();
            }
            case PRIMITIVE: {
                return Primitive.of((Type)type).isNumeric();
            }
        }
        return Number.class.isAssignableFrom(type);
    }

    public static class IntHolder {
        public final int value;

        public IntHolder(int value) {
            this.value = value;
        }
    }

    public static class IntAndString {
        public final int id;
        public final @Nullable String value;

        public IntAndString(int id, @Nullable String value) {
            this.id = id;
            this.value = value;
        }
    }

    public static class BadType {
        public final int integer = 0;
        public final BitSet bitSet = new BitSet(0);
    }

    public static class AllPrivate {
        private final int x = 0;
    }

    public static class EveryType {
        public final boolean primitiveBoolean;
        public final byte primitiveByte;
        public final char primitiveChar;
        public final short primitiveShort;
        public final int primitiveInt;
        public final long primitiveLong;
        public final float primitiveFloat;
        public final double primitiveDouble;
        public final @Nullable Boolean wrapperBoolean;
        public final @Nullable Byte wrapperByte;
        public final @Nullable Character wrapperCharacter;
        public final @Nullable Short wrapperShort;
        public final @Nullable Integer wrapperInteger;
        public final @Nullable Long wrapperLong;
        public final @Nullable Float wrapperFloat;
        public final @Nullable Double wrapperDouble;
        public final @Nullable Date sqlDate;
        public final @Nullable Time sqlTime;
        public final @Nullable Timestamp sqlTimestamp;
        public final @Nullable java.util.Date utilDate;
        public final @Nullable String string;
        public final @Nullable BigDecimal bigDecimal;
        @Array(component=String.class)
        public final @Nullable List<String> list;

        public EveryType(boolean primitiveBoolean, byte primitiveByte, char primitiveChar, short primitiveShort, int primitiveInt, long primitiveLong, float primitiveFloat, double primitiveDouble, @Nullable Boolean wrapperBoolean, @Nullable Byte wrapperByte, @Nullable Character wrapperCharacter, @Nullable Short wrapperShort, @Nullable Integer wrapperInteger, @Nullable Long wrapperLong, @Nullable Float wrapperFloat, @Nullable Double wrapperDouble, @Nullable Date sqlDate, @Nullable Time sqlTime, @Nullable Timestamp sqlTimestamp, @Nullable java.util.Date utilDate, @Nullable String string, @Nullable BigDecimal bigDecimal, @Nullable List<String> list) {
            this.primitiveBoolean = primitiveBoolean;
            this.primitiveByte = primitiveByte;
            this.primitiveChar = primitiveChar;
            this.primitiveShort = primitiveShort;
            this.primitiveInt = primitiveInt;
            this.primitiveLong = primitiveLong;
            this.primitiveFloat = primitiveFloat;
            this.primitiveDouble = primitiveDouble;
            this.wrapperBoolean = wrapperBoolean;
            this.wrapperByte = wrapperByte;
            this.wrapperCharacter = wrapperCharacter;
            this.wrapperShort = wrapperShort;
            this.wrapperInteger = wrapperInteger;
            this.wrapperLong = wrapperLong;
            this.wrapperFloat = wrapperFloat;
            this.wrapperDouble = wrapperDouble;
            this.sqlDate = sqlDate;
            this.sqlTime = sqlTime;
            this.sqlTimestamp = sqlTimestamp;
            this.utilDate = utilDate;
            this.string = string;
            this.bigDecimal = bigDecimal;
            this.list = list;
        }

        public static Enumerable<Field> fields() {
            return Linq4j.asEnumerable((Object[])EveryType.class.getFields());
        }

        public static Enumerable<Field> numericFields() {
            return EveryType.fields().where(v1 -> CatchallSchema.isNumeric(v1.getType()));
        }
    }
}

