/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.catalog;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.ObjectSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql2rel.InitializerExpressionFactory;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.test.catalog.CompoundNameColumn;
import org.apache.calcite.test.catalog.CompoundNameColumnResolver;
import org.apache.calcite.test.catalog.CountingFactory;
import org.apache.calcite.test.catalog.EmpInitializerExpressionFactory;
import org.apache.calcite.test.catalog.Fixture;
import org.apache.calcite.test.catalog.MockCatalogReader;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MockCatalogReaderSimple
extends MockCatalogReader {
    private final ObjectSqlType addressType;

    protected MockCatalogReaderSimple(RelDataTypeFactory typeFactory, boolean caseSensitive) {
        super(typeFactory, caseSensitive);
        this.addressType = new Fixture((RelDataTypeFactory)typeFactory).addressType;
    }

    public static @NonNull MockCatalogReaderSimple create(RelDataTypeFactory typeFactory, boolean caseSensitive) {
        return new MockCatalogReaderSimple(typeFactory, caseSensitive).init();
    }

    public RelDataType getNamedType(SqlIdentifier typeName) {
        if (typeName.equalsDeep((SqlNode)this.addressType.getSqlIdentifier(), Litmus.IGNORE)) {
            return this.addressType;
        }
        return super.getNamedType(typeName);
    }

    private void registerTableEmp(MockCatalogReader.MockTable empTable, Fixture fixture) {
        empTable.addColumn("EMPNO", fixture.intType, true);
        empTable.addColumn("ENAME", fixture.varchar20Type);
        empTable.addColumn("JOB", fixture.varchar10Type);
        empTable.addColumn("MGR", fixture.intTypeNull);
        empTable.addColumn("HIREDATE", fixture.timestampType);
        empTable.addColumn("SAL", fixture.intType);
        empTable.addColumn("COMM", fixture.intType);
        empTable.addColumn("DEPTNO", fixture.intType);
        empTable.addColumn("SLACKER", fixture.booleanType);
        this.registerTable(empTable);
    }

    private void registerTableEmpNullables(MockCatalogReader.MockTable empNullablesTable, Fixture fixture) {
        empNullablesTable.addColumn("EMPNO", fixture.intType, true);
        empNullablesTable.addColumn("ENAME", fixture.varchar20TypeNull);
        empNullablesTable.addColumn("JOB", fixture.varchar10TypeNull);
        empNullablesTable.addColumn("MGR", fixture.intTypeNull);
        empNullablesTable.addColumn("HIREDATE", fixture.timestampTypeNull);
        empNullablesTable.addColumn("SAL", fixture.intTypeNull);
        empNullablesTable.addColumn("COMM", fixture.intTypeNull);
        empNullablesTable.addColumn("DEPTNO", fixture.intTypeNull);
        empNullablesTable.addColumn("SLACKER", fixture.booleanTypeNull);
        this.registerTable(empNullablesTable);
    }

    private void registerTableEmpDefaults(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable empDefaultsTable = MockCatalogReader.MockTable.create(this, salesSchema, "EMPDEFAULTS", false, 14.0, null, (InitializerExpressionFactory)new EmpInitializerExpressionFactory(), false);
        empDefaultsTable.addColumn("EMPNO", fixture.intType, true);
        empDefaultsTable.addColumn("ENAME", fixture.varchar20Type);
        empDefaultsTable.addColumn("JOB", fixture.varchar10TypeNull);
        empDefaultsTable.addColumn("MGR", fixture.intTypeNull);
        empDefaultsTable.addColumn("HIREDATE", fixture.timestampTypeNull);
        empDefaultsTable.addColumn("SAL", fixture.intTypeNull);
        empDefaultsTable.addColumn("COMM", fixture.intTypeNull);
        empDefaultsTable.addColumn("DEPTNO", fixture.intTypeNull);
        empDefaultsTable.addColumn("SLACKER", fixture.booleanTypeNull);
        this.registerTable(empDefaultsTable);
    }

    private void registerTableEmpB(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable empBTable = MockCatalogReader.MockTable.create(this, salesSchema, "EMP_B", false, 14.0);
        empBTable.addColumn("EMPNO", fixture.intType, true);
        empBTable.addColumn("ENAME", fixture.varchar20Type);
        empBTable.addColumn("JOB", fixture.varchar10Type);
        empBTable.addColumn("MGR", fixture.intTypeNull);
        empBTable.addColumn("HIREDATE", fixture.timestampType);
        empBTable.addColumn("SAL", fixture.intType);
        empBTable.addColumn("COMM", fixture.intType);
        empBTable.addColumn("DEPTNO", fixture.intType);
        empBTable.addColumn("SLACKER", fixture.booleanType);
        empBTable.addColumn("BIRTHDATE", fixture.dateType);
        this.registerTable(empBTable);
    }

    private void registerTableDept(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable deptTable = MockCatalogReader.MockTable.create(this, salesSchema, "DEPT", false, 4.0);
        deptTable.addColumn("DEPTNO", fixture.intType, true);
        deptTable.addColumn("NAME", fixture.varchar10Type);
        this.registerTable(deptTable);
    }

    private void registerTableDeptNullables(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable deptNullablesTable = MockCatalogReader.MockTable.create(this, salesSchema, "DEPTNULLABLES", false, 4.0);
        deptNullablesTable.addColumn("DEPTNO", fixture.intTypeNull, true);
        deptNullablesTable.addColumn("NAME", fixture.varchar10TypeNull);
        this.registerTable(deptNullablesTable);
    }

    private void registerTableDeptSingle(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable deptSingleTable = MockCatalogReader.MockTable.create(this, salesSchema, "DEPT_SINGLE", false, 4.0);
        deptSingleTable.addColumn("SKILL", fixture.singleRecordType);
        this.registerTable(deptSingleTable);
    }

    private void registerTableDeptNested(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable deptNestedTable = MockCatalogReader.MockTable.create(this, salesSchema, "DEPT_NESTED", false, 4.0);
        deptNestedTable.addColumn("DEPTNO", fixture.intType, true);
        deptNestedTable.addColumn("NAME", fixture.varchar10Type);
        deptNestedTable.addColumn("SKILL", fixture.skillRecordType);
        deptNestedTable.addColumn("EMPLOYEES", fixture.empListType);
        this.registerTable(deptNestedTable);
    }

    private void registerTableDeptNestedExpanded(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable deptNestedExpandedTable = MockCatalogReader.MockTable.create(this, salesSchema, "DEPT_NESTED_EXPANDED", false, 4.0);
        deptNestedExpandedTable.addColumn("DEPTNO", fixture.intType, true);
        deptNestedExpandedTable.addColumn("NAME", fixture.varchar10Type);
        deptNestedExpandedTable.addColumn("EMPLOYEES", fixture.empListType);
        deptNestedExpandedTable.addColumn("ADMINS", fixture.varchar5ArrayType);
        deptNestedExpandedTable.addColumn("OFFICES", fixture.rectilinearPeekCoordMultisetType);
        this.registerTable(deptNestedExpandedTable);
    }

    private void registerTableBonus(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable bonusTable = MockCatalogReader.MockTable.create(this, salesSchema, "BONUS", false, 0.0);
        bonusTable.addColumn("ENAME", fixture.varchar20Type);
        bonusTable.addColumn("JOB", fixture.varchar10Type);
        bonusTable.addColumn("SAL", fixture.intType);
        bonusTable.addColumn("COMM", fixture.intType);
        this.registerTable(bonusTable);
    }

    private void registerTableSalgrade(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable salgradeTable = MockCatalogReader.MockTable.create(this, salesSchema, "SALGRADE", false, 5.0);
        salgradeTable.addColumn("GRADE", fixture.intType, true);
        salgradeTable.addColumn("LOSAL", fixture.intType);
        salgradeTable.addColumn("HISAL", fixture.intType);
        this.registerTable(salgradeTable);
    }

    private void registerTableEmpAddress(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable contactAddressTable = MockCatalogReader.MockTable.create(this, salesSchema, "EMP_ADDRESS", false, 26.0);
        contactAddressTable.addColumn("EMPNO", fixture.intType, true);
        contactAddressTable.addColumn("HOME_ADDRESS", (RelDataType)this.addressType);
        contactAddressTable.addColumn("MAILING_ADDRESS", (RelDataType)this.addressType);
        this.registerTable(contactAddressTable);
    }

    private void registerTableContact(MockCatalogReader.MockSchema customerSchema, Fixture fixture) {
        MockCatalogReader.MockTable contactTable = MockCatalogReader.MockTable.create(this, customerSchema, "CONTACT", false, 1000.0);
        contactTable.addColumn("CONTACTNO", fixture.intType);
        contactTable.addColumn("FNAME", fixture.varchar10Type);
        contactTable.addColumn("LNAME", fixture.varchar10Type);
        contactTable.addColumn("EMAIL", fixture.varchar20Type);
        contactTable.addColumn("COORD", fixture.rectilinearCoordType);
        this.registerTable(contactTable);
    }

    private void registerTableContactPeek(MockCatalogReader.MockSchema customerSchema, Fixture fixture) {
        MockCatalogReader.MockTable contactPeekTable = MockCatalogReader.MockTable.create(this, customerSchema, "CONTACT_PEEK", false, 1000.0);
        contactPeekTable.addColumn("CONTACTNO", fixture.intType);
        contactPeekTable.addColumn("FNAME", fixture.varchar10Type);
        contactPeekTable.addColumn("LNAME", fixture.varchar10Type);
        contactPeekTable.addColumn("EMAIL", fixture.varchar20Type);
        contactPeekTable.addColumn("COORD", fixture.rectilinearPeekCoordType);
        contactPeekTable.addColumn("COORD_NE", fixture.rectilinearPeekNoExpandCoordType);
        this.registerTable(contactPeekTable);
    }

    private void registerTableAccount(MockCatalogReader.MockSchema customerSchema, Fixture fixture) {
        MockCatalogReader.MockTable accountTable = MockCatalogReader.MockTable.create(this, customerSchema, "ACCOUNT", false, 457.0);
        accountTable.addColumn("ACCTNO", fixture.intType);
        accountTable.addColumn("TYPE", fixture.varchar20Type);
        accountTable.addColumn("BALANCE", fixture.intType);
        this.registerTable(accountTable);
    }

    private void registerTableOrders(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable ordersStream = MockCatalogReader.MockTable.create(this, salesSchema, "ORDERS", true, Double.POSITIVE_INFINITY);
        ordersStream.addColumn("ROWTIME", fixture.timestampType);
        ordersStream.addMonotonic("ROWTIME");
        ordersStream.addColumn("PRODUCTID", fixture.intType);
        ordersStream.addColumn("ORDERID", fixture.intType);
        this.registerTable(ordersStream);
    }

    private void registerTableShipments(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable shipmentsStream = MockCatalogReader.MockTable.create(this, salesSchema, "SHIPMENTS", true, Double.POSITIVE_INFINITY);
        shipmentsStream.addColumn("ORDERID", fixture.intType);
        shipmentsStream.addColumn("ROWTIME", fixture.timestampType);
        shipmentsStream.addMonotonic("ROWTIME");
        this.registerTable(shipmentsStream);
    }

    private void registerTableProducts(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable productsTable = MockCatalogReader.MockTable.create(this, salesSchema, "PRODUCTS", false, 200.0);
        productsTable.addColumn("PRODUCTID", fixture.intType);
        productsTable.addColumn("NAME", fixture.varchar20Type);
        productsTable.addColumn("SUPPLIERID", fixture.intType);
        this.registerTable(productsTable);
    }

    private void registerTableEmptyProducts(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable emptyProductsTable = MockCatalogReader.MockTable.create((MockCatalogReader)this, salesSchema, "EMPTY_PRODUCTS", false, 0.0, 0.0);
        emptyProductsTable.addColumn("PRODUCTID", fixture.intType);
        emptyProductsTable.addColumn("NAME", fixture.varchar20Type);
        emptyProductsTable.addColumn("SUPPLIERID", fixture.intType);
        this.registerTable(emptyProductsTable);
    }

    private void registerTableProductsTemporal(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable productsTemporalTable = MockCatalogReader.MockTable.create(this, salesSchema, "PRODUCTS_TEMPORAL", false, 200.0, null, NullInitializerExpressionFactory.INSTANCE, true);
        productsTemporalTable.addColumn("PRODUCTID", fixture.intType);
        productsTemporalTable.addColumn("NAME", fixture.varchar20Type);
        productsTemporalTable.addColumn("SUPPLIERID", fixture.intType);
        productsTemporalTable.addColumn("SYS_START", fixture.timestampType);
        productsTemporalTable.addColumn("SYS_END", fixture.timestampType);
        productsTemporalTable.addColumn("SYS_START_LOCAL_TIMESTAMP", fixture.timestampTypeWithLocalTimeZone);
        productsTemporalTable.addColumn("SYS_END_LOCAL_TIMESTAMP", fixture.timestampTypeWithLocalTimeZone);
        this.registerTable(productsTemporalTable);
    }

    private void registerTableSuppliers(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable suppliersTable = MockCatalogReader.MockTable.create(this, salesSchema, "SUPPLIERS", false, 10.0);
        suppliersTable.addColumn("SUPPLIERID", fixture.intType);
        suppliersTable.addColumn("NAME", fixture.varchar20Type);
        suppliersTable.addColumn("CITY", fixture.intType);
        this.registerTable(suppliersTable);
    }

    private void registerViewEmp20(MockCatalogReader.MockSchema salesSchema, MockCatalogReader.MockTable empTable, Fixture fixture) {
        ImmutableIntList m0 = ImmutableIntList.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 8});
        MockCatalogReader.MockViewTable emp20View = new MockCatalogReader.MockViewTable(this, salesSchema.getCatalogName(), salesSchema.getName(), "EMP_20", false, 600.0, empTable, m0, null, NullInitializerExpressionFactory.INSTANCE){

            @Override
            public RexNode getConstraint(RexBuilder rexBuilder, RelDataType tableRowType) {
                RelDataTypeField deptnoField = (RelDataTypeField)tableRowType.getFieldList().get(7);
                RelDataTypeField salField = (RelDataTypeField)tableRowType.getFieldList().get(5);
                List<RexNode> nodes = Arrays.asList(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef(deptnoField.getType(), deptnoField.getIndex()), rexBuilder.makeExactLiteral(BigDecimal.valueOf(20L), deptnoField.getType())}), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{rexBuilder.makeInputRef(salField.getType(), salField.getIndex()), rexBuilder.makeExactLiteral(BigDecimal.valueOf(1000L), salField.getType())}));
                return RexUtil.composeConjunction((RexBuilder)rexBuilder, nodes);
            }
        };
        salesSchema.addTable((String)Util.last(emp20View.getQualifiedName()));
        emp20View.addColumn("EMPNO", fixture.intType);
        emp20View.addColumn("ENAME", fixture.varchar20Type);
        emp20View.addColumn("JOB", fixture.varchar10Type);
        emp20View.addColumn("MGR", fixture.intTypeNull);
        emp20View.addColumn("HIREDATE", fixture.timestampType);
        emp20View.addColumn("SAL", fixture.intType);
        emp20View.addColumn("COMM", fixture.intType);
        emp20View.addColumn("SLACKER", fixture.booleanType);
        this.registerTable(emp20View);
    }

    private void registerViewEmpNullables20(MockCatalogReader.MockSchema salesSchema, MockCatalogReader.MockTable empNullablesTable, Fixture fixture) {
        ImmutableIntList m0 = ImmutableIntList.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 8});
        MockCatalogReader.MockViewTable empNullables20View = new MockCatalogReader.MockViewTable(this, salesSchema.getCatalogName(), salesSchema.getName(), "EMPNULLABLES_20", false, 600.0, empNullablesTable, m0, null, NullInitializerExpressionFactory.INSTANCE){

            @Override
            public RexNode getConstraint(RexBuilder rexBuilder, RelDataType tableRowType) {
                RelDataTypeField deptnoField = (RelDataTypeField)tableRowType.getFieldList().get(7);
                RelDataTypeField salField = (RelDataTypeField)tableRowType.getFieldList().get(5);
                List<RexNode> nodes = Arrays.asList(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef(deptnoField.getType(), deptnoField.getIndex()), rexBuilder.makeExactLiteral(BigDecimal.valueOf(20L), deptnoField.getType())}), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{rexBuilder.makeInputRef(salField.getType(), salField.getIndex()), rexBuilder.makeExactLiteral(BigDecimal.valueOf(1000L), salField.getType())}));
                return RexUtil.composeConjunction((RexBuilder)rexBuilder, nodes);
            }
        };
        salesSchema.addTable((String)Util.last(empNullables20View.getQualifiedName()));
        empNullables20View.addColumn("EMPNO", fixture.intType);
        empNullables20View.addColumn("ENAME", fixture.varchar20TypeNull);
        empNullables20View.addColumn("JOB", fixture.varchar10TypeNull);
        empNullables20View.addColumn("MGR", fixture.intTypeNull);
        empNullables20View.addColumn("HIREDATE", fixture.timestampTypeNull);
        empNullables20View.addColumn("SAL", fixture.intTypeNull);
        empNullables20View.addColumn("COMM", fixture.intTypeNull);
        empNullables20View.addColumn("SLACKER", fixture.booleanTypeNull);
        this.registerTable(empNullables20View);
    }

    private void registerStructTypeTables(Fixture fixture) {
        MockCatalogReader.MockSchema structTypeSchema = new MockCatalogReader.MockSchema("STRUCT");
        this.registerSchema(structTypeSchema);
        List<CompoundNameColumn> columns = Arrays.asList(new CompoundNameColumn("", "K0", fixture.varchar20Type), new CompoundNameColumn("", "C1", fixture.varchar20Type), new CompoundNameColumn("F1", "A0", fixture.intType), new CompoundNameColumn("F2", "A0", fixture.booleanType), new CompoundNameColumn("F0", "C0", fixture.intType), new CompoundNameColumn("F1", "C0", fixture.intTypeNull), new CompoundNameColumn("F0", "C1", fixture.intType), new CompoundNameColumn("F1", "C2", fixture.intType), new CompoundNameColumn("F2", "C3", fixture.intType));
        CompoundNameColumnResolver structTypeTableResolver = new CompoundNameColumnResolver(columns, "F0");
        MockCatalogReader.MockTable structTypeTable = MockCatalogReader.MockTable.create((MockCatalogReader)this, structTypeSchema, "T", false, 100.0, structTypeTableResolver);
        for (CompoundNameColumn column : columns) {
            structTypeTable.addColumn(column.getName(), column.type);
        }
        this.registerTable(structTypeTable);
        List<CompoundNameColumn> columnsNullable = Arrays.asList(new CompoundNameColumn("", "K0", fixture.varchar20TypeNull), new CompoundNameColumn("", "C1", fixture.varchar20TypeNull), new CompoundNameColumn("F1", "A0", fixture.intTypeNull), new CompoundNameColumn("F2", "A0", fixture.booleanTypeNull), new CompoundNameColumn("F0", "C0", fixture.intTypeNull), new CompoundNameColumn("F1", "C0", fixture.intTypeNull), new CompoundNameColumn("F0", "C1", fixture.intTypeNull), new CompoundNameColumn("F1", "C2", fixture.intType), new CompoundNameColumn("F2", "C3", fixture.intTypeNull));
        MockCatalogReader.MockTable structNullableTypeTable = MockCatalogReader.MockTable.create((MockCatalogReader)this, structTypeSchema, "T_NULLABLES", false, 100.0, structTypeTableResolver);
        for (CompoundNameColumn column : columnsNullable) {
            structNullableTypeTable.addColumn(column.getName(), column.type);
        }
        this.registerTable(structNullableTypeTable);
        ImmutableIntList m1 = ImmutableIntList.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8});
        MockCatalogReader.MockViewTable struct10View = new MockCatalogReader.MockViewTable(this, structTypeSchema.getCatalogName(), structTypeSchema.getName(), "T_10", false, 20.0, structTypeTable, m1, structTypeTableResolver, NullInitializerExpressionFactory.INSTANCE){

            @Override
            public RexNode getConstraint(RexBuilder rexBuilder, RelDataType tableRowType) {
                RelDataTypeField c0Field = (RelDataTypeField)tableRowType.getFieldList().get(4);
                return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef(c0Field.getType(), c0Field.getIndex()), rexBuilder.makeExactLiteral(BigDecimal.valueOf(10L), c0Field.getType())});
            }
        };
        structTypeSchema.addTable((String)Util.last(struct10View.getQualifiedName()));
        for (CompoundNameColumn column : columns) {
            struct10View.addColumn(column.getName(), column.type);
        }
        this.registerTable(struct10View);
    }

    private void registerTableDoublePK(MockCatalogReader.MockSchema salesSchema, Fixture fixture) {
        MockCatalogReader.MockTable doublePK = MockCatalogReader.MockTable.create(this, salesSchema, "DOUBLE_PK", false, 14.0);
        doublePK.addColumn("ID1", fixture.intType, true);
        doublePK.addColumn("ID2", fixture.varchar20Type);
        doublePK.addColumn("NAME", fixture.varchar20Type);
        doublePK.addColumn("AGE", fixture.intType);
        doublePK.keyList.add(ImmutableBitSet.of((int[])new int[]{0, 1}));
        this.registerTable(doublePK);
    }

    @Override
    public MockCatalogReaderSimple init() {
        Fixture fixture = new Fixture(this.typeFactory);
        MockCatalogReader.MockSchema salesSchema = new MockCatalogReader.MockSchema("SALES");
        this.registerSchema(salesSchema);
        CountingFactory countingInitializerExpressionFactory = new CountingFactory((List<String>)ImmutableList.of((Object)"DEPTNO"));
        this.registerType((List<String>)ImmutableList.of((Object)salesSchema.getCatalogName(), (Object)salesSchema.getName(), (Object)"customBigInt"), typeFactory -> typeFactory.createSqlType(SqlTypeName.BIGINT));
        MockCatalogReader.MockTable empTable = MockCatalogReader.MockTable.create(this, salesSchema, "EMP", false, 14.0, null, (InitializerExpressionFactory)countingInitializerExpressionFactory, false);
        this.registerTableEmp(empTable, fixture);
        MockCatalogReader.MockTable empNullablesTable = MockCatalogReader.MockTable.create(this, salesSchema, "EMPNULLABLES", false, 14.0);
        this.registerTableEmpNullables(empNullablesTable, fixture);
        this.registerTableEmpDefaults(salesSchema, fixture);
        this.registerTableEmpB(salesSchema, fixture);
        this.registerTableDept(salesSchema, fixture);
        this.registerTableDeptNullables(salesSchema, fixture);
        this.registerTableDeptSingle(salesSchema, fixture);
        this.registerTableDeptNested(salesSchema, fixture);
        this.registerTableDeptNestedExpanded(salesSchema, fixture);
        this.registerTableBonus(salesSchema, fixture);
        this.registerTableSalgrade(salesSchema, fixture);
        this.registerTableEmpAddress(salesSchema, fixture);
        MockCatalogReader.MockSchema customerSchema = new MockCatalogReader.MockSchema("CUSTOMER");
        this.registerSchema(customerSchema);
        this.registerTableContact(customerSchema, fixture);
        this.registerTableContactPeek(customerSchema, fixture);
        this.registerTableAccount(customerSchema, fixture);
        this.registerTableOrders(salesSchema, fixture);
        this.registerTableShipments(salesSchema, fixture);
        this.registerTableProducts(salesSchema, fixture);
        this.registerTableEmptyProducts(salesSchema, fixture);
        this.registerTableProductsTemporal(salesSchema, fixture);
        this.registerTableSuppliers(salesSchema, fixture);
        this.registerViewEmp20(salesSchema, empTable, fixture);
        this.registerViewEmpNullables20(salesSchema, empNullablesTable, fixture);
        this.registerStructTypeTables(fixture);
        this.registerTablesWithRollUp(salesSchema, fixture);
        this.registerTableDoublePK(salesSchema, fixture);
        return this;
    }
}

