/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.Lex;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.parser.StringAndPos;
import org.apache.calcite.sql.test.AbstractSqlTester;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.test.SqlTests;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.test.catalog.MockCatalogReaderExtended;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

public class SqlValidatorFixture {
    public final SqlTester tester;
    public final SqlTestFactory factory;
    public final StringAndPos sap;
    public final boolean expression;
    public final boolean whole;

    protected SqlValidatorFixture(SqlTester tester, SqlTestFactory factory, StringAndPos sap, boolean expression, boolean whole) {
        this.tester = tester;
        this.factory = factory;
        this.expression = expression;
        this.sap = sap;
        this.whole = whole;
    }

    public SqlValidatorFixture withTester(UnaryOperator<SqlTester> transform) {
        SqlTester tester = (SqlTester)transform.apply(this.tester);
        return new SqlValidatorFixture(tester, this.factory, this.sap, this.expression, this.whole);
    }

    public SqlValidatorFixture withFactory(UnaryOperator<SqlTestFactory> transform) {
        SqlTestFactory factory = (SqlTestFactory)transform.apply(this.factory);
        return new SqlValidatorFixture(this.tester, factory, this.sap, this.expression, this.whole);
    }

    public SqlValidatorFixture withParserConfig(UnaryOperator<SqlParser.Config> transform) {
        return this.withFactory(f -> f.withParserConfig(transform));
    }

    public SqlParser.Config parserConfig() {
        return this.factory.parserConfig();
    }

    public SqlValidatorFixture withSql(String sql) {
        StringAndPos sap = StringAndPos.of((String)sql);
        return new SqlValidatorFixture(this.tester, this.factory, sap, false, false);
    }

    public SqlValidatorFixture withExpr(String sql) {
        StringAndPos sap = StringAndPos.of((String)sql);
        return new SqlValidatorFixture(this.tester, this.factory, sap, true, false);
    }

    public StringAndPos toSql(boolean withCaret) {
        return this.expression ? AbstractSqlTester.buildQueryWithPos(this.sap) : this.sap;
    }

    public SqlValidatorFixture withExtendedCatalog() {
        return this.withCatalogReader(MockCatalogReaderExtended::create);
    }

    public SqlValidatorFixture withCatalogReader(SqlTestFactory.CatalogReaderFactory catalogReaderFactory) {
        return this.withFactory(f -> f.withCatalogReader(catalogReaderFactory));
    }

    public SqlValidatorFixture withQuoting(Quoting quoting) {
        return this.withParserConfig(config -> config.withQuoting(quoting));
    }

    public SqlValidatorFixture withLex(Lex lex) {
        return this.withParserConfig(c -> c.withQuoting(lex.quoting).withCaseSensitive(lex.caseSensitive).withQuotedCasing(lex.quotedCasing).withUnquotedCasing(lex.unquotedCasing));
    }

    public SqlValidatorFixture withConformance(SqlConformance conformance) {
        return this.withValidatorConfig(c -> c.withConformance(conformance)).withParserConfig(c -> c.withConformance(conformance)).withFactory(f -> conformance instanceof SqlConformanceEnum ? f.withConnectionFactory(cf -> cf.with((ConnectionProperty)CalciteConnectionProperty.CONFORMANCE, (Object)conformance)) : f);
    }

    public SqlConformance conformance() {
        return this.factory.parserConfig().conformance();
    }

    public SqlValidatorFixture withTypeCoercion(boolean typeCoercion) {
        return this.withValidatorConfig(c -> c.withTypeCoercionEnabled(typeCoercion));
    }

    public SqlValidatorFixture withLenientOperatorLookup(boolean lenient) {
        return this.withValidatorConfig(c -> c.withLenientOperatorLookup(lenient));
    }

    public SqlValidatorFixture withWhole(boolean whole) {
        Preconditions.checkArgument((this.sap.cursor < 0 ? 1 : 0) != 0);
        StringAndPos sap = StringAndPos.of((String)("^" + this.sap.sql + "^"));
        return new SqlValidatorFixture(this.tester, this.factory, sap, this.expression, whole);
    }

    public SqlValidatorFixture ok() {
        this.tester.assertExceptionIsThrown(this.factory, this.toSql(false), null);
        return this;
    }

    public SqlValidatorFixture fails(String expected) {
        Objects.requireNonNull(expected, "expected");
        this.tester.assertExceptionIsThrown(this.factory, this.toSql(true), expected);
        return this;
    }

    public SqlValidatorFixture failsIf(boolean b, String expected) {
        if (b) {
            this.fails(expected);
        } else {
            this.ok();
        }
        return this;
    }

    public SqlValidatorFixture type(String expectedType) {
        this.tester.validateAndThen(this.factory, this.sap, (sql1, validator, n) -> {
            RelDataType actualType = validator.getValidatedNodeType(n);
            String actual = SqlTests.getTypeString(actualType);
            MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.is((Object)expectedType));
        });
        return this;
    }

    public SqlValidatorFixture type(Consumer<RelDataType> check) {
        this.tester.validateAndThen(this.factory, this.sap, (sql, validator, n) -> {
            RelDataType actualType = validator.getValidatedNodeType(n);
            check.accept(actualType);
        });
        return this;
    }

    public SqlValidatorFixture columnType(String expectedType) {
        this.tester.checkColumnType(this.factory, this.toSql((boolean)false).sql, expectedType);
        return this;
    }

    public SqlValidatorFixture assertMeasure(int column, Matcher<Boolean> matcher) {
        this.tester.validateAndThen(this.factory, this.sap, (sql1, validator, n) -> {
            SqlNode selectItem = ((SqlSelect)n).getSelectList().get(column);
            boolean isMeasure = SqlValidatorUtil.isMeasure((SqlNode)selectItem);
            MatcherAssert.assertThat((Object)isMeasure, (Matcher)matcher);
        });
        return this;
    }

    public SqlValidatorFixture assertMonotonicity(Matcher<SqlMonotonicity> matcher) {
        this.tester.validateAndThen(this.factory, this.toSql(false), (sap, validator, n) -> {
            RelDataType rowType = validator.getValidatedNodeType(n);
            SqlValidatorNamespace selectNamespace = validator.getNamespace(n);
            String field0 = ((RelDataTypeField)rowType.getFieldList().get(0)).getName();
            SqlMonotonicity monotonicity = selectNamespace.getMonotonicity(field0);
            MatcherAssert.assertThat((Object)monotonicity, (Matcher)matcher);
        });
        return this;
    }

    public SqlValidatorFixture assertBindType(Matcher<String> matcher) {
        this.tester.validateAndThen(this.factory, this.sap, (sap, validator, validatedNode) -> {
            RelDataType parameterRowType = validator.getParameterRowType(validatedNode);
            MatcherAssert.assertThat((Object)parameterRowType, (Matcher)Matchers.hasToString((Matcher)matcher));
        });
        return this;
    }

    public void assertCharset(Matcher<Charset> charsetMatcher) {
        this.tester.forEachQuery(this.factory, this.sap.addCarets(), query -> this.tester.validateAndThen(this.factory, StringAndPos.of((String)query), (sap, validator, n) -> {
            RelDataType rowType = validator.getValidatedNodeType(n);
            List fields = rowType.getFieldList();
            MatcherAssert.assertThat((String)"expected query to return 1 field", (Object)fields.size(), (Matcher)CoreMatchers.is((Object)1));
            RelDataType actualType = ((RelDataTypeField)fields.get(0)).getType();
            Charset actualCharset = actualType.getCharset();
            MatcherAssert.assertThat((Object)actualCharset, (Matcher)charsetMatcher);
        }));
    }

    public void assertCollation(Matcher<String> collationMatcher, Matcher<SqlCollation.Coercibility> coercibilityMatcher) {
        this.tester.forEachQuery(this.factory, this.sap.addCarets(), query -> this.tester.validateAndThen(this.factory, StringAndPos.of((String)query), (sap, validator, n) -> {
            RelDataType rowType = validator.getValidatedNodeType(n);
            List fields = rowType.getFieldList();
            MatcherAssert.assertThat((String)"expected query to return 1 field", (Object)fields.size(), (Matcher)CoreMatchers.is((Object)1));
            RelDataType actualType = ((RelDataTypeField)fields.get(0)).getType();
            SqlCollation collation = actualType.getCollation();
            MatcherAssert.assertThat((Object)collation, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)collation.getCollationName(), (Matcher)collationMatcher);
            MatcherAssert.assertThat((Object)collation.getCoercibility(), (Matcher)coercibilityMatcher);
        }));
    }

    public void assertInterval(Matcher<Long> matcher) {
        this.tester.validateAndThen(this.factory, this.toSql(false), (sap, validator, validatedNode) -> {
            SqlCall n = (SqlCall)validatedNode;
            SqlNode node = null;
            for (int i = 0; i < n.operandCount(); ++i) {
                node = SqlUtil.stripAs((SqlNode)n.operand(i));
                if (!(node instanceof SqlCall)) continue;
                node = ((SqlCall)node).operand(0);
                break;
            }
            Assertions.assertNotNull(node);
            SqlIntervalLiteral intervalLiteral = (SqlIntervalLiteral)node;
            SqlIntervalLiteral.IntervalValue interval = (SqlIntervalLiteral.IntervalValue)intervalLiteral.getValueAs(SqlIntervalLiteral.IntervalValue.class);
            long l = interval.getIntervalQualifier().isYearMonth() ? SqlParserUtil.intervalToMonths((SqlIntervalLiteral.IntervalValue)interval) : SqlParserUtil.intervalToMillis((SqlIntervalLiteral.IntervalValue)interval);
            MatcherAssert.assertThat((Object)l, (Matcher)matcher);
        });
    }

    public SqlValidatorFixture withCaseSensitive(boolean caseSensitive) {
        return this.withParserConfig(c -> c.withCaseSensitive(caseSensitive));
    }

    public SqlValidatorFixture withOperatorTable(SqlOperatorTable operatorTable) {
        return this.withFactory(c -> c.withOperatorTable(o -> operatorTable));
    }

    public SqlValidatorFixture withQuotedCasing(Casing casing) {
        return this.withParserConfig(c -> c.withQuotedCasing(casing));
    }

    public SqlValidatorFixture withUnquotedCasing(Casing casing) {
        return this.withParserConfig(c -> c.withUnquotedCasing(casing));
    }

    public SqlValidatorFixture withValidatorConfig(UnaryOperator<SqlValidator.Config> transform) {
        return this.withFactory(f -> f.withValidatorConfig(transform));
    }

    public SqlValidatorFixture withValidatorIdentifierExpansion(boolean expansion) {
        return this.withValidatorConfig(c -> c.withIdentifierExpansion(expansion));
    }

    public SqlValidatorFixture withValidatorCallRewrite(boolean rewrite) {
        return this.withValidatorConfig(c -> c.withCallRewrite(rewrite));
    }

    public SqlValidatorFixture withValidatorColumnReferenceExpansion(boolean expansion) {
        return this.withValidatorConfig(c -> c.withColumnReferenceExpansion(expansion));
    }

    public SqlValidatorFixture rewritesTo(String expected) {
        this.tester.validateAndThen(this.factory, this.toSql(false), (sap, validator, validatedNode) -> {
            String actualRewrite = validatedNode.toSqlString(AnsiSqlDialect.DEFAULT, false).getSql();
            TestUtil.assertEqualsVerbose(expected, Util.toLinux((String)actualRewrite));
        });
        return this;
    }

    public SqlValidatorFixture isAggregate(Matcher<Boolean> matcher) {
        this.tester.validateAndThen(this.factory, this.toSql(false), (sap, validator, validatedNode) -> MatcherAssert.assertThat((Object)validator.isAggregate((SqlSelect)validatedNode), (Matcher)matcher));
        return this;
    }

    public SqlValidatorFixture assertFieldOrigin(Matcher<String> matcher) {
        this.tester.validateAndThen(this.factory, this.toSql(false), (sap, validator, n) -> {
            List list = validator.getFieldOrigins(n);
            StringBuilder buf = new StringBuilder("{");
            int i = 0;
            for (List strings : list) {
                if (i++ > 0) {
                    buf.append(", ");
                }
                if (strings == null) {
                    buf.append("null");
                    continue;
                }
                int j = 0;
                for (String s : strings) {
                    if (j++ > 0) {
                        buf.append('.');
                    }
                    buf.append(s);
                }
            }
            buf.append("}");
            MatcherAssert.assertThat((Object)buf, (Matcher)Matchers.hasToString((Matcher)matcher));
        });
        return this;
    }

    public void setFor(SqlOperator operator) {
    }
}

