/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.StringAndPos;
import org.apache.calcite.sql.test.ResultCheckers;
import org.apache.calcite.sql.test.SqlOperatorFixture;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.test.SqlTests;
import org.apache.calcite.sql.test.SqlValidatorTester;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.JdbcType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

class SqlOperatorFixtureImpl
implements SqlOperatorFixture {
    public static final SqlOperatorFixtureImpl DEFAULT = new SqlOperatorFixtureImpl(SqlTestFactory.INSTANCE, SqlValidatorTester.DEFAULT, false);
    private final SqlTestFactory factory;
    private final SqlTester tester;
    private final boolean brokenTestsEnabled;

    SqlOperatorFixtureImpl(SqlTestFactory factory, SqlTester tester, boolean brokenTestsEnabled) {
        this.factory = Objects.requireNonNull(factory, "factory");
        this.tester = Objects.requireNonNull(tester, "tester");
        this.brokenTestsEnabled = brokenTestsEnabled;
    }

    @Override
    public void close() {
    }

    @Override
    public SqlTestFactory getFactory() {
        return this.factory;
    }

    @Override
    public SqlTester getTester() {
        return this.tester;
    }

    @Override
    public SqlOperatorFixture withFactory(UnaryOperator<SqlTestFactory> transform) {
        SqlTestFactory factory = (SqlTestFactory)transform.apply(this.factory);
        if (factory == this.factory) {
            return this;
        }
        return new SqlOperatorFixtureImpl(factory, this.tester, this.brokenTestsEnabled);
    }

    @Override
    public SqlOperatorFixture withTester(UnaryOperator<SqlTester> transform) {
        SqlTester tester = (SqlTester)transform.apply(this.tester);
        if (tester == this.tester) {
            return this;
        }
        return new SqlOperatorFixtureImpl(this.factory, tester, this.brokenTestsEnabled);
    }

    @Override
    public boolean brokenTestsEnabled() {
        return this.brokenTestsEnabled;
    }

    @Override
    public SqlOperatorFixture withBrokenTestsEnabled(boolean brokenTestsEnabled) {
        if (brokenTestsEnabled == this.brokenTestsEnabled) {
            return this;
        }
        return new SqlOperatorFixtureImpl(this.factory, this.tester, brokenTestsEnabled);
    }

    @Override
    public SqlOperatorFixture setFor(SqlOperator operator, SqlOperatorFixture.VmName ... unimplementedVmNames) {
        return this;
    }

    SqlNode parseAndValidate(SqlValidator validator, String sql) {
        SqlNode sqlNode;
        try {
            sqlNode = this.tester.parseQuery(this.factory, sql);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while parsing query: " + sql, e);
        }
        return validator.validate(sqlNode);
    }

    @Override
    public void checkColumnType(String sql, String expected) {
        this.tester.validateAndThen(this.factory, StringAndPos.of((String)sql), SqlOperatorFixtureImpl.checkColumnTypeAction((Matcher<String>)CoreMatchers.is((Object)expected)));
    }

    @Override
    public void checkType(String expression, String type) {
        this.forEachQueryValidateAndThen(StringAndPos.of((String)expression), SqlOperatorFixtureImpl.checkColumnTypeAction((Matcher<String>)CoreMatchers.is((Object)type)));
    }

    private static SqlTester.ValidatedNodeConsumer checkColumnTypeAction(Matcher<String> matcher) {
        return (sql, validator, validatedNode) -> {
            RelDataType rowType = validator.getValidatedNodeType(validatedNode);
            List fields = rowType.getFieldList();
            MatcherAssert.assertThat((String)"expected query to return 1 field", (Object)fields, (Matcher)Matchers.hasSize((int)1));
            RelDataType actualType = ((RelDataTypeField)fields.get(0)).getType();
            String actual = SqlTests.getTypeString(actualType);
            MatcherAssert.assertThat((String)("Query: " + sql.sql), (Object)actual, (Matcher)matcher);
        };
    }

    @Override
    public void checkQuery(String sql) {
        this.tester.assertExceptionIsThrown(this.factory, StringAndPos.of((String)sql), null);
    }

    void forEachQueryValidateAndThen(StringAndPos expression, SqlTester.ValidatedNodeConsumer consumer) {
        this.tester.forEachQuery(this.factory, expression.addCarets(), query -> this.tester.validateAndThen(this.factory, StringAndPos.of((String)query), consumer));
    }

    @Override
    public void checkFails(StringAndPos sap, String expectedError, boolean runtime) {
        if (runtime) {
            String sql = "values (" + sap.sql + ")";
            SqlValidator validator = this.factory.createValidator();
            SqlNode n = this.parseAndValidate(validator, sql);
            Assertions.assertNotNull((Object)n);
            this.tester.checkFails(this.factory, sap, expectedError, runtime);
        } else {
            String sql = "values (" + sap.addCarets() + ")";
            this.checkQueryFails(StringAndPos.of((String)sql), expectedError);
        }
    }

    @Override
    public void checkQueryFails(StringAndPos sap, String expectedError) {
        this.tester.assertExceptionIsThrown(this.factory, sap, expectedError);
    }

    @Override
    public void checkAggFails(String expr, String[] inputValues, String expectedError, boolean runtime) {
        String sql = SqlTests.generateAggQuery(expr, inputValues);
        if (runtime) {
            SqlValidator validator = this.factory.createValidator();
            SqlNode n = this.parseAndValidate(validator, sql);
            Assertions.assertNotNull((Object)n);
            this.tester.checkAggFails(this.factory, expr, inputValues, expectedError, runtime);
        } else {
            this.checkQueryFails(StringAndPos.of((String)sql), expectedError);
        }
    }

    @Override
    public void checkAgg(String expr, String[] inputValues, SqlTester.ResultChecker checker) {
        this.checkAgg(expr, inputValues, SqlTests.ANY_TYPE_CHECKER, checker);
    }

    @Override
    public void checkAgg(String expr, String[] inputValues, String type, SqlTester.ResultChecker checker) {
        SqlTests.StringTypeChecker typeChecker = new SqlTests.StringTypeChecker(type);
        this.checkAgg(expr, inputValues, typeChecker, checker);
    }

    private void checkAgg(String expr, String[] inputValues, SqlTester.TypeChecker typeChecker, SqlTester.ResultChecker resultChecker) {
        String query = SqlTests.generateAggQuery(expr, inputValues);
        this.tester.check(this.factory, query, typeChecker, resultChecker);
    }

    @Override
    public void checkAggWithMultipleArgs(String expr, String[][] inputValues, SqlTester.ResultChecker resultChecker) {
        String query = SqlTests.generateAggQueryWithMultipleArgs(expr, inputValues);
        this.tester.check(this.factory, query, SqlTests.ANY_TYPE_CHECKER, resultChecker);
    }

    @Override
    public void checkWinAgg(String expr, String[] inputValues, String windowSpec, String type, SqlTester.ResultChecker resultChecker) {
        SqlTests.StringTypeChecker typeChecker = new SqlTests.StringTypeChecker(type);
        String query = SqlTests.generateWinAggQuery(expr, windowSpec, inputValues);
        this.tester.check(this.factory, query, typeChecker, resultChecker);
    }

    @Override
    public void checkScalar(String expression, SqlTester.TypeChecker typeChecker, SqlTester.ResultChecker resultChecker) {
        this.tester.forEachQuery(this.factory, expression, sql -> this.tester.check(this.factory, (String)sql, typeChecker, resultChecker));
    }

    @Override
    public void checkScalarExact(String expression, String expectedType, SqlTester.ResultChecker resultChecker) {
        SqlTests.StringTypeChecker typeChecker = new SqlTests.StringTypeChecker(expectedType);
        this.tester.forEachQuery(this.factory, expression, sql -> this.tester.check(this.factory, (String)sql, typeChecker, resultChecker));
    }

    @Override
    public void checkScalarApprox(String expression, String expectedType, Object result) {
        SqlTests.StringTypeChecker typeChecker = new SqlTests.StringTypeChecker(expectedType);
        SqlTester.ResultChecker checker = ResultCheckers.createChecker(result);
        this.tester.forEachQuery(this.factory, expression, sql -> this.tester.check(this.factory, (String)sql, typeChecker, checker));
    }

    @Override
    public void checkBoolean(String expression, @Nullable Boolean result) {
        if (null == result) {
            this.checkNull(expression);
        } else {
            SqlTester.ResultChecker resultChecker = ResultCheckers.createChecker(CoreMatchers.is((Object)result), JdbcType.BOOLEAN);
            this.tester.forEachQuery(this.factory, expression, sql -> this.tester.check(this.factory, (String)sql, SqlTests.BOOLEAN_TYPE_CHECKER, SqlTests.ANY_PARAMETER_CHECKER, resultChecker));
        }
    }

    @Override
    public void checkString(String expression, String result, String expectedType) {
        SqlTests.StringTypeChecker typeChecker = new SqlTests.StringTypeChecker(expectedType);
        SqlTester.ResultChecker resultChecker = ResultCheckers.isSingle(result);
        this.tester.forEachQuery(this.factory, expression, sql -> this.tester.check(this.factory, (String)sql, typeChecker, resultChecker));
    }

    @Override
    public void checkNull(String expression) {
        this.tester.forEachQuery(this.factory, expression, sql -> this.tester.check(this.factory, (String)sql, SqlTests.ANY_NULLABLE_TYPE_CHECKER, ResultCheckers.isNullValue()));
    }
}

