/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCommonExpressionSuggester;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.DiffRepository;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;

public class RelSuggesterFixture {
    private final String sql;
    private final RelCommonExpressionSuggester suggester;
    private final DiffRepository diffRepo;
    private final SchemaPlus schema;

    public static RelSuggesterFixture of(Class<?> clazz, RelCommonExpressionSuggester suggester) {
        return new RelSuggesterFixture("?", suggester, DiffRepository.lookup(clazz), RelSuggesterFixture.defaultSchema());
    }

    private RelSuggesterFixture(String sql, RelCommonExpressionSuggester suggester, DiffRepository diffRepo, SchemaPlus schema) {
        this.sql = Objects.requireNonNull(sql, "sql");
        this.suggester = Objects.requireNonNull(suggester, "suggester");
        this.diffRepo = Objects.requireNonNull(diffRepo, "diffRepo");
        this.schema = Objects.requireNonNull(schema, "schema");
    }

    public RelSuggesterFixture withSql(String sql) {
        return new RelSuggesterFixture(sql, this.suggester, this.diffRepo, this.schema);
    }

    public void checkSuggestions() {
        RelNode rel = this.toRel(this.sql);
        AtomicInteger i = new AtomicInteger();
        this.suggester.suggest(rel, null).stream().map(RelOptUtil::toString).sorted().forEach(plan -> {
            String tag = "suggestion_" + i.getAndIncrement();
            this.diffRepo.assertEquals(tag, "${" + tag + "}", (String)plan);
        });
    }

    public void checkActualAndReferenceFiles() {
        this.diffRepo.checkActualAndReferenceFiles();
    }

    private RelNode toRel(String sql) {
        Planner planner = Frameworks.getPlanner((FrameworkConfig)Frameworks.newConfigBuilder().defaultSchema(this.schema).build());
        try {
            return planner.rel((SqlNode)planner.validate((SqlNode)planner.parse((String)sql))).rel;
        }
        catch (SqlParseException | RelConversionException | ValidationException e) {
            throw new RuntimeException(e);
        }
    }

    private static SchemaPlus defaultSchema() {
        SchemaPlus schema = CalciteSchema.createRootSchema((boolean)false, (boolean)false).plus();
        schema.add("EMP", (Table)new AbstractTable(){

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add("EMPNO", SqlTypeName.INTEGER).add("ENAME", SqlTypeName.VARCHAR).add("DEPTNO", SqlTypeName.INTEGER).build();
            }
        });
        schema.add("DEPT", (Table)new AbstractTable(){

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add("DEPTNO", SqlTypeName.INTEGER).add("DNAME", SqlTypeName.VARCHAR).add("EMPNO", SqlTypeName.INTEGER).build();
            }
        });
        return schema;
    }
}

