/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.MetadataHandlerProvider;
import org.apache.calcite.rel.metadata.ProxyingMetadataHandlerProvider;
import org.apache.calcite.rel.metadata.RelColumnOrigin;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.test.RelSupplier;
import org.apache.calcite.test.SqlToRelFixture;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

public class RelMetadataFixture {
    public static final RelMetadataFixture DEFAULT = new RelMetadataFixture(SqlToRelFixture.TESTER, SqlTestFactory.INSTANCE, MetadataConfig.JANINO, RelSupplier.NONE, false, r -> r).withFactory(f -> f.withValidatorConfig(c -> c.withIdentifierExpansion(true)).withSqlToRelConfig(c -> c.withRelBuilderConfigTransform(b -> b.withAggregateUnique(true).withPruneInputOfAggregate(false))));
    public final SqlTester tester;
    public final SqlTestFactory factory;
    public final MetadataConfig metadataConfig;
    public final RelSupplier relSupplier;
    public final boolean convertAsCalc;
    public final UnaryOperator<RelNode> relTransform;

    private RelMetadataFixture(SqlTester tester, SqlTestFactory factory, MetadataConfig metadataConfig, RelSupplier relSupplier, boolean convertAsCalc, UnaryOperator<RelNode> relTransform) {
        this.tester = tester;
        this.factory = factory;
        this.metadataConfig = metadataConfig;
        this.relSupplier = relSupplier;
        this.convertAsCalc = convertAsCalc;
        this.relTransform = relTransform;
    }

    public RelMetadataFixture withSql(String sql) {
        RelSupplier relSupplier = RelSupplier.of(sql);
        if (relSupplier.equals(this.relSupplier)) {
            return this;
        }
        return new RelMetadataFixture(this.tester, this.factory, this.metadataConfig, relSupplier, this.convertAsCalc, this.relTransform);
    }

    public RelMetadataFixture withConfig(UnaryOperator<SqlToRelConverter.Config> transform) {
        return this.withFactory(f -> f.withSqlToRelConfig(transform));
    }

    public RelMetadataFixture withRelBuilderConfig(UnaryOperator<RelBuilder.Config> transform) {
        return this.withConfig(c -> c.addRelBuilderConfigTransform(transform));
    }

    public RelMetadataFixture withRelFn(Function<RelBuilder, RelNode> relFn) {
        RelSupplier relSupplier = RelSupplier.of(builder -> {
            this.metadataConfig.applyMetadata(builder.getCluster());
            return (RelNode)relFn.apply((RelBuilder)builder);
        });
        if (relSupplier.equals(this.relSupplier)) {
            return this;
        }
        return new RelMetadataFixture(this.tester, this.factory, this.metadataConfig, relSupplier, this.convertAsCalc, this.relTransform);
    }

    public RelMetadataFixture withFactory(UnaryOperator<SqlTestFactory> transform) {
        SqlTestFactory factory = (SqlTestFactory)transform.apply(this.factory);
        return new RelMetadataFixture(this.tester, factory, this.metadataConfig, this.relSupplier, this.convertAsCalc, this.relTransform);
    }

    public RelMetadataFixture withTester(UnaryOperator<SqlTester> transform) {
        SqlTester tester = (SqlTester)transform.apply(this.tester);
        return new RelMetadataFixture(tester, this.factory, this.metadataConfig, this.relSupplier, this.convertAsCalc, this.relTransform);
    }

    public RelMetadataFixture withMetadataConfig(MetadataConfig metadataConfig) {
        if (metadataConfig.equals(this.metadataConfig)) {
            return this;
        }
        return new RelMetadataFixture(this.tester, this.factory, metadataConfig, this.relSupplier, this.convertAsCalc, this.relTransform);
    }

    public RelMetadataFixture convertingProjectAsCalc() {
        if (this.convertAsCalc) {
            return this;
        }
        return new RelMetadataFixture(this.tester, this.factory, this.metadataConfig, this.relSupplier, true, this.relTransform);
    }

    public RelMetadataFixture withCatalogReaderFactory(SqlTestFactory.CatalogReaderFactory catalogReaderFactory) {
        return this.withFactory(t -> t.withCatalogReader(catalogReaderFactory));
    }

    public RelMetadataFixture withCluster(UnaryOperator<RelOptCluster> factory) {
        return this.withFactory(f -> f.withCluster(factory));
    }

    public RelMetadataFixture withRelTransform(UnaryOperator<RelNode> relTransform) {
        UnaryOperator relTransform1 = this.relTransform.andThen(relTransform)::apply;
        return new RelMetadataFixture(this.tester, this.factory, this.metadataConfig, this.relSupplier, this.convertAsCalc, relTransform1);
    }

    RelNode sqlToRel(String sql) {
        return this.tester.convertSqlToRel((SqlTestFactory)this.factory, (String)sql, (boolean)false, (boolean)false).rel;
    }

    public RelNode toRel() {
        RelNode rel = this.relSupplier.apply2(this);
        this.metadataConfig.applyMetadata(rel.getCluster());
        if (this.convertAsCalc) {
            Project project = (Project)rel;
            Preconditions.checkArgument((boolean)project.getVariablesSet().isEmpty(), (Object)"Calc does not allow variables");
            RexProgram program = RexProgram.create((RelDataType)project.getInput().getRowType(), (List)project.getProjects(), null, (RelDataType)project.getRowType(), (RexBuilder)project.getCluster().getRexBuilder());
            return LogicalCalc.create((RelNode)project.getInput(), (RexProgram)program);
        }
        return (RelNode)this.relTransform.apply(rel);
    }

    public RelMetadataFixture assertCpuCost(Matcher<Double> matcher, String reason) {
        RelNode rel = this.toRel();
        RelOptCost cost = RelMetadataFixture.computeRelSelfCost(rel);
        MatcherAssert.assertThat((String)(reason + "\nsql:" + this.relSupplier + "\nplan:" + RelOptUtil.toString((RelNode)rel, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES)), (Object)cost.getCpu(), matcher);
        return this;
    }

    private static RelOptCost computeRelSelfCost(RelNode rel) {
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        VolcanoPlanner planner = new VolcanoPlanner();
        return rel.computeSelfCost((RelOptPlanner)planner, mq);
    }

    public RelMetadataFixture assertRowsUnique(Matcher<Boolean> matcher, String reason) {
        return this.assertRowsUnique(false, matcher, reason).assertRowsUnique(true, matcher, reason);
    }

    public RelMetadataFixture assertRowsUnique(boolean ignoreNulls, Matcher<Boolean> matcher, String reason) {
        RelNode rel = this.toRel();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        Boolean rowsUnique = mq.areRowsUnique(rel, ignoreNulls);
        MatcherAssert.assertThat((String)(reason + "\nsql:" + this.relSupplier + "\nplan:" + RelOptUtil.toString((RelNode)rel, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES)), (Object)rowsUnique, matcher);
        return this;
    }

    public RelMetadataFixture assertPercentageOriginalRows(Matcher<Double> matcher) {
        RelNode rel = this.toRel();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        Double result = mq.getPercentageOriginalRows(rel);
        Assertions.assertNotNull((Object)result);
        MatcherAssert.assertThat((Object)result, matcher);
        return this;
    }

    private RelMetadataFixture checkColumnOrigin(Consumer<Set<RelColumnOrigin>> action) {
        RelNode rel = this.toRel();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        Set columnOrigins = mq.getColumnOrigins(rel, 0);
        action.accept(columnOrigins);
        return this;
    }

    public RelMetadataFixture assertColumnOriginIsEmpty() {
        return this.checkColumnOrigin(result -> {
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((boolean)result.isEmpty());
        });
    }

    private static void checkColumnOrigin(RelColumnOrigin rco, String expectedTableName, String expectedColumnName, boolean expectedDerived) {
        RelOptTable actualTable = rco.getOriginTable();
        List actualTableName = actualTable.getQualifiedName();
        MatcherAssert.assertThat((Object)Iterables.getLast((Iterable)actualTableName), (Matcher)CoreMatchers.equalTo((Object)expectedTableName));
        MatcherAssert.assertThat((Object)((RelDataTypeField)actualTable.getRowType().getFieldList().get(rco.getOriginColumnOrdinal())).getName(), (Matcher)CoreMatchers.equalTo((Object)expectedColumnName));
        MatcherAssert.assertThat((Object)rco.isDerived(), (Matcher)CoreMatchers.equalTo((Object)expectedDerived));
    }

    public RelMetadataFixture assertColumnOriginSingle(String expectedTableName, String expectedColumnName, boolean expectedDerived) {
        return this.checkColumnOrigin(result -> {
            Assertions.assertNotNull((Object)result);
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasSize((int)1));
            RelColumnOrigin rco = (RelColumnOrigin)result.iterator().next();
            RelMetadataFixture.checkColumnOrigin(rco, expectedTableName, expectedColumnName, expectedDerived);
        });
    }

    public RelMetadataFixture assertColumnOriginDouble(String expectedTableName1, String expectedColumnName1, String expectedTableName2, String expectedColumnName2, boolean expectedDerived) {
        MatcherAssert.assertThat((String)"required so that the test mechanism works", (Object)expectedTableName1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)expectedTableName2)));
        return this.checkColumnOrigin(result -> {
            Assertions.assertNotNull((Object)result);
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasSize((int)2));
            for (RelColumnOrigin rco : result) {
                RelOptTable actualTable = rco.getOriginTable();
                List actualTableName = actualTable.getQualifiedName();
                String actualUnqualifiedName = (String)Iterables.getLast((Iterable)actualTableName);
                if (actualUnqualifiedName.equals(expectedTableName1)) {
                    RelMetadataFixture.checkColumnOrigin(rco, expectedTableName1, expectedColumnName1, expectedDerived);
                    continue;
                }
                RelMetadataFixture.checkColumnOrigin(rco, expectedTableName2, expectedColumnName2, expectedDerived);
            }
        });
    }

    public RelMetadataFixture assertThatUniqueKeysAre(ImmutableBitSet ... expectedUniqueKeys) {
        return this.assertThatUniqueKeysAre(false, expectedUniqueKeys);
    }

    public RelMetadataFixture assertThatUniqueKeysAre(boolean ignoreNulls, ImmutableBitSet ... expectedUniqueKeys) {
        RelNode rel = this.toRel();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        Set result = mq.getUniqueKeys(rel, ignoreNulls);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)("unique keys, sql: " + this.relSupplier + ", rel: " + RelOptUtil.toString((RelNode)rel)), (Object)ImmutableSortedSet.copyOf((Collection)result), (Matcher)CoreMatchers.is((Object)ImmutableSortedSet.copyOf((Comparable[])expectedUniqueKeys)));
        RelMetadataFixture.checkUniqueConsistent(rel, ignoreNulls);
        return this;
    }

    private static void checkUniqueConsistent(RelNode rel, boolean ignoreNulls) {
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        Set uniqueKeys = mq.getUniqueKeys(rel, ignoreNulls);
        MatcherAssert.assertThat((Object)uniqueKeys, (Matcher)CoreMatchers.notNullValue());
        for (ImmutableBitSet key : uniqueKeys) {
            Boolean result2 = mq.areColumnsUnique(rel, key, ignoreNulls);
            MatcherAssert.assertThat((String)("areColumnsUnique. key: " + key + ", uniqueKeys: " + uniqueKeys + ", rel: " + RelOptUtil.toString((RelNode)rel)), (Object)SqlFunctions.isTrue((Boolean)result2), (Matcher)CoreMatchers.is((Object)RelMetadataFixture.isUnique(uniqueKeys, key)));
        }
    }

    private static boolean isUnique(Set<ImmutableBitSet> uniqueKeys, ImmutableBitSet key) {
        for (ImmutableBitSet uniqueKey : uniqueKeys) {
            if (!key.contains(uniqueKey)) continue;
            return true;
        }
        return false;
    }

    public RelMetadataFixture assertThatRowCount(Matcher<Number> rowCountMatcher, Matcher<Number> minRowCountMatcher, Matcher<Number> maxRowCountMatcher) {
        RelNode rel = this.toRel();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        Double rowCount = mq.getRowCount(rel);
        MatcherAssert.assertThat((Object)rowCount, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)rowCount, rowCountMatcher);
        Double min = mq.getMinRowCount(rel);
        MatcherAssert.assertThat((Object)min, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)min, minRowCountMatcher);
        Double max = mq.getMaxRowCount(rel);
        MatcherAssert.assertThat((Object)max, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)max, maxRowCountMatcher);
        return this;
    }

    public RelMetadataFixture assertThatSelectivity(Matcher<Double> matcher) {
        RelNode rel = this.toRel();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        Double result = mq.getSelectivity(rel, null);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result, matcher);
        return this;
    }

    public RelMetadataFixture assertThatDistinctRowCount(ImmutableBitSet groupKey, Matcher<Double> matcher) {
        return this.assertThatDistinctRowCount((RelNode r) -> groupKey, matcher);
    }

    public RelMetadataFixture assertThatDistinctRowCount(Function<RelNode, ImmutableBitSet> groupKeyFn, Matcher<Double> matcher) {
        RelNode rel = this.toRel();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        ImmutableBitSet groupKey = groupKeyFn.apply(rel);
        Double result = mq.getDistinctRowCount(rel, groupKey, null);
        MatcherAssert.assertThat((Object)result, matcher);
        return this;
    }

    public RelMetadataFixture assertThatRel(Matcher<RelNode> matcher) {
        RelNode rel = this.toRel();
        MatcherAssert.assertThat((Object)rel, matcher);
        return this;
    }

    public RelMetadataFixture assertThatNodeTypeCountIs(Class<? extends RelNode> k0, Integer v0, Object ... rest) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put(k0, (Object)v0);
        int i = 0;
        while (i < rest.length) {
            b.put((Object)((Class)rest[i++]), (Object)((Integer)rest[i++]));
        }
        return this.assertThatNodeTypeCount((Matcher<Map<Class<? extends RelNode>, Integer>>)CoreMatchers.is((Object)b.build()));
    }

    public RelMetadataFixture assertThatNodeTypeCount(Matcher<Map<Class<? extends RelNode>, Integer>> matcher) {
        RelNode rel = this.toRel();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        Multimap result = mq.getNodeTypes(rel);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        HashMap resultCount = new HashMap();
        for (Map.Entry e : result.asMap().entrySet()) {
            resultCount.put(e.getKey(), ((Collection)e.getValue()).size());
        }
        MatcherAssert.assertThat(resultCount, matcher);
        return this;
    }

    public RelMetadataFixture assertThatUniqueKeys(Matcher<Iterable<ImmutableBitSet>> matcher) {
        RelNode rel = this.toRel();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        Set result = mq.getUniqueKeys(rel);
        MatcherAssert.assertThat((Object)result, matcher);
        return this;
    }

    public RelMetadataFixture assertThatAreColumnsUnique(ImmutableBitSet columns, Matcher<Boolean> matcher) {
        return this.assertThatAreColumnsUnique(r -> columns, r -> r, matcher);
    }

    public RelMetadataFixture assertThatAreColumnsUnique(Function<RelNode, ImmutableBitSet> columnsFn, UnaryOperator<RelNode> relFn, Matcher<Boolean> matcher) {
        RelNode rel = this.toRel();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        ImmutableBitSet columns = columnsFn.apply(rel);
        RelNode rel2 = (RelNode)relFn.apply(rel);
        Boolean areColumnsUnique = mq.areColumnsUnique(rel2, columns);
        MatcherAssert.assertThat((Object)areColumnsUnique, matcher);
        return this;
    }

    public RelMetadataFixture assertThatAreRowsUnique(Matcher<Boolean> matcher) {
        RelNode rel = this.toRel();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        Boolean areRowsUnique = mq.areRowsUnique(rel);
        MatcherAssert.assertThat((Object)areRowsUnique, matcher);
        return this;
    }

    public static class MetadataConfig {
        static final MetadataConfig JANINO = new MetadataConfig("Janino", JaninoRelMetadataProvider::of, RelMetadataQuery.THREAD_PROVIDERS::get, true);
        static final MetadataConfig PROXYING = new MetadataConfig("Proxying", ProxyingMetadataHandlerProvider::new, () -> DefaultRelMetadataProvider.INSTANCE, false);
        static final MetadataConfig NOP = new MetadataConfig("Nop", ProxyingMetadataHandlerProvider::new, () -> DefaultRelMetadataProvider.INSTANCE, false){

            @Override
            void applyMetadata(RelOptCluster cluster, RelMetadataProvider provider, Function<MetadataHandlerProvider, RelMetadataQuery> supplierFactory) {
            }
        };
        public final String name;
        public final Function<RelMetadataProvider, MetadataHandlerProvider> converter;
        public final Supplier<RelMetadataProvider> defaultProviderSupplier;
        public final boolean isCaching;

        public MetadataConfig(String name, Function<RelMetadataProvider, MetadataHandlerProvider> converter, Supplier<RelMetadataProvider> defaultProviderSupplier, boolean isCaching) {
            this.name = name;
            this.converter = converter;
            this.defaultProviderSupplier = defaultProviderSupplier;
            this.isCaching = isCaching;
        }

        public MetadataHandlerProvider getDefaultHandlerProvider() {
            return this.converter.apply(this.defaultProviderSupplier.get());
        }

        void applyMetadata(RelOptCluster cluster) {
            this.applyMetadata(cluster, this.defaultProviderSupplier.get());
        }

        void applyMetadata(RelOptCluster cluster, RelMetadataProvider provider) {
            this.applyMetadata(cluster, provider, RelMetadataQuery::new);
        }

        void applyMetadata(RelOptCluster cluster, RelMetadataProvider provider, Function<MetadataHandlerProvider, RelMetadataQuery> supplierFactory) {
            cluster.setMetadataProvider(provider);
            cluster.setMetadataQuerySupplier(() -> (RelMetadataQuery)supplierFactory.apply(this.converter.apply(provider)));
            cluster.invalidateMetadataQuery();
        }

        public boolean isCaching() {
            return this.isCaching;
        }

        public String toString() {
            return this.name;
        }
    }
}

