/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import com.google.common.io.PatternFilenameFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hydromatic.quidem.AbstractCommand;
import net.hydromatic.quidem.Command;
import net.hydromatic.quidem.CommandHandler;
import net.hydromatic.quidem.Quidem;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.ConnectionSpec;
import org.apache.calcite.test.DiffTestCase;
import org.apache.calcite.test.ReflectiveSchemaWithoutRowCount;
import org.apache.calcite.test.schemata.catchall.CatchallSchema;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.apache.calcite.util.Closer;
import org.apache.calcite.util.Sources;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class QuidemTest {
    private static final Pattern PATTERN = Pattern.compile("\\.iq$");
    private static @Nullable List<RelOptRule> originalRules;

    private static @Nullable Object getEnv(String varName) {
        switch (varName) {
            case "jdk18": {
                return System.getProperty("java.version").startsWith("1.8");
            }
            case "fixed": {
                return v -> {
                    switch (v) {
                        case "calcite1045": {
                            return false;
                        }
                        case "calcite1048": {
                            return false;
                        }
                    }
                    return null;
                };
            }
            case "not": {
                return v -> {
                    Object o = QuidemTest.getEnv(v);
                    if (o instanceof Function) {
                        Function f = (Function)o;
                        return v2 -> (Boolean)f.apply(v2) == false;
                    }
                    return null;
                };
            }
        }
        return null;
    }

    private @Nullable Method findMethod(String path) {
        Method m;
        String path1 = path.replace(File.separatorChar, '_');
        String path2 = PATTERN.matcher(path1).replaceAll("");
        String methodName = AvaticaUtils.toCamelCase((String)("test_" + path2));
        try {
            m = this.getClass().getMethod(methodName, String.class);
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        return m;
    }

    protected static Collection<String> data(String first) {
        URL inUrl = QuidemTest.class.getResource("/" + QuidemTest.n2u(first));
        File firstFile = Sources.of((URL)Objects.requireNonNull(inUrl, "inUrl")).file();
        int commonPrefixLength = firstFile.getAbsolutePath().length() - first.length();
        File dir = firstFile.getParentFile();
        ArrayList<String> paths = new ArrayList<String>();
        PatternFilenameFilter filter = new PatternFilenameFilter(".*\\.iq$");
        for (File f : (File[])Util.first((Object)dir.listFiles((FilenameFilter)filter), (Object)new File[0])) {
            paths.add(f.getAbsolutePath().substring(commonPrefixLength));
        }
        return paths;
    }

    protected void checkRun(String path) throws Exception {
        String diff;
        File outFile;
        File inFile;
        File f = new File(path);
        if (f.isAbsolute()) {
            inFile = f;
            outFile = new File(path + ".out");
        } else {
            URL inUrl = QuidemTest.class.getResource("/" + QuidemTest.n2u(path));
            inFile = Sources.of((URL)Objects.requireNonNull(inUrl, "inUrl")).file();
            outFile = QuidemTest.replaceDir(inFile, "resources", "quidem");
        }
        Util.discard((boolean)outFile.getParentFile().mkdirs());
        try (BufferedReader reader = Util.reader((File)inFile);
             PrintWriter writer = Util.printWriter((File)outFile);
             Closer closer = new Closer();){
            Quidem.Config config = Quidem.configBuilder().withReader((Reader)reader).withWriter((Writer)writer).withConnectionFactory(this.createConnectionFactory()).withCommandHandler(this.createCommandHandler()).withPropertyHandler((propertyName, value) -> {
                boolean b;
                if (propertyName.equals("bindable")) {
                    b = value instanceof Boolean && (Boolean)value != false;
                    closer.add((AutoCloseable)Hook.ENABLE_BINDABLE.addThread(Hook.propertyJ((Object)b)));
                }
                if (propertyName.equals("expand")) {
                    b = value instanceof Boolean && (Boolean)value != false;
                    closer.add((AutoCloseable)Prepare.THREAD_EXPAND.push((Object)b));
                }
                if (propertyName.equals("insubquerythreshold")) {
                    int thresholdValue = ((BigDecimal)value).intValue();
                    closer.add((AutoCloseable)Prepare.THREAD_INSUBQUERY_THRESHOLD.push((Object)thresholdValue));
                }
                if (propertyName.equals("planner-rules")) {
                    if (value.equals("original")) {
                        closer.add((AutoCloseable)Hook.PLANNER.addThread(QuidemTest::resetPlanner));
                    } else {
                        closer.add((AutoCloseable)Hook.PLANNER.addThread(planner -> {
                            if (originalRules == null) {
                                originalRules = planner.getRules();
                            }
                            QuidemTest.updatePlanner(planner, (String)value);
                        }));
                    }
                }
                if (propertyName.equals("hep-rules")) {
                    if (value.equals("original")) {
                        closer.add((AutoCloseable)Hook.PROGRAM.addThread(holder -> holder.set(null)));
                    } else {
                        closer.add((AutoCloseable)Hook.PROGRAM.addThread(holder -> {
                            ArrayList<RelOptRule> hepRules = new ArrayList<RelOptRule>();
                            ArrayList<RelOptRule> volcanoRules = new ArrayList<RelOptRule>(EnumerableRules.ENUMERABLE_RULES);
                            QuidemTest.applyRulesInOrder((String)value, hepRules, volcanoRules);
                            Program subQueryProgram = Programs.subQuery((RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE);
                            Program decorrelateProgram = Programs.decorrelate();
                            Program trimProgram = Programs.trim();
                            Program hepProgram = Programs.hep((Iterable)RuleSets.ofList(hepRules), (boolean)false, (RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE);
                            Program calcProgram = Programs.calc((RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE);
                            Program volcanoProgram = Programs.of((RuleSet)RuleSets.ofList(volcanoRules));
                            Program combinedProgram = Programs.sequence((Program[])new Program[]{subQueryProgram, decorrelateProgram, trimProgram, hepProgram, volcanoProgram, calcProgram});
                            holder.set((Object)combinedProgram);
                        }));
                    }
                }
            }).withEnv(QuidemTest::getEnv).build();
            new Quidem(config).execute();
        }
        if (inFile.length() == 0L) {
            Assertions.fail((String)("Input file was empty: " + inFile + "\n"));
        }
        if (!(diff = DiffTestCase.diff(inFile, outFile)).isEmpty()) {
            Assertions.fail((String)("Files differ:\ndiff " + inFile + " " + outFile + "\n" + diff));
        }
    }

    private static void updatePlanner(RelOptPlanner planner, String value) {
        ArrayList<RelOptRule> rulesAdd = new ArrayList<RelOptRule>();
        ArrayList<RelOptRule> rulesRemove = new ArrayList<RelOptRule>();
        QuidemTest.parseRules(value, rulesAdd, rulesRemove);
        rulesRemove.forEach(arg_0 -> ((RelOptPlanner)planner).removeRule(arg_0));
        rulesAdd.forEach(arg_0 -> ((RelOptPlanner)planner).addRule(arg_0));
    }

    private static void resetPlanner(RelOptPlanner planner) {
        if (originalRules != null) {
            planner.getRules().forEach(arg_0 -> ((RelOptPlanner)planner).removeRule(arg_0));
            originalRules.forEach(arg_0 -> ((RelOptPlanner)planner).addRule(arg_0));
        }
    }

    private static void parseRules(String value, List<RelOptRule> rulesAdd, List<RelOptRule> rulesRemove) {
        Pattern pattern = Pattern.compile("([+-])((CoreRules|EnumerableRules)\\.)?(\\w+)");
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            char operation = matcher.group(1).charAt(0);
            String ruleSource = matcher.group(3);
            String ruleName = matcher.group(4);
            try {
                if (ruleSource == null || ruleSource.equals("CoreRules")) {
                    QuidemTest.setRules(operation, QuidemTest.getCoreRule(ruleName), rulesAdd, rulesRemove);
                    continue;
                }
                if (ruleSource.equals("EnumerableRules")) {
                    Object rule = EnumerableRules.class.getField(ruleName).get(null);
                    QuidemTest.setRules(operation, (RelOptRule)rule, rulesAdd, rulesRemove);
                    continue;
                }
                throw new RuntimeException("Unknown rule: " + ruleName);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("set rules failed: " + e.getMessage(), e);
            }
        }
    }

    private static void applyRulesInOrder(String value, List<RelOptRule> hepRules, List<RelOptRule> volcanoRules) {
        Pattern pattern = Pattern.compile("([+-])((CoreRules|EnumerableRules)\\.)?(\\w+)");
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            char operation = matcher.group(1).charAt(0);
            String ruleSource = matcher.group(3);
            String ruleName = matcher.group(4);
            try {
                List<RelOptRule> target;
                RelOptRule rule;
                boolean targetVolcano = false;
                if (ruleSource == null || ruleSource.equals("CoreRules")) {
                    rule = QuidemTest.getCoreRule(ruleName);
                } else if (ruleSource.equals("EnumerableRules")) {
                    Object ruleObj = EnumerableRules.class.getField(ruleName).get(null);
                    rule = (RelOptRule)ruleObj;
                    targetVolcano = true;
                } else {
                    throw new RuntimeException("Unknown rule: " + ruleName);
                }
                List<RelOptRule> list = target = targetVolcano ? volcanoRules : hepRules;
                if (operation == '+') {
                    if (target.contains(rule)) continue;
                    target.add(rule);
                    continue;
                }
                if (operation == '-') {
                    target.remove(rule);
                    continue;
                }
                throw new RuntimeException("unknown operation '" + operation + "'");
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("set rules failed: " + e.getMessage(), e);
            }
        }
    }

    public static RelOptRule getCoreRule(String ruleName) {
        try {
            Field ruleField = CoreRules.class.getField(ruleName);
            Object o = ruleField.get(null);
            if (o instanceof RelOptRule) {
                return (RelOptRule)o;
            }
            throw new IllegalArgumentException(ruleName + " is not of type RelOptRule");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to get rule '" + ruleName + "': " + e.getMessage());
        }
    }

    private static void setRules(char operation, RelOptRule rule, List<RelOptRule> rulesAdd, List<RelOptRule> rulesRemove) {
        if (operation == '+') {
            rulesRemove.remove(rule);
            if (!rulesAdd.contains(rule)) {
                rulesAdd.add(rule);
            }
        } else if (operation == '-') {
            rulesAdd.remove(rule);
            if (!rulesRemove.contains(rule)) {
                rulesRemove.add(rule);
            }
        } else {
            throw new RuntimeException("unknown operation '" + operation + "'");
        }
    }

    private static File replaceDir(File file, String target, String replacement) {
        return new File(QuidemTest.n2u(file.getAbsolutePath()).replace(QuidemTest.n2u('/' + target + '/'), QuidemTest.n2u('/' + replacement + '/')));
    }

    protected CommandHandler createCommandHandler() {
        return Quidem.EMPTY_COMMAND_HANDLER;
    }

    protected Quidem.ConnectionFactory createConnectionFactory() {
        return new QuidemConnectionFactory();
    }

    private static String n2u(String s) {
        return File.separatorChar == '\\' ? s.replace('\\', '/') : s;
    }

    @ParameterizedTest
    @MethodSource(value={"getPath"})
    public void test(String path) throws Exception {
        Method method = this.findMethod(path);
        if (method != null) {
            try {
                method.invoke((Object)this, path);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw e;
            }
        } else {
            this.checkRun(path);
        }
    }

    protected abstract Collection<String> getPath();

    protected static class QuidemConnectionFactory
    implements Quidem.ConnectionFactory {
        protected QuidemConnectionFactory() {
        }

        public Connection connect(String name) throws Exception {
            return this.connect(name, false);
        }

        public Connection connect(String name, boolean reference) throws Exception {
            if (reference) {
                if (name.equals("foodmart")) {
                    ConnectionSpec db = CalciteAssert.DatabaseInstance.HSQLDB.foodmart;
                    Connection connection = DriverManager.getConnection(db.url, db.username, db.password);
                    connection.setSchema("foodmart");
                    return connection;
                }
                return null;
            }
            switch (name) {
                case "hr": {
                    return CalciteAssert.hr().connect();
                }
                case "aux": {
                    return CalciteAssert.hr().with(CalciteAssert.Config.AUX).connect();
                }
                case "foodmart": {
                    return CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).connect();
                }
                case "geo": {
                    return CalciteAssert.that().with(CalciteAssert.Config.GEO).connect();
                }
                case "scott": {
                    return CalciteAssert.that().with(CalciteAssert.Config.SCOTT).connect();
                }
                case "jdbc_scott": {
                    return CalciteAssert.that().with(CalciteAssert.Config.JDBC_SCOTT).connect();
                }
                case "steelwheels": {
                    return CalciteAssert.that().with(CalciteAssert.SchemaSpec.STEELWHEELS).connect();
                }
                case "jdbc_steelwheels": {
                    return CalciteAssert.that().with(CalciteAssert.SchemaSpec.JDBC_STEELWHEELS).connect();
                }
                case "post": {
                    return CalciteAssert.that().with(CalciteAssert.Config.REGULAR).with(CalciteAssert.SchemaSpec.POST).connect();
                }
                case "post-postgresql": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"standard,postgresql").with(CalciteAssert.Config.REGULAR).with(CalciteAssert.SchemaSpec.POST).connect();
                }
                case "post-big-query": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"standard,bigquery").with(CalciteAssert.Config.REGULAR).with(CalciteAssert.SchemaSpec.POST).connect();
                }
                case "mysqlfunc": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"mysql").with(CalciteAssert.Config.REGULAR).with(CalciteAssert.SchemaSpec.POST).connect();
                }
                case "sparkfunc": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"spark").with(CalciteAssert.Config.REGULAR).with(CalciteAssert.SchemaSpec.POST).connect();
                }
                case "oraclefunc": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"oracle").with(CalciteAssert.Config.REGULAR).connect();
                }
                case "mssqlfunc": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"mssql").with(CalciteAssert.Config.REGULAR).connect();
                }
                case "catchall": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.TIME_ZONE, (Object)"UTC").withSchema("s", (Schema)new ReflectiveSchemaWithoutRowCount(new CatchallSchema())).connect();
                }
                case "orinoco": {
                    return CalciteAssert.that().with(CalciteAssert.SchemaSpec.ORINOCO).connect();
                }
                case "seq": {
                    Connection connection = CalciteAssert.that().withSchema("s", (Schema)new AbstractSchema()).connect();
                    ((SchemaPlus)connection.unwrap(CalciteConnection.class).getRootSchema().subSchemas().get("s")).add("my_seq", (Table)new AbstractTable(){

                        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                            return typeFactory.builder().add("$seq", SqlTypeName.BIGINT).build();
                        }

                        public Schema.TableType getJdbcTableType() {
                            return Schema.TableType.SEQUENCE;
                        }
                    });
                    return connection;
                }
                case "bookstore": {
                    return CalciteAssert.that().with(CalciteAssert.SchemaSpec.BOOKSTORE).connect();
                }
            }
            throw new RuntimeException("unknown connection '" + name + "'");
        }
    }

    public static class ExplainValidatedCommand
    extends AbstractCommand {
        private final ImmutableList<String> lines;
        private final ImmutableList<String> content;
        private final SqlParserImplFactory parserFactory;

        ExplainValidatedCommand(SqlParserImplFactory parserFactory, List<String> lines, List<String> content, Set<String> unusedProductSet) {
            this.lines = ImmutableList.copyOf(lines);
            this.content = ImmutableList.copyOf(content);
            this.parserFactory = parserFactory;
        }

        public void execute(Command.Context x, boolean execute) throws Exception {
            if (execute) {
                SqlParser.Config parserConfig = SqlParser.config().withParserFactory(this.parserFactory);
                CalciteConnection calciteConnection = x.connection().unwrap(CalciteConnection.class);
                String schemaName = calciteConnection.getSchema();
                SchemaPlus schema = schemaName != null ? (SchemaPlus)calciteConnection.getRootSchema().subSchemas().get(schemaName) : calciteConnection.getRootSchema();
                Frameworks.ConfigBuilder config = Frameworks.newConfigBuilder().defaultSchema(schema).parserConfig(parserConfig).context(Contexts.of((Object)calciteConnection.config()));
                Quidem.SqlCommand sqlCommand = x.previousSqlCommand();
                Planner planner = Frameworks.getPlanner((FrameworkConfig)config.build());
                SqlNode node = planner.parse(sqlCommand.sql);
                SqlNode validateNode = planner.validate(node);
                SqlPrettyWriter sqlWriter = new SqlPrettyWriter();
                validateNode.unparse((SqlWriter)sqlWriter, 0, 0);
                x.echo((List)ImmutableList.of((Object)sqlWriter.toSqlString().getSql()));
            } else {
                x.echo(this.content);
            }
            x.echo(this.lines);
        }
    }
}

