/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.clone.CloneSchema;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteMetaImpl;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.model.ModelHandler;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.runtime.AccumOperation;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.CollectOperation;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.runtime.SpatialTypeFunctions;
import org.apache.calcite.runtime.UnionOperation;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.schema.impl.AggregateFunctionImpl;
import org.apache.calcite.schema.impl.TableFunctionImpl;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.fun.SqlSpatialTypeFunctions;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.test.ConnectionFactories;
import org.apache.calcite.test.ConnectionFactory;
import org.apache.calcite.test.ConnectionSpec;
import org.apache.calcite.test.Matchers;
import org.apache.calcite.test.ReflectiveSchemaWithoutRowCount;
import org.apache.calcite.test.schemata.bookstore.BookstoreSchema;
import org.apache.calcite.test.schemata.countries.CountriesTableFunction;
import org.apache.calcite.test.schemata.countries.StatesTableFunction;
import org.apache.calcite.test.schemata.foodmart.FoodmartSchema;
import org.apache.calcite.test.schemata.hr.HrSchema;
import org.apache.calcite.test.schemata.lingual.LingualSchema;
import org.apache.calcite.test.schemata.orderstream.OrdersHistoryTable;
import org.apache.calcite.test.schemata.orderstream.OrdersStreamTableFactory;
import org.apache.calcite.test.schemata.orderstream.ProductsTemporalTable;
import org.apache.calcite.test.schemata.tpch.TpchSchema;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Closer;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.JsonBuilder;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Smalls;
import org.apache.calcite.util.Sources;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.apache.commons.lang3.StringUtils;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;

public class CalciteAssert {
    public static final DatabaseInstance DB = DatabaseInstance.valueOf((String)CalciteSystemProperty.TEST_DB.value());
    private static String testMysqlUrl = "jdbc:mysql://localhost/foodmart";
    private static String testMysqlDriver = "com.mysql.jdbc.Driver";
    private static final AssertThat DISABLED = new AssertThat(ConnectionFactories.empty(), ImmutableList.of()){

        @Override
        public AssertThat with(Config config) {
            return this;
        }

        @Override
        public AssertThat with(ConnectionFactory connectionFactory) {
            return this;
        }

        @Override
        public AssertThat with(String property, Object value) {
            return this;
        }

        @Override
        public AssertThat withSchema(String name, Schema schema) {
            return this;
        }

        @Override
        public AssertQuery query(String sql) {
            return NopAssertQuery.of(sql);
        }

        @Override
        public AssertThat connectThrows(Consumer<Throwable> exceptionChecker) {
            return this;
        }

        @Override
        public <T> AssertThat doWithConnection(java.util.function.Function<CalciteConnection, T> fn) {
            return this;
        }

        @Override
        public AssertThat withDefaultSchema(String schema) {
            return this;
        }

        @Override
        public AssertThat with(SchemaSpec ... specs) {
            return this;
        }

        @Override
        public AssertThat with(Lex lex) {
            return this;
        }

        @Override
        public AssertThat with(SqlConformanceEnum conformance) {
            return this;
        }

        @Override
        public AssertThat with(ConnectionPostProcessor postProcessor) {
            return this;
        }

        @Override
        public AssertThat enable(boolean enabled) {
            return this;
        }

        @Override
        public AssertThat pooled() {
            return this;
        }
    };
    private static final Schema MY_DB_SCHEMA = new Schema(){
        final Table table = new Table(){

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                RelDataType bigint = typeFactory.createSqlType(SqlTypeName.BIGINT);
                return typeFactory.builder().add("a", bigint).add("n1", typeFactory.builder().add("n11", typeFactory.builder().add("b", bigint).build()).add("n12", typeFactory.builder().add("c", bigint).build()).build()).add("n2", typeFactory.builder().add("d", bigint).build()).add("xs", typeFactory.createArrayType(bigint, -1L)).add("e", bigint).build();
            }

            public Statistic getStatistic() {
                return new Statistic(){

                    public Double getRowCount() {
                        return 0.0;
                    }
                };
            }

            public Schema.TableType getJdbcTableType() {
                return Schema.TableType.TABLE;
            }

            public boolean isRolledUp(String column) {
                return false;
            }

            public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, @Nullable SqlNode parent, @Nullable CalciteConnectionConfig config) {
                return false;
            }
        };

        @Deprecated
        public Table getTable(String name) {
            return this.table;
        }

        @Deprecated
        public Set<String> getTableNames() {
            return ImmutableSet.of((Object)"myTable");
        }

        public @Nullable RelProtoDataType getType(String name) {
            return null;
        }

        public Set<String> getTypeNames() {
            return ImmutableSet.of();
        }

        public Collection<org.apache.calcite.schema.Function> getFunctions(String name) {
            return ImmutableList.of();
        }

        public Set<String> getFunctionNames() {
            return ImmutableSet.of();
        }

        @Deprecated
        public @Nullable Schema getSubSchema(String name) {
            return null;
        }

        @Deprecated
        public Set<String> getSubSchemaNames() {
            return ImmutableSet.of();
        }

        public Expression getExpression(@Nullable SchemaPlus parentSchema, String name) {
            throw new UnsupportedOperationException("getExpression");
        }

        public boolean isMutable() {
            return false;
        }

        public Schema snapshot(SchemaVersion version) {
            throw new UnsupportedOperationException("snapshot");
        }
    };
    private static final Schema UNSIGNED_TYPE_SCHEMA = new AbstractSchema(){

        protected Map<String, Table> getTableMap() {
            return ImmutableMap.of((Object)"test_unsigned", (Object)((Object)new UnsingedScannableTable()));
        }
    };

    private CalciteAssert() {
    }

    public static AssertThat that() {
        return AssertThat.EMPTY;
    }

    public static AssertThat that(Config config) {
        return CalciteAssert.that().with(config);
    }

    public static AssertThat model(String model) {
        return CalciteAssert.that().withModel(model);
    }

    public static AssertThat hr() {
        return CalciteAssert.that(Config.REGULAR);
    }

    private static <K, V> ImmutableList<Pair<K, V>> addPair(List<Pair<K, V>> list, K k, V v) {
        return ImmutableList.builder().addAll(list).add((Object)Pair.of(k, v)).build();
    }

    static Consumer<RelNode> checkRel(String expected, @Nullable AtomicInteger counter) {
        return relNode -> {
            if (counter != null) {
                counter.incrementAndGet();
            }
            String s = RelOptUtil.toString((RelNode)relNode);
            MatcherAssert.assertThat((Object)s, Matchers.containsStringLinux(expected));
        };
    }

    static Consumer<Throwable> checkException(String expected) {
        return p0 -> {
            Assertions.assertNotNull((Object)p0, (String)"expected exception but none was thrown");
            String stack = TestUtil.printStackTrace(p0);
            MatcherAssert.assertThat((Object)stack, (org.hamcrest.Matcher)CoreMatchers.containsString((String)expected));
        };
    }

    static Consumer<Throwable> checkValidationException(final @Nullable String expected) {
        return new Consumer<Throwable>(){

            @Override
            public void accept(@Nullable Throwable throwable) {
                Assertions.assertNotNull((Object)throwable, (String)"Nothing was thrown");
                Exception exception = this.containsCorrectException(throwable);
                Assertions.assertNotNull((Object)exception, (String)"Expected to fail at validation, but did not");
                if (expected != null) {
                    String stack = TestUtil.printStackTrace(exception);
                    MatcherAssert.assertThat((Object)stack, (org.hamcrest.Matcher)CoreMatchers.containsString((String)expected));
                }
            }

            private boolean isCorrectException(Throwable throwable) {
                return throwable instanceof SqlValidatorException || throwable instanceof CalciteException;
            }

            private @Nullable Exception containsCorrectException(Throwable root) {
                for (Throwable currentCause = root; currentCause != null; currentCause = currentCause.getCause()) {
                    if (!this.isCorrectException(currentCause)) continue;
                    return (Exception)currentCause;
                }
                return null;
            }
        };
    }

    static Consumer<ResultSet> checkResult(String expected) {
        return CalciteAssert.checkResult(expected, new ResultSetFormatter());
    }

    static Consumer<ResultSet> checkResult(String expected, ResultSetFormatter resultSetFormatter) {
        return resultSet -> {
            try {
                resultSetFormatter.resultSet((ResultSet)resultSet);
                MatcherAssert.assertThat((Object)resultSetFormatter.string(), Matchers.isLinux(expected));
            }
            catch (SQLException e) {
                TestUtil.rethrow(e);
            }
        };
    }

    static Consumer<ResultSet> checkResultValue(String expected) {
        return resultSet -> {
            try {
                if (!resultSet.next()) {
                    throw new AssertionError((Object)"too few rows");
                }
                if (resultSet.getMetaData().getColumnCount() != 1) {
                    throw new AssertionError((Object)"expected 1 column");
                }
                String resultString = resultSet.getString(1);
                MatcherAssert.assertThat((Object)resultString, expected == null ? CoreMatchers.nullValue(String.class) : Matchers.isLinux(expected));
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        };
    }

    public static Consumer<ResultSet> checkResultCount(org.hamcrest.Matcher<Integer> expected) {
        return resultSet -> {
            try {
                int count = CalciteAssert.countRows(resultSet);
                MatcherAssert.assertThat((Object)count, (org.hamcrest.Matcher)expected);
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        };
    }

    public static Consumer<Integer> checkUpdateCount(int expected) {
        return updateCount -> MatcherAssert.assertThat((Object)updateCount, (org.hamcrest.Matcher)CoreMatchers.is((Object)expected));
    }

    static Consumer<ResultSet> consistentResult(final boolean ordered) {
        return new Consumer<ResultSet>(){
            int executeCount = 0;
            Collection expected;

            @Override
            public void accept(ResultSet resultSet) {
                ++this.executeCount;
                try {
                    Collection<String> result = CalciteAssert.toStringList(resultSet, ordered ? new ArrayList() : new TreeSet());
                    if (this.executeCount == 1) {
                        this.expected = result;
                    } else {
                        boolean matches = this.expected.equals(result);
                        if (!matches) {
                            MatcherAssert.assertThat((Object)CalciteAssert.newlineList(result), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)CalciteAssert.newlineList(this.expected)));
                            Assertions.fail((String)"oops");
                        }
                    }
                }
                catch (SQLException e) {
                    throw TestUtil.rethrow(e);
                }
            }
        };
    }

    static String newlineList(Collection collection) {
        StringBuilder buf = new StringBuilder();
        for (Object o : collection) {
            buf.append(o).append('\n');
        }
        return buf.toString();
    }

    static Consumer<ResultSet> checkResultUnordered(String ... lines) {
        return CalciteAssert.checkResult(true, false, lines);
    }

    static Consumer<ResultSet> checkResult(boolean sort, boolean head, String ... lines) {
        for (String line : lines) {
            if (line.contains("\n")) {
                throw new AssertionError((Object)("expected line has line breaks: " + line));
            }
        }
        return resultSet -> {
            try {
                List<String> trimmedActualList;
                ArrayList expectedList = Lists.newArrayList((Object[])lines);
                if (sort) {
                    Collections.sort(expectedList);
                }
                ArrayList<String> actualList = new ArrayList<String>();
                CalciteAssert.toStringList(resultSet, actualList);
                if (sort) {
                    Collections.sort(actualList);
                }
                if (!(trimmedActualList = head && actualList.size() > expectedList.size() ? actualList.subList(0, expectedList.size()) : actualList).equals(expectedList)) {
                    MatcherAssert.assertThat((Object)Util.lines(trimmedActualList), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)Util.lines((Iterable)expectedList)));
                }
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        };
    }

    public static Consumer<ResultSet> checkResultContains(String ... expected) {
        return s -> {
            try {
                String actual = CalciteAssert.toString(s);
                for (String st : expected) {
                    MatcherAssert.assertThat((Object)actual, Matchers.containsStringLinux(st));
                }
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        };
    }

    public static Consumer<ResultSet> checkResultContains(String expected, int count) {
        return s -> {
            try {
                String actual = Util.toLinux((String)CalciteAssert.toString(s));
                MatcherAssert.assertThat((String)(actual + " should have " + count + " occurrence of " + expected), (Object)StringUtils.countMatches((CharSequence)actual, (CharSequence)expected), (org.hamcrest.Matcher)CoreMatchers.is((Object)count));
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        };
    }

    public static Consumer<ResultSet> checkMaskedResultContains(String expected) {
        return s -> {
            try {
                String actual = Util.toLinux((String)CalciteAssert.toString(s));
                String maskedActual = Matchers.trimNodeIds(actual);
                MatcherAssert.assertThat((Object)maskedActual, (org.hamcrest.Matcher)CoreMatchers.containsString((String)expected));
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        };
    }

    public static Consumer<ResultSet> checkResultType(String expected) {
        return s -> {
            try {
                String actual = CalciteAssert.typeString(s.getMetaData());
                MatcherAssert.assertThat((Object)actual, (org.hamcrest.Matcher)CoreMatchers.is((Object)expected));
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        };
    }

    private static String typeString(ResultSetMetaData metaData) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < metaData.getColumnCount(); ++i) {
            list.add(metaData.getColumnName(i + 1) + " " + metaData.getColumnTypeName(i + 1) + (metaData.isNullable(i + 1) == 0 ? " NOT NULL" : ""));
        }
        return ((Object)list).toString();
    }

    /*
     * WARNING - void declaration
     */
    static void assertQuery(Connection connection, String sql, int limit, boolean materializationsEnabled, List<Pair<Hook, Consumer>> hooks, @Nullable Consumer<ResultSet> resultChecker, @Nullable Consumer<Integer> updateChecker, @Nullable Consumer<Throwable> exceptionChecker) {
        try {
            Statement statement;
            block34: {
                void var11_20;
                try (Closer closer = new Closer();){
                    if (connection.isWrapperFor(CalciteConnection.class)) {
                        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
                        Properties properties = calciteConnection.getProperties();
                        properties.setProperty(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.camelName(), Boolean.toString(materializationsEnabled));
                        properties.setProperty(CalciteConnectionProperty.CREATE_MATERIALIZATIONS.camelName(), Boolean.toString(materializationsEnabled));
                        if (!properties.containsKey(CalciteConnectionProperty.TIME_ZONE.camelName())) {
                            properties.setProperty(CalciteConnectionProperty.TIME_ZONE.camelName(), DateTimeUtils.UTC_ZONE.getID());
                        }
                    }
                    for (Pair pair : hooks) {
                        closer.add((AutoCloseable)((Hook)pair.left).addThread((Consumer)pair.right));
                    }
                    statement = connection.createStatement();
                    statement.setMaxRows(Math.max(limit, 0));
                    Object var11_18 = null;
                    Integer updateCount = null;
                    try {
                        if (updateChecker == null) {
                            ResultSet resultSet = statement.executeQuery(sql);
                            if (resultChecker == null && exceptionChecker != null) {
                                while (resultSet.next()) {
                                }
                            }
                        } else {
                            updateCount = statement.executeUpdate(sql);
                        }
                        if (exceptionChecker != null) {
                            exceptionChecker.accept(null);
                            return;
                        }
                    }
                    catch (Error | Exception e) {
                        if (exceptionChecker != null) {
                            exceptionChecker.accept(e);
                            return;
                        }
                        throw e;
                    }
                    if (resultChecker != null) {
                        resultChecker.accept((ResultSet)var11_20);
                    }
                    if (updateChecker != null) {
                        updateChecker.accept(updateCount);
                    }
                    if (var11_20 == null) break block34;
                }
                var11_20.close();
            }
            statement.close();
            connection.close();
        }
        catch (Throwable e) {
            String message = "With materializationsEnabled=" + materializationsEnabled + ", limit=" + limit;
            if (!TestUtil.hasMessage(e, sql)) {
                message = message + ", sql=" + sql;
            }
            throw TestUtil.rethrow(e, message);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void assertPrepare(Connection connection, String sql, int limit, boolean materializationsEnabled, List<Pair<Hook, Consumer>> hooks, @Nullable Consumer<ResultSet> resultChecker, @Nullable Consumer<Integer> updateChecker, @Nullable Consumer<Throwable> exceptionChecker, PreparedStatementConsumer consumer) {
        try {
            PreparedStatement statement;
            block32: {
                void var12_21;
                try (Closer closer = new Closer();){
                    if (connection.isWrapperFor(CalciteConnection.class)) {
                        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
                        Properties properties = calciteConnection.getProperties();
                        properties.setProperty(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.camelName(), Boolean.toString(materializationsEnabled));
                        properties.setProperty(CalciteConnectionProperty.CREATE_MATERIALIZATIONS.camelName(), Boolean.toString(materializationsEnabled));
                        if (!properties.containsKey(CalciteConnectionProperty.TIME_ZONE.camelName())) {
                            properties.setProperty(CalciteConnectionProperty.TIME_ZONE.camelName(), DateTimeUtils.UTC_ZONE.getID());
                        }
                    }
                    for (Pair pair : hooks) {
                        closer.add((AutoCloseable)((Hook)pair.left).addThread((Consumer)pair.right));
                    }
                    statement = connection.prepareStatement(sql);
                    statement.setMaxRows(Math.max(limit, 0));
                    Object var12_19 = null;
                    Integer updateCount = null;
                    try {
                        consumer.accept(statement);
                        if (updateChecker == null) {
                            ResultSet resultSet = statement.executeQuery();
                        } else {
                            updateCount = statement.executeUpdate(sql);
                        }
                        if (exceptionChecker != null) {
                            exceptionChecker.accept(null);
                            return;
                        }
                    }
                    catch (Error | Exception e) {
                        if (exceptionChecker != null) {
                            exceptionChecker.accept(e);
                            return;
                        }
                        throw e;
                    }
                    if (resultChecker != null) {
                        resultChecker.accept((ResultSet)var12_21);
                    }
                    if (updateChecker != null) {
                        updateChecker.accept(updateCount);
                    }
                    if (var12_21 == null) break block32;
                }
                var12_21.close();
            }
            statement.close();
            connection.close();
        }
        catch (Throwable e) {
            String message = "With materializationsEnabled=" + materializationsEnabled + ", limit=" + limit;
            if (!TestUtil.hasMessage(e, sql)) {
                message = message + ", sql=" + sql;
            }
            throw TestUtil.rethrow(e, message);
        }
    }

    static void assertPrepare(Connection connection, String sql, boolean materializationsEnabled, Consumer<RelNode> convertChecker, Consumer<RelNode> substitutionChecker) {
        CalciteAssert.assertPrepare(connection, sql, materializationsEnabled, (List<Pair<Hook, Consumer>>)ImmutableList.of(), convertChecker, substitutionChecker);
    }

    static void assertPrepare(Connection connection, String sql, boolean materializationsEnabled, List<Pair<Hook, Consumer>> hooks, @Nullable Consumer<RelNode> convertChecker, @Nullable Consumer<RelNode> substitutionChecker) {
        try (Closer closer = new Closer();){
            if (convertChecker != null) {
                closer.add((AutoCloseable)Hook.TRIMMED.addThread(convertChecker));
            }
            if (substitutionChecker != null) {
                closer.add((AutoCloseable)Hook.SUB.addThread(substitutionChecker));
            }
            for (Pair<Hook, Consumer> hook : hooks) {
                closer.add((AutoCloseable)((Hook)hook.left).addThread((Consumer)hook.right));
            }
            ((CalciteConnection)connection).getProperties().setProperty(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.camelName(), Boolean.toString(materializationsEnabled));
            ((CalciteConnection)connection).getProperties().setProperty(CalciteConnectionProperty.CREATE_MATERIALIZATIONS.camelName(), Boolean.toString(materializationsEnabled));
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.close();
            connection.close();
        }
        catch (Throwable e) {
            String message = "With materializationsEnabled=" + materializationsEnabled;
            if (!TestUtil.hasMessage(e, sql)) {
                message = message + ", sql=" + sql;
            }
            throw TestUtil.rethrow(e, message);
        }
    }

    public static String toString(ResultSet resultSet) throws SQLException {
        return new ResultSetFormatter().resultSet(resultSet).string();
    }

    static int countRows(ResultSet resultSet) throws SQLException {
        int n = 0;
        while (resultSet.next()) {
            ++n;
        }
        return n;
    }

    static Collection<String> toStringList(ResultSet resultSet, Collection<String> list) throws SQLException {
        return new ResultSetFormatter().toStringList(resultSet, list);
    }

    static List<String> toList(ResultSet resultSet) throws SQLException {
        return (List)CalciteAssert.toStringList(resultSet, new ArrayList<String>());
    }

    static ImmutableMultiset<String> toSet(ResultSet resultSet) throws SQLException {
        return ImmutableMultiset.copyOf(CalciteAssert.toList(resultSet));
    }

    static Object call(Object o, String methodName, Object ... args) throws InvocationTargetException, IllegalAccessException {
        return CalciteAssert.method(o, methodName, args).invoke(o, args);
    }

    /*
     * Unable to fully structure code
     */
    static Method method(Object o, String methodName, Object[] args) {
        aClass = o.getClass();
        while (true) lbl-1000:
        // 5 sources

        {
            block1: for (Method method1 : aClass.getMethods()) {
                if (!method1.getName().equals(methodName) || method1.getParameterCount() != args.length || !Modifier.isPublic(method1.getDeclaringClass().getModifiers())) continue;
                for (Pair pair : Pair.zip((Object[])args, (Object[])method1.getParameterTypes())) {
                    if (((Class)pair.right).isInstance(pair.left)) continue;
                    continue block1;
                }
                return method1;
            }
            if (aClass.getSuperclass() != null && aClass.getSuperclass() != Object.class) {
                aClass = aClass.getSuperclass();
                ** continue;
            }
            interfaces = aClass.getInterfaces();
            if (interfaces.length <= 0) break;
            aClass = interfaces[0];
        }
        throw new AssertionError((Object)("method " + methodName + " not found"));
    }

    public static SchemaPlus addSchema(SchemaPlus rootSchema, SchemaSpec ... schemas) {
        SchemaPlus s = rootSchema;
        for (SchemaSpec schema : schemas) {
            s = CalciteAssert.addSchema_(rootSchema, schema);
        }
        return s;
    }

    static SchemaPlus addSchema_(SchemaPlus rootSchema, SchemaSpec schema) {
        ImmutableList emptyPath = ImmutableList.of();
        switch (schema) {
            case REFLECTIVE_FOODMART: {
                return rootSchema.add(schema.schemaName, (Schema)new ReflectiveSchema((Object)new FoodmartSchema()));
            }
            case JDBC_SCOTT: {
                ConnectionSpec cs = Objects.requireNonNull(DatabaseInstance.HSQLDB.scott);
                DataSource dataSource = JdbcSchema.dataSource((String)cs.url, (String)cs.driver, (String)cs.username, (String)cs.password);
                return rootSchema.add(schema.schemaName, (Schema)JdbcSchema.create((SchemaPlus)rootSchema, (String)schema.schemaName, (DataSource)dataSource, (String)cs.catalog, (String)cs.schema));
            }
            case JDBC_STEELWHEELS: {
                ConnectionSpec cs = Objects.requireNonNull(DatabaseInstance.HSQLDB.steelwheels);
                DataSource dataSource = JdbcSchema.dataSource((String)cs.url, (String)cs.driver, (String)cs.username, (String)cs.password);
                return rootSchema.add(schema.schemaName, (Schema)JdbcSchema.create((SchemaPlus)rootSchema, (String)schema.schemaName, (DataSource)dataSource, (String)cs.catalog, (String)cs.schema));
            }
            case JDBC_FOODMART: {
                ConnectionSpec cs = CalciteAssert.DB.foodmart;
                DataSource dataSource = JdbcSchema.dataSource((String)cs.url, (String)cs.driver, (String)cs.username, (String)cs.password);
                return rootSchema.add(schema.schemaName, (Schema)JdbcSchema.create((SchemaPlus)rootSchema, (String)schema.schemaName, (DataSource)dataSource, (String)cs.catalog, (String)cs.schema));
            }
            case JDBC_FOODMART_WITH_LATTICE: {
                SchemaPlus foodmart = CalciteAssert.addSchemaIfNotExists(rootSchema, SchemaSpec.JDBC_FOODMART);
                CalciteSchema foodmartSchema = (CalciteSchema)Objects.requireNonNull(foodmart.unwrap(CalciteSchema.class));
                foodmart.add(schema.schemaName, Lattice.create((CalciteSchema)foodmartSchema, (String)"select 1 from \"foodmart\".\"sales_fact_1997\" as s\njoin \"foodmart\".\"time_by_day\" as t using (\"time_id\")\njoin \"foodmart\".\"customer\" as c using (\"customer_id\")\njoin \"foodmart\".\"product\" as p using (\"product_id\")\njoin \"foodmart\".\"product_class\" as pc on p.\"product_class_id\" = pc.\"product_class_id\"", (boolean)true));
                return foodmart;
            }
            case MY_DB: {
                return rootSchema.add(schema.schemaName, MY_DB_SCHEMA);
            }
            case UNSIGNED_TYPE: {
                return rootSchema.add(schema.schemaName, UNSIGNED_TYPE_SCHEMA);
            }
            case SCOTT: {
                SchemaPlus jdbcScott = CalciteAssert.addSchemaIfNotExists(rootSchema, SchemaSpec.JDBC_SCOTT);
                return rootSchema.add(schema.schemaName, (Schema)new CloneSchema(jdbcScott));
            }
            case SCOTT_WITH_TEMPORAL: {
                SchemaPlus scott = CalciteAssert.addSchemaIfNotExists(rootSchema, SchemaSpec.SCOTT);
                scott.add("products_temporal", (Table)new ProductsTemporalTable());
                scott.add("orders", (Table)new OrdersHistoryTable(OrdersStreamTableFactory.getRowList()));
                return scott;
            }
            case STEELWHEELS: {
                SchemaPlus jdbcSteelwheels = CalciteAssert.addSchemaIfNotExists(rootSchema, SchemaSpec.JDBC_STEELWHEELS);
                return rootSchema.add(schema.schemaName, (Schema)new CloneSchema(jdbcSteelwheels));
            }
            case TPCH: {
                return rootSchema.add(schema.schemaName, (Schema)new ReflectiveSchema((Object)new TpchSchema()));
            }
            case CLONE_FOODMART: {
                SchemaPlus foodmart = CalciteAssert.addSchemaIfNotExists(rootSchema, SchemaSpec.JDBC_FOODMART);
                return rootSchema.add("foodmart2", (Schema)new CloneSchema(foodmart));
            }
            case GEO: {
                ModelHandler.addFunctions((SchemaPlus)rootSchema, null, (List)emptyPath, (String)SpatialTypeFunctions.class.getName(), (String)"*", (boolean)true);
                ModelHandler.addFunctions((SchemaPlus)rootSchema, null, (List)emptyPath, (String)SqlSpatialTypeFunctions.class.getName(), (String)"*", (boolean)true);
                rootSchema.add("ST_UNION", (org.apache.calcite.schema.Function)Objects.requireNonNull(AggregateFunctionImpl.create(UnionOperation.class)));
                rootSchema.add("ST_ACCUM", (org.apache.calcite.schema.Function)Objects.requireNonNull(AggregateFunctionImpl.create(AccumOperation.class)));
                rootSchema.add("ST_COLLECT", (org.apache.calcite.schema.Function)Objects.requireNonNull(AggregateFunctionImpl.create(CollectOperation.class)));
                SchemaPlus s = rootSchema.add(schema.schemaName, (Schema)new AbstractSchema());
                ModelHandler.addFunctions((SchemaPlus)s, (String)"countries", (List)emptyPath, (String)CountriesTableFunction.class.getName(), null, (boolean)false);
                String sql = "select * from table(\"countries\"(true))";
                ViewTableMacro viewMacro = ViewTable.viewMacro((SchemaPlus)rootSchema, (String)"select * from table(\"countries\"(true))", (List)ImmutableList.of((Object)"GEO"), (List)emptyPath, (Boolean)false);
                s.add("countries", (org.apache.calcite.schema.Function)viewMacro);
                ModelHandler.addFunctions((SchemaPlus)s, (String)"states", (List)emptyPath, (String)StatesTableFunction.class.getName(), (String)"states", (boolean)false);
                String sql2 = "select \"name\",\n ST_PolyFromText(\"geom\") as \"geom\"\nfrom table(\"states\"(true))";
                ViewTableMacro viewMacro2 = ViewTable.viewMacro((SchemaPlus)rootSchema, (String)"select \"name\",\n ST_PolyFromText(\"geom\") as \"geom\"\nfrom table(\"states\"(true))", (List)ImmutableList.of((Object)"GEO"), (List)emptyPath, (Boolean)false);
                s.add("states", (org.apache.calcite.schema.Function)viewMacro2);
                ModelHandler.addFunctions((SchemaPlus)s, (String)"parks", (List)emptyPath, (String)StatesTableFunction.class.getName(), (String)"parks", (boolean)false);
                String sql3 = "select \"name\",\n ST_PolyFromText(\"geom\") as \"geom\"\nfrom table(\"parks\"(true))";
                ViewTableMacro viewMacro3 = ViewTable.viewMacro((SchemaPlus)rootSchema, (String)"select \"name\",\n ST_PolyFromText(\"geom\") as \"geom\"\nfrom table(\"parks\"(true))", (List)ImmutableList.of((Object)"GEO"), (List)emptyPath, (Boolean)false);
                s.add("parks", (org.apache.calcite.schema.Function)viewMacro3);
                return s;
            }
            case HR: {
                return rootSchema.add(schema.schemaName, (Schema)new ReflectiveSchemaWithoutRowCount(new HrSchema()));
            }
            case LINGUAL: {
                return rootSchema.add(schema.schemaName, (Schema)new ReflectiveSchema((Object)new LingualSchema()));
            }
            case BLANK: {
                return rootSchema.add(schema.schemaName, (Schema)new AbstractSchema());
            }
            case ORINOCO: {
                SchemaPlus orinoco = rootSchema.add(schema.schemaName, (Schema)new AbstractSchema());
                orinoco.add("ORDERS", (Table)new OrdersHistoryTable(OrdersStreamTableFactory.getRowList()));
                return orinoco;
            }
            case POST: {
                SchemaPlus post = rootSchema.add(schema.schemaName, (Schema)new AbstractSchema());
                post.add("EMP", (org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)post, (String)"select * from (values\n    ('Jane', 10, 'F'),\n    ('Bob', 10, 'M'),\n    ('Eric', 20, 'M'),\n    ('Susan', 30, 'F'),\n    ('Alice', 30, 'F'),\n    ('Adam', 50, 'M'),\n    ('Eve', 50, 'F'),\n    ('Grace', 60, 'F'),\n    ('Wilma', cast(null as integer), 'F'))\n  as t(ename, deptno, gender)", (List)emptyPath, (List)ImmutableList.of((Object)"POST", (Object)"EMP"), null));
                post.add("DEPT", (org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)post, (String)"select * from (values\n    (10, 'Sales'),\n    (20, 'Marketing'),\n    (30, 'Engineering'),\n    (40, 'Empty')) as t(deptno, dname)", (List)emptyPath, (List)ImmutableList.of((Object)"POST", (Object)"DEPT"), null));
                post.add("DEPT30", (org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)post, (String)"select * from dept where deptno = 30", (List)ImmutableList.of((Object)"POST"), (List)ImmutableList.of((Object)"POST", (Object)"DEPT30"), null));
                post.add("EMPS", (org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)post, (String)"select * from (values\n    (100, 'Fred',  10, CAST(NULL AS CHAR(1)), CAST(NULL AS VARCHAR(20)), 40,               25, TRUE,    FALSE, DATE '1996-08-03'),\n    (110, 'Eric',  20, 'M',                   'San Francisco',           3,                80, UNKNOWN, FALSE, DATE '2001-01-01'),\n    (110, 'John',  40, 'M',                   'Vancouver',               2, CAST(NULL AS INT), FALSE,   TRUE,  DATE '2002-05-03'),\n    (120, 'Wilma', 20, 'F',                   CAST(NULL AS VARCHAR(20)), 1,                 5, UNKNOWN, TRUE,  DATE '2005-09-07'),\n    (130, 'Alice', 40, 'F',                   'Vancouver',               2, CAST(NULL AS INT), FALSE,   TRUE,  DATE '2007-01-01'))\n as t(empno, name, deptno, gender, city, empid, age, slacker, manager, joinedat)", (List)emptyPath, (List)ImmutableList.of((Object)"POST", (Object)"EMPS"), null));
                post.add("TICKER", (org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)post, (String)"select * from (values\n    ('ACME', '2017-12-01', 12),\n    ('ACME', '2017-12-02', 17),\n    ('ACME', '2017-12-03', 19),\n    ('ACME', '2017-12-04', 21),\n    ('ACME', '2017-12-05', 25),\n    ('ACME', '2017-12-06', 12),\n    ('ACME', '2017-12-07', 15),\n    ('ACME', '2017-12-08', 20),\n    ('ACME', '2017-12-09', 24),\n    ('ACME', '2017-12-10', 25),\n    ('ACME', '2017-12-11', 19),\n    ('ACME', '2017-12-12', 15),\n    ('ACME', '2017-12-13', 25),\n    ('ACME', '2017-12-14', 25),\n    ('ACME', '2017-12-15', 14),\n    ('ACME', '2017-12-16', 12),\n    ('ACME', '2017-12-17', 14),\n    ('ACME', '2017-12-18', 24),\n    ('ACME', '2017-12-19', 23),\n    ('ACME', '2017-12-20', 22))\n as t(SYMBOL, tstamp, price)", (List)ImmutableList.of(), (List)ImmutableList.of((Object)"POST", (Object)"TICKER"), null));
                post.add("EMPS_DATE_TIME", (org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)post, (String)"select * from (values\n    (100, 'Fred',  10, CAST(NULL AS CHAR(1)), CAST(NULL AS VARCHAR(20)), 40,               25, TRUE,    FALSE, DATE '1996-08-03', TIME '16:22:34', TIMESTAMP '1996-08-03 16:22:34'),\n    (110, 'Eric',  20, 'M',                   'San Francisco',           3,                80, UNKNOWN, FALSE, DATE '2001-01-01', TIME '12:20:00', TIMESTAMP '2001-01-01 12:20:00'),\n    (110, 'John',  40, 'M',                   'Vancouver',               2, CAST(NULL AS INT), FALSE,   TRUE,  DATE '2002-05-03', TIME '13:12:14', TIMESTAMP '2002-05-03 13:12:14'),\n    (120, 'Wilma', 20, 'F',                   CAST(NULL AS VARCHAR(20)), 1,                 5, UNKNOWN, TRUE,  DATE '2005-09-07', TIME '06:02:04', TIMESTAMP '2005-09-07 06:02:04'),\n    (130, 'Alice', 40, 'F',                   'Vancouver',               2, CAST(NULL AS INT), FALSE,   TRUE,  DATE '2007-01-01', TIME '23:09:59', TIMESTAMP '2007-01-01 23:09:59'))\n as t(empno, name, deptno, gender, city, empid, age, slacker, manager, joinedat, joinetime, joinetimestamp)", (List)emptyPath, (List)ImmutableList.of((Object)"POST", (Object)"EMPS_DATE_TIME"), null));
                return post;
            }
            case FAKE_FOODMART: {
                SchemaPlus foodmart = CalciteAssert.addSchemaIfNotExists(rootSchema, SchemaSpec.JDBC_FOODMART);
                final Wrapper salesTable = Objects.requireNonNull((Wrapper)foodmart.tables().get("sales_fact_1997"));
                SchemaPlus fake = rootSchema.add(schema.schemaName, (Schema)new AbstractSchema());
                fake.add("time_by_day", (Table)new AbstractTable(){

                    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                        return typeFactory.builder().add("time_id", SqlTypeName.INTEGER).add("the_year", SqlTypeName.INTEGER).build();
                    }

                    public <C> C unwrap(Class<C> aClass) {
                        if (aClass.isAssignableFrom(SqlDialect.class) || aClass.isAssignableFrom(DataSource.class)) {
                            return (C)salesTable.unwrap(aClass);
                        }
                        return (C)super.unwrap(aClass);
                    }
                });
                fake.add("sales_fact_1997", (Table)new AbstractTable(){

                    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                        return typeFactory.builder().add("time_id", SqlTypeName.INTEGER).add("customer_id", SqlTypeName.INTEGER).build();
                    }

                    public <C> C unwrap(Class<C> aClass) {
                        if (aClass.isAssignableFrom(SqlDialect.class) || aClass.isAssignableFrom(DataSource.class)) {
                            return (C)salesTable.unwrap(aClass);
                        }
                        return (C)super.unwrap(aClass);
                    }
                });
                return fake;
            }
            case AUX: {
                SchemaPlus aux = rootSchema.add(schema.schemaName, (Schema)new AbstractSchema());
                aux.add("TBLFUN", (org.apache.calcite.schema.Function)Objects.requireNonNull(TableFunctionImpl.create(Smalls.SimpleTableFunction.class, (String)"eval")));
                aux.add("TBLFUN_IDENTITY", (org.apache.calcite.schema.Function)Objects.requireNonNull(TableFunctionImpl.create(Smalls.IdentityTableFunction.class, (String)"eval")));
                String simpleSql = "select *\nfrom (values\n    ('ABC', 1),\n    ('DEF', 2),\n    ('GHI', 3))\n  as t(strcol, intcol)";
                aux.add("SIMPLETABLE", (org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)aux, (String)"select *\nfrom (values\n    ('ABC', 1),\n    ('DEF', 2),\n    ('GHI', 3))\n  as t(strcol, intcol)", (List)ImmutableList.of(), (List)ImmutableList.of((Object)"AUX", (Object)"SIMPLETABLE"), null));
                String lateralSql = "SELECT *\nFROM AUX.SIMPLETABLE ST\nCROSS JOIN LATERAL TABLE(AUX.TBLFUN(ST.INTCOL))";
                aux.add("VIEWLATERAL", (org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)aux, (String)"SELECT *\nFROM AUX.SIMPLETABLE ST\nCROSS JOIN LATERAL TABLE(AUX.TBLFUN(ST.INTCOL))", (List)ImmutableList.of(), (List)ImmutableList.of((Object)"AUX", (Object)"VIEWLATERAL"), null));
                return aux;
            }
            case BOOKSTORE: {
                return rootSchema.add(schema.schemaName, (Schema)new ReflectiveSchema((Object)new BookstoreSchema()));
            }
        }
        throw new AssertionError((Object)("unknown schema " + (Object)((Object)schema)));
    }

    private static SchemaPlus addSchemaIfNotExists(SchemaPlus rootSchema, SchemaSpec schemaSpec) {
        SchemaPlus schema = (SchemaPlus)rootSchema.subSchemas().get(schemaSpec.schemaName);
        if (schema != null) {
            return schema;
        }
        return CalciteAssert.addSchema(rootSchema, schemaSpec);
    }

    public static void assertArrayEqual(String message, Object[] expected, Object[] actual) {
        MatcherAssert.assertThat((String)message, (Object)CalciteAssert.str(actual), (org.hamcrest.Matcher)CoreMatchers.is((Object)CalciteAssert.str(expected)));
    }

    private static String str(Object[] objects) {
        return objects == null ? null : Arrays.stream(objects).map(Object::toString).collect(Collectors.joining("\n"));
    }

    static PropBuilder propBuilder() {
        return new PropBuilder();
    }

    static /* synthetic */ String access$800() {
        return testMysqlUrl;
    }

    static /* synthetic */ String access$900() {
        return testMysqlDriver;
    }

    private static class UnsingedScannableTable
    extends AbstractTable
    implements ScannableTable {
        private UnsingedScannableTable() {
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("utiny_value", typeFactory.createSqlType(SqlTypeName.UTINYINT)).add("usmall_value", typeFactory.createSqlType(SqlTypeName.USMALLINT)).add("uint_value", typeFactory.createSqlType(SqlTypeName.UINTEGER)).add("ubig_value", typeFactory.createSqlType(SqlTypeName.UBIGINT)).build();
        }

        public Enumerable<@Nullable Object[]> scan(DataContext root) {
            return Linq4j.asEnumerable((Object[])new Object[][]{{255, 65535, 0xFFFFFFFFL, new BigDecimal("18446744073709551615")}});
        }
    }

    private static class JavaSql {
        private static final String START = ".unwrap(javax.sql.DataSource.class), \"";
        private static final String END = "\"";
        private final String java;
        private final @Nullable String sql;

        JavaSql(String java, @Nullable String sql) {
            this.java = Objects.requireNonNull(java, "java");
            this.sql = sql;
        }

        static JavaSql fromJava(String java) {
            return new JavaSql(java, null);
        }

        static JavaSql fromSql(String sql) {
            return new JavaSql(JavaSql.wrap(sql), sql);
        }

        private static String wrap(String sql) {
            return START + sql.replace("\\", "\\\\").replace(END, "\\\"").replace("\n", "\\\\n") + END;
        }

        public List<String> extractSql() {
            return JavaSql.unwrap(this.java);
        }

        static List<String> unwrap(String java) {
            ArrayList<String> sqlList = new ArrayList<String>();
            StringBuilder b = new StringBuilder();
            int h = 0;
            block4: while (true) {
                int i;
                if ((i = java.indexOf(START, h)) < 0) {
                    return sqlList;
                }
                int j = i + START.length();
                while (j < java.length()) {
                    char c = java.charAt(j++);
                    switch (c) {
                        case '\"': {
                            sqlList.add(b.toString());
                            b.setLength(0);
                            h = j;
                            continue block4;
                        }
                        case '\\': {
                            c = java.charAt(j++);
                            if (c == 'n') {
                                b.append('\n');
                                break;
                            }
                            if (c == 'r') break;
                        }
                        default: {
                            b.append(c);
                        }
                    }
                }
                break;
            }
            return sqlList;
        }
    }

    public static interface PreparedStatementConsumer {
        public void accept(PreparedStatement var1) throws SQLException;
    }

    static class PropBuilder {
        final Properties properties = new Properties();

        PropBuilder() {
        }

        PropBuilder set(CalciteConnectionProperty p, String v) {
            this.properties.setProperty(p.camelName(), v);
            return this;
        }

        Properties build() {
            return this.properties;
        }
    }

    static class ResultSetFormatter {
        final StringBuilder buf = new StringBuilder();

        ResultSetFormatter() {
        }

        public ResultSetFormatter resultSet(ResultSet resultSet) throws SQLException {
            ResultSetMetaData metaData = resultSet.getMetaData();
            while (resultSet.next()) {
                this.rowToString(resultSet, metaData);
                this.buf.append("\n");
            }
            return this;
        }

        ResultSetFormatter rowToString(ResultSet resultSet, ResultSetMetaData metaData) throws SQLException {
            int n = metaData.getColumnCount();
            if (n > 0) {
                int i = 1;
                while (true) {
                    this.buf.append(metaData.getColumnLabel(i)).append("=").append(this.adjustValue(resultSet.getString(i)));
                    if (i == n) break;
                    this.buf.append("; ");
                    ++i;
                }
            }
            return this;
        }

        protected String adjustValue(String string) {
            if (string != null) {
                string = TestUtil.correctRoundedFloat(string);
            }
            return string;
        }

        public Collection<String> toStringList(ResultSet resultSet, Collection<String> list) throws SQLException {
            ResultSetMetaData metaData = resultSet.getMetaData();
            while (resultSet.next()) {
                this.rowToString(resultSet, metaData);
                list.add(this.buf.toString());
                this.buf.setLength(0);
            }
            return list;
        }

        public String string() {
            String s = this.buf.toString();
            this.buf.setLength(0);
            return s;
        }
    }

    public static enum SchemaSpec {
        REFLECTIVE_FOODMART("foodmart"),
        FAKE_FOODMART("foodmart"),
        JDBC_FOODMART("foodmart"),
        CLONE_FOODMART("foodmart2"),
        JDBC_FOODMART_WITH_LATTICE("lattice"),
        GEO("GEO"),
        HR("hr"),
        MY_DB("myDb"),
        UNSIGNED_TYPE("UNSIGNED_TYPE"),
        JDBC_SCOTT("JDBC_SCOTT"),
        SCOTT("scott"),
        SCOTT_WITH_TEMPORAL("scott_temporal"),
        JDBC_STEELWHEELS("JDBC_STEELWHEELS"),
        STEELWHEELS("steelwheels"),
        TPCH("tpch"),
        BLANK("BLANK"),
        LINGUAL("SALES"),
        POST("POST"),
        ORINOCO("ORINOCO"),
        AUX("AUX"),
        BOOKSTORE("bookstore");

        public final String schemaName;

        private SchemaSpec(String schemaName) {
            this.schemaName = schemaName;
        }
    }

    public static enum DatabaseInstance {
        HSQLDB(new ConnectionSpec("jdbc:hsqldb:res:foodmart", "FOODMART", "FOODMART", "org.hsqldb.jdbcDriver", "foodmart"), new ConnectionSpec("jdbc:hsqldb:res:scott", "SCOTT", "TIGER", "org.hsqldb.jdbcDriver", "SCOTT"), new ConnectionSpec("jdbc:hsqldb:res:steelwheels", "STEELWHEELS", "STEELWHEELS", "org.hsqldb.jdbcDriver", "steelwheels")),
        H2(new ConnectionSpec("jdbc:h2:" + (String)CalciteSystemProperty.TEST_DATASET_PATH.value() + "/h2/target/foodmart;user=foodmart;password=foodmart", "foodmart", "foodmart", "org.h2.Driver", "foodmart"), null, null),
        MYSQL(new ConnectionSpec(CalciteAssert.access$800(), "foodmart", "foodmart", CalciteAssert.access$900(), "foodmart"), null, null),
        STARROCKS(new ConnectionSpec(CalciteAssert.access$800(), "foodmart", "foodmart", CalciteAssert.access$900(), "foodmart"), null, null),
        DORIS(new ConnectionSpec(CalciteAssert.access$800(), "foodmart", "foodmart", CalciteAssert.access$900(), "foodmart"), null, null),
        ORACLE(new ConnectionSpec("jdbc:oracle:thin:@localhost:1521:XE", "foodmart", "foodmart", "oracle.jdbc.OracleDriver", "FOODMART"), null, null),
        POSTGRESQL(new ConnectionSpec("jdbc:postgresql://localhost/foodmart?user=foodmart&password=foodmart&searchpath=foodmart", "foodmart", "foodmart", "org.postgresql.Driver", "foodmart"), null, null);

        public final ConnectionSpec foodmart;
        public final @Nullable ConnectionSpec scott;
        public final @Nullable ConnectionSpec steelwheels;

        private DatabaseInstance(@Nullable ConnectionSpec foodmart, ConnectionSpec scott, ConnectionSpec steelwheels) {
            this.foodmart = foodmart;
            this.scott = scott;
            this.steelwheels = steelwheels;
        }
    }

    private static class NopAssertQuery
    extends AssertQuery {
        private NopAssertQuery(String sql) {
            super(new ConnectionFactory(){

                @Override
                public Connection createConnection() {
                    throw new UnsupportedOperationException();
                }
            }, sql, ImmutableList.of(), 0, false, null);
        }

        static AssertQuery of(String sql) {
            return new NopAssertQuery(sql);
        }

        @Override
        protected Connection createConnection() {
            throw new AssertionError((Object)"disabled");
        }

        @Override
        public AssertQuery returns(String sql, Consumer<ResultSet> checker) {
            return this;
        }

        @Override
        public AssertQuery throws_(String message) {
            return this;
        }

        @Override
        public AssertQuery runs() {
            return this;
        }

        @Override
        public AssertQuery convertMatches(Consumer<RelNode> checker) {
            return this;
        }

        @Override
        public AssertQuery substitutionMatches(Consumer<RelNode> checker) {
            return this;
        }

        @Override
        public AssertQuery planContains(String expected) {
            return this;
        }

        @Override
        public AssertQuery planHasSql(String expected) {
            return this;
        }

        @Override
        public AssertQuery planUpdateHasSql(String expected, int count) {
            return this;
        }

        @Override
        public AssertQuery queryContains(Consumer<List> predicate1) {
            return this;
        }
    }

    public static enum Config {
        EMPTY,
        REGULAR,
        LINGUAL,
        JDBC_FOODMART,
        JDBC_SCOTT,
        FOODMART_CLONE,
        GEO,
        JDBC_FOODMART_WITH_LATTICE,
        REGULAR_PLUS_METADATA,
        SCOTT,
        SPARK,
        AUX;

    }

    public static class AssertMetaData {
        private final ConnectionFactory connectionFactory;
        private final java.util.function.Function<Connection, ResultSet> function;

        AssertMetaData(ConnectionFactory connectionFactory, java.util.function.Function<Connection, ResultSet> function) {
            this.connectionFactory = connectionFactory;
            this.function = function;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final AssertMetaData returns(Consumer<ResultSet> checker) {
            try (Connection c = this.connectionFactory.createConnection();){
                ResultSet resultSet = this.function.apply(c);
                checker.accept(resultSet);
                resultSet.close();
                c.close();
                AssertMetaData assertMetaData = this;
                return assertMetaData;
            }
            catch (Throwable e) {
                throw TestUtil.rethrow(e);
            }
        }

        public AssertMetaData returns(String expected) {
            return this.returns(CalciteAssert.checkResult(expected));
        }
    }

    public static class AssertQuery {
        private final String sql;
        private final ConnectionFactory connectionFactory;
        private final int limit;
        private final boolean materializationsEnabled;
        private final ImmutableList<Pair<Hook, Consumer>> hooks;
        private final @Nullable PreparedStatementConsumer consumer;
        private @Nullable String plan;

        private AssertQuery(ConnectionFactory connectionFactory, String sql, ImmutableList<Pair<Hook, Consumer>> hooks, int limit, boolean materializationsEnabled, @Nullable PreparedStatementConsumer consumer) {
            this.sql = Objects.requireNonNull(sql, "sql");
            this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory");
            this.hooks = Objects.requireNonNull(hooks, "hooks");
            this.limit = limit;
            this.materializationsEnabled = materializationsEnabled;
            this.consumer = consumer;
        }

        protected Connection createConnection() {
            try {
                return this.connectionFactory.createConnection();
            }
            catch (SQLException e) {
                throw new IllegalStateException("Unable to create connection: connectionFactory = " + this.connectionFactory, e);
            }
        }

        public final AssertQuery withConnection(Consumer<Connection> f) {
            try (Connection c = this.createConnection();){
                f.accept(c);
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
            return this;
        }

        public AssertQuery enable(boolean enabled) {
            return enabled ? this : NopAssertQuery.of(this.sql);
        }

        public AssertQuery returns(String expected) {
            return this.returns(CalciteAssert.checkResult(expected));
        }

        public AssertQuery returns2(String expected) {
            return this.returns(CalciteAssert.checkResult(expected, new ResultSetFormatter(){

                @Override
                protected String adjustValue(String s) {
                    if (s != null) {
                        if (s.contains(".")) {
                            while (s.endsWith("0")) {
                                s = s.substring(0, s.length() - 1);
                            }
                            if (s.endsWith(".")) {
                                s = s.substring(0, s.length() - 1);
                            }
                        }
                        if (s.endsWith(" 00:00:00")) {
                            s = s.substring(0, s.length() - " 00:00:00".length());
                        }
                    }
                    return super.adjustValue(s);
                }
            }));
        }

        public AssertQuery returnsValue(String expected) {
            return this.returns(CalciteAssert.checkResultValue(expected));
        }

        public AssertQuery returnsCount(int expectedCount) {
            return this.returns(CalciteAssert.checkResultCount((org.hamcrest.Matcher<Integer>)CoreMatchers.is((Object)expectedCount)));
        }

        public final AssertQuery returns(Consumer<ResultSet> checker) {
            return this.returns(this.sql, checker);
        }

        public final AssertQuery updates(int count) {
            return this.withConnection(connection -> CalciteAssert.assertQuery(connection, this.sql, this.limit, this.materializationsEnabled, this.hooks, null, CalciteAssert.checkUpdateCount(count), null));
        }

        protected AssertQuery returns(String sql, Consumer<ResultSet> checker) {
            return this.withConnection(connection -> {
                if (this.consumer == null) {
                    CalciteAssert.assertQuery(connection, sql, this.limit, this.materializationsEnabled, this.hooks, checker, null, null);
                } else {
                    CalciteAssert.assertPrepare(connection, sql, this.limit, this.materializationsEnabled, this.hooks, checker, null, null, this.consumer);
                }
            });
        }

        public AssertQuery returnsUnordered(String ... lines) {
            return this.returns(CalciteAssert.checkResult(true, false, lines));
        }

        public AssertQuery returnsOrdered(String ... lines) {
            return this.returns(CalciteAssert.checkResult(false, false, lines));
        }

        public AssertQuery returnsStartingWith(String ... lines) {
            return this.returns(CalciteAssert.checkResult(false, true, lines));
        }

        public AssertQuery throws_(String message) {
            return this.withConnection(connection -> CalciteAssert.assertQuery(connection, this.sql, this.limit, this.materializationsEnabled, this.hooks, null, null, CalciteAssert.checkException(message)));
        }

        public AssertQuery failsAtValidation(@Nullable String optionalMessage) {
            return this.withConnection(connection -> CalciteAssert.assertQuery(connection, this.sql, this.limit, this.materializationsEnabled, this.hooks, null, null, CalciteAssert.checkValidationException(optionalMessage)));
        }

        public AssertQuery failsAtValidation() {
            return this.failsAtValidation(null);
        }

        public AssertQuery runs() {
            return this.withConnection(connection -> {
                if (this.consumer == null) {
                    CalciteAssert.assertQuery(connection, this.sql, this.limit, this.materializationsEnabled, this.hooks, null, null, null);
                } else {
                    CalciteAssert.assertPrepare(connection, this.sql, this.limit, this.materializationsEnabled, this.hooks, null, null, null, this.consumer);
                }
            });
        }

        public AssertQuery typeIs(String expected) {
            return this.withConnection(connection -> CalciteAssert.assertQuery(connection, this.sql, this.limit, false, this.hooks, CalciteAssert.checkResultType(expected), null, null));
        }

        public final AssertQuery convertContains(String expected) {
            return this.convertMatches(CalciteAssert.checkRel(expected, null));
        }

        public AssertQuery consumesPreparedStatement(PreparedStatementConsumer consumer) {
            if (consumer == this.consumer) {
                return this;
            }
            return new AssertQuery(this.connectionFactory, this.sql, this.hooks, this.limit, this.materializationsEnabled, consumer);
        }

        public AssertQuery convertMatches(Consumer<RelNode> checker) {
            return this.withConnection(connection -> CalciteAssert.assertPrepare(connection, this.sql, this.materializationsEnabled, this.hooks, checker, null));
        }

        public AssertQuery substitutionMatches(Consumer<RelNode> checker) {
            return this.withConnection(connection -> CalciteAssert.assertPrepare(connection, this.sql, this.materializationsEnabled, this.hooks, null, checker));
        }

        public AssertQuery explainContains(String expected) {
            return this.explainMatches("", CalciteAssert.checkResultContains(expected));
        }

        @API(since="1.22", status=API.Status.EXPERIMENTAL)
        public AssertQuery explainHookContains(String expectedPlan) {
            return this.explainHookContains(SqlExplainLevel.EXPPLAN_ATTRIBUTES, expectedPlan);
        }

        @API(since="1.22", status=API.Status.EXPERIMENTAL)
        public AssertQuery explainHookContains(SqlExplainLevel sqlExplainLevel, String expectedPlan) {
            return this.explainHookMatches(sqlExplainLevel, (org.hamcrest.Matcher<String>)CoreMatchers.containsString((String)expectedPlan));
        }

        @API(since="1.22", status=API.Status.EXPERIMENTAL)
        public AssertQuery explainHookMatches(String expectedPlan) {
            return this.explainHookMatches(SqlExplainLevel.EXPPLAN_ATTRIBUTES, (org.hamcrest.Matcher<String>)CoreMatchers.is((Object)expectedPlan));
        }

        @API(since="1.22", status=API.Status.EXPERIMENTAL)
        public AssertQuery explainHookMatches(org.hamcrest.Matcher<String> planMatcher) {
            return this.explainHookMatches(SqlExplainLevel.EXPPLAN_ATTRIBUTES, planMatcher);
        }

        @API(since="1.22", status=API.Status.EXPERIMENTAL)
        public AssertQuery explainHookMatches(SqlExplainLevel sqlExplainLevel, org.hamcrest.Matcher<String> planMatcher) {
            return this.withHook(Hook.PLAN_BEFORE_IMPLEMENTATION, root -> MatcherAssert.assertThat((String)("Execution plan for sql " + this.sql), (Object)RelOptUtil.toString((RelNode)root.rel, (SqlExplainLevel)sqlExplainLevel), Matchers.compose(planMatcher, Util::toLinux)));
        }

        public final AssertQuery explainMatches(String extra, Consumer<ResultSet> checker) {
            return this.returns("explain plan " + Objects.requireNonNull(extra, "extra") + "for " + this.sql, checker);
        }

        public AssertQuery planContains(String expected) {
            return this.planContains(null, JavaSql.fromJava(expected));
        }

        public AssertQuery planUpdateHasSql(String expected, int count) {
            return this.planContains(CalciteAssert.checkUpdateCount(count), JavaSql.fromSql(expected));
        }

        private AssertQuery planContains(@Nullable Consumer<Integer> checkUpdate, JavaSql expected) {
            this.ensurePlan(checkUpdate);
            Objects.requireNonNull(this.plan, "plan");
            if (expected.sql != null) {
                List<String> planSqls = JavaSql.fromJava(this.plan).extractSql();
                if (planSqls.size() == 1) {
                    String planSql = planSqls.get(0);
                    MatcherAssert.assertThat((String)("Execution plan for sql " + this.sql), (Object)planSql, (org.hamcrest.Matcher)CoreMatchers.is((Object)expected.sql));
                } else {
                    MatcherAssert.assertThat((String)("Execution plan for sql " + this.sql), planSqls, (org.hamcrest.Matcher)CoreMatchers.hasItem((Object)expected.sql));
                }
            } else {
                MatcherAssert.assertThat((String)("Execution plan for sql " + this.sql), (Object)this.plan, Matchers.containsStringLinux(expected.java));
            }
            return this;
        }

        public AssertQuery planHasSql(String expected) {
            return this.planContains(null, JavaSql.fromSql(expected));
        }

        private void ensurePlan(@Nullable Consumer<Integer> checkUpdate) {
            if (this.plan != null) {
                return;
            }
            ImmutableList newHooks = CalciteAssert.addPair(this.hooks, Hook.JAVA_PLAN, this::setPlan);
            this.withConnection(arg_0 -> this.lambda$ensurePlan$9((List)newHooks, checkUpdate, arg_0));
        }

        private void setPlan(String plan) {
            this.plan = plan;
        }

        public AssertQuery queryContains(Consumer<List> predicate1) {
            ArrayList list = new ArrayList();
            ImmutableList newHooks = CalciteAssert.addPair(this.hooks, Hook.QUERY_PLAN, list::add);
            return this.withConnection(arg_0 -> this.lambda$queryContains$10((List)newHooks, predicate1, list, arg_0));
        }

        @Deprecated
        public final AssertQuery queryContains(Function<List, Void> predicate1) {
            return this.queryContains(AssertQuery.functionConsumer(predicate1));
        }

        private static <T, R> Consumer<T> functionConsumer(Function<T, R> handler) {
            return t -> {
                Object r = handler.apply(t);
                Util.discard((Object)r);
            };
        }

        public AssertQuery limit(int limit) {
            if (limit == this.limit) {
                return this;
            }
            return new AssertQuery(this.connectionFactory, this.sql, this.hooks, limit, this.materializationsEnabled, this.consumer);
        }

        public void sameResultWithMaterializationsDisabled() {
            boolean ordered = this.sql.toUpperCase(Locale.ROOT).contains("ORDER BY");
            Consumer<ResultSet> checker = CalciteAssert.consistentResult(ordered);
            this.enableMaterializations(false).returns(checker);
            this.returns(checker);
        }

        public AssertQuery enableMaterializations(boolean materializationsEnabled) {
            if (materializationsEnabled == this.materializationsEnabled) {
                return this;
            }
            return new AssertQuery(this.connectionFactory, this.sql, this.hooks, this.limit, materializationsEnabled, this.consumer);
        }

        public <T> AssertQuery withHook(Hook hook, Consumer<T> handler) {
            ImmutableList hooks = CalciteAssert.addPair(this.hooks, hook, handler);
            return new AssertQuery(this.connectionFactory, this.sql, (ImmutableList<Pair<Hook, Consumer>>)hooks, this.limit, this.materializationsEnabled, this.consumer);
        }

        public <V> AssertQuery withProperty(Hook hook, V value) {
            return this.withHook(hook, Hook.propertyJ(value));
        }

        private /* synthetic */ void lambda$queryContains$10(List newHooks, Consumer predicate1, List list, Connection connection) {
            CalciteAssert.assertQuery(connection, this.sql, this.limit, this.materializationsEnabled, newHooks, null, null, null);
            predicate1.accept(list);
        }

        private /* synthetic */ void lambda$ensurePlan$9(List newHooks, Consumer checkUpdate, Connection connection) {
            CalciteAssert.assertQuery(connection, this.sql, this.limit, this.materializationsEnabled, newHooks, null, checkUpdate, null);
            Assertions.assertNotNull((Object)this.plan);
        }
    }

    @FunctionalInterface
    public static interface ConnectionPostProcessor {
        public Connection apply(Connection var1) throws SQLException;
    }

    public static class AssertThat {
        private final ConnectionFactory connectionFactory;
        private final ImmutableList<Pair<Hook, Consumer>> hooks;
        private static final AssertThat EMPTY = new AssertThat(ConnectionFactories.empty(), (ImmutableList<Pair<Hook, Consumer>>)ImmutableList.of());

        private AssertThat(ConnectionFactory connectionFactory, ImmutableList<Pair<Hook, Consumer>> hooks) {
            this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory");
            this.hooks = Objects.requireNonNull(hooks, "hooks");
        }

        public AssertThat with(Config config) {
            switch (config) {
                case EMPTY: {
                    return EMPTY;
                }
                case REGULAR: {
                    return this.with(SchemaSpec.HR, SchemaSpec.REFLECTIVE_FOODMART, SchemaSpec.POST);
                }
                case REGULAR_PLUS_METADATA: {
                    return this.with(SchemaSpec.HR, SchemaSpec.REFLECTIVE_FOODMART);
                }
                case GEO: {
                    return this.with(SchemaSpec.GEO).with((ConnectionProperty)CalciteConnectionProperty.CONFORMANCE, (Object)SqlConformanceEnum.LENIENT);
                }
                case LINGUAL: {
                    return this.with(SchemaSpec.LINGUAL);
                }
                case JDBC_FOODMART: {
                    return this.with(SchemaSpec.JDBC_FOODMART);
                }
                case FOODMART_CLONE: {
                    return this.with(SchemaSpec.CLONE_FOODMART);
                }
                case JDBC_FOODMART_WITH_LATTICE: {
                    return this.with(SchemaSpec.JDBC_FOODMART_WITH_LATTICE);
                }
                case JDBC_SCOTT: {
                    return this.with(SchemaSpec.JDBC_SCOTT);
                }
                case SCOTT: {
                    return this.with(SchemaSpec.SCOTT);
                }
                case SPARK: {
                    return this.with((ConnectionProperty)CalciteConnectionProperty.SPARK, (Object)true);
                }
                case AUX: {
                    return this.with(SchemaSpec.AUX, SchemaSpec.POST);
                }
            }
            throw Util.unexpected((Enum)config);
        }

        public AssertThat with(SchemaSpec ... specs) {
            AssertThat next = this;
            for (SchemaSpec spec : specs) {
                next = next.with(ConnectionFactories.add(spec));
            }
            return next;
        }

        public AssertThat with(ConnectionFactory connectionFactory) {
            return new AssertThat(connectionFactory, this.hooks);
        }

        public <T> AssertThat withHook(Hook hook, Consumer<T> handler) {
            return new AssertThat(this.connectionFactory, (ImmutableList<Pair<Hook, Consumer>>)CalciteAssert.addPair(this.hooks, hook, handler));
        }

        public final AssertThat with(Map<String, String> map) {
            AssertThat x = this;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                x = this.with(entry.getKey(), (Object)entry.getValue());
            }
            return x;
        }

        public AssertThat with(String property, Object value) {
            return this.with(this.connectionFactory.with(property, value));
        }

        public AssertThat with(ConnectionProperty property, Object value) {
            if (!property.type().valid(value, property.valueClass())) {
                throw new IllegalArgumentException();
            }
            return this.with(this.connectionFactory.with(property, value));
        }

        public AssertThat with(Lex lex) {
            return this.with((ConnectionProperty)CalciteConnectionProperty.LEX, (Object)lex);
        }

        public AssertThat with(SqlConformanceEnum conformance) {
            return this.with((ConnectionProperty)CalciteConnectionProperty.CONFORMANCE, (Object)conformance);
        }

        public AssertThat withSchema(String name, Schema schema) {
            return this.with(ConnectionFactories.add(name, schema));
        }

        public AssertThat withDefaultSchema(String schema) {
            return this.with(ConnectionFactories.setDefault(schema));
        }

        public AssertThat with(ConnectionPostProcessor postProcessor) {
            return this.with(this.connectionFactory.with(postProcessor));
        }

        public final AssertThat withModel(String model) {
            return this.with((ConnectionProperty)CalciteConnectionProperty.MODEL, (Object)("inline:" + model));
        }

        public final AssertThat withModel(URL model) {
            return this.with((ConnectionProperty)CalciteConnectionProperty.MODEL, (Object)Sources.of((URL)model).file().getAbsolutePath());
        }

        public final AssertThat withMaterializations(String model, String ... materializations) {
            return this.withMaterializations(model, false, materializations);
        }

        public final AssertThat withMaterializations(String model, boolean existing, String ... materializations) {
            return this.withMaterializations(model, (JsonBuilder builder) -> {
                assert (materializations.length % 2 == 0);
                List list = builder.list();
                for (int i = 0; i < materializations.length; ++i) {
                    String table = materializations[i++];
                    Map map = builder.map();
                    map.put("table", table);
                    if (!existing) {
                        map.put("view", table + "v");
                    }
                    String sql = materializations[i];
                    String sql2 = sql.replace("`", "\"");
                    map.put("sql", sql2);
                    list.add(map);
                }
                return list;
            });
        }

        public final AssertThat withMaterializations(String model, java.util.function.Function<JsonBuilder, List<Object>> materializations) {
            String model2;
            JsonBuilder builder = new JsonBuilder();
            List<Object> list = materializations.apply(builder);
            String buf = "materializations: " + builder.toJsonString(list);
            if (model.contains("defaultSchema: 'foodmart'")) {
                int endIndex = model.lastIndexOf(93);
                model2 = model.substring(0, endIndex) + ",\n{ name: 'mat', " + buf + "}\n]" + model.substring(endIndex + 1);
            } else if (model.contains("type: ")) {
                model2 = model.replaceFirst("type: ", Matcher.quoteReplacement(buf + ",\ntype: "));
            } else {
                throw new AssertionError((Object)"do not know where to splice");
            }
            return this.withModel(model2);
        }

        public AssertQuery query(String sql) {
            return new AssertQuery(this.connectionFactory, sql, this.hooks, -1, false, null);
        }

        public AssertQuery withRel(final java.util.function.Function<RelBuilder, RelNode> relFn) {
            class Handler {
                Handler() {
                }

                void accept(Pair<FrameworkConfig, Holder<CalcitePrepare.Query>> pair) {
                    FrameworkConfig frameworkConfig = (FrameworkConfig)pair.left;
                    Holder queryHolder = (Holder)pair.right;
                    FrameworkConfig config = Frameworks.newConfigBuilder((FrameworkConfig)frameworkConfig).context(Contexts.of((Object)CalciteConnectionConfig.DEFAULT.set(CalciteConnectionProperty.FORCE_DECORRELATE, Boolean.toString(false)))).build();
                    RelBuilder b = RelBuilder.create((FrameworkConfig)config);
                    queryHolder.set((Object)CalcitePrepare.Query.of((RelNode)((RelNode)relFn.apply(b))));
                }
            }
            return this.withHook(Hook.STRING_TO_QUERY, new Handler()::accept).query("?");
        }

        public AssertThat connectThrows(String message) {
            return this.connectThrows(CalciteAssert.checkException(message));
        }

        public AssertThat connectThrows(Consumer<Throwable> exceptionChecker) {
            Throwable throwable;
            try (Connection x = this.connectionFactory.createConnection();){
                try {
                    x.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throwable = null;
            }
            catch (Throwable e) {
                throwable = e;
            }
            exceptionChecker.accept(throwable);
            return this;
        }

        public <T> AssertThat doWithConnection(java.util.function.Function<CalciteConnection, T> fn) throws Exception {
            try (Connection connection = this.connectionFactory.createConnection();){
                T t = fn.apply((CalciteConnection)connection);
                Util.discard(t);
                AssertThat assertThat = this;
                return assertThat;
            }
        }

        public final AssertThat doWithConnection(Consumer<CalciteConnection> fn) throws Exception {
            return this.doWithConnection((CalciteConnection c) -> {
                fn.accept((CalciteConnection)c);
                return null;
            });
        }

        public <T> AssertThat doWithDataContext(java.util.function.Function<DataContext, T> fn) throws Exception {
            try (CalciteConnection connection = (CalciteConnection)this.connectionFactory.createConnection();){
                DataContext dataContext = CalciteMetaImpl.createDataContext((CalciteConnection)connection);
                T t = fn.apply(dataContext);
                Util.discard(t);
                AssertThat assertThat = this;
                return assertThat;
            }
        }

        public Connection connect() throws SQLException {
            return this.connectionFactory.createConnection();
        }

        public AssertThat enable(boolean enabled) {
            return enabled ? this : DISABLED;
        }

        public AssertThat pooled() {
            return this.with(ConnectionFactories.pool(this.connectionFactory));
        }

        public AssertMetaData metaData(java.util.function.Function<Connection, ResultSet> function) {
            return new AssertMetaData(this.connectionFactory, function);
        }
    }
}

