/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.test;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.PairList;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.parser.StringAndPos;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.test.SqlTests;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.test.DiffRepository;
import org.apache.calcite.test.Matchers;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;

public abstract class AbstractSqlTester
implements SqlTester,
AutoCloseable {
    private static final String NL = System.getProperty("line.separator");

    @Override
    public void close() {
    }

    @Override
    public void assertExceptionIsThrown(SqlTestFactory factory, StringAndPos sap, @Nullable String expectedMsgPattern) {
        SqlNode sqlNode;
        try {
            sqlNode = this.parseQuery(factory, sap.sql);
        }
        catch (Throwable e) {
            SqlTests.checkEx(e, expectedMsgPattern, sap, SqlTests.Stage.PARSE);
            return;
        }
        SqlValidator validator = factory.createValidator();
        Throwable thrown = null;
        try {
            validator.validate(sqlNode);
        }
        catch (Throwable ex) {
            thrown = ex;
        }
        SqlTests.checkEx(thrown, expectedMsgPattern, sap, SqlTests.Stage.VALIDATE);
    }

    protected void checkParseEx(Throwable e, @Nullable String expectedMsgPattern, StringAndPos sap) {
        try {
            throw e;
        }
        catch (SqlParseException spe) {
            String errMessage = spe.getMessage();
            if (expectedMsgPattern == null) {
                throw new RuntimeException("Error while parsing query:" + sap, spe);
            }
            if (errMessage == null || !Util.toLinux((String)errMessage).matches(expectedMsgPattern)) {
                throw new RuntimeException("Error did not match expected [" + expectedMsgPattern + "] while parsing query [" + sap + "]", spe);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Error while parsing query: " + sap, t);
        }
    }

    @Override
    public RelDataType getColumnType(SqlTestFactory factory, String sql) {
        return this.validateAndApply(factory, StringAndPos.of((String)sql), (sql1, validator, n) -> {
            RelDataType rowType = validator.getValidatedNodeType(n);
            List fields = rowType.getFieldList();
            MatcherAssert.assertThat((String)"expected query to return 1 field", (Object)fields, (Matcher)org.hamcrest.Matchers.hasSize((int)1));
            return ((RelDataTypeField)fields.get(0)).getType();
        });
    }

    @Override
    public RelDataType getResultType(SqlTestFactory factory, String sql) {
        return this.validateAndApply(factory, StringAndPos.of((String)sql), (sql1, validator, n) -> validator.getValidatedNodeType(n));
    }

    Pair<SqlValidator, SqlNode> parseAndValidate(SqlTestFactory factory, String sql) {
        SqlNode sqlNode;
        try {
            sqlNode = this.parseQuery(factory, sql);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while parsing query: " + sql, e);
        }
        SqlValidator validator = factory.createValidator();
        return Pair.of((Object)validator, (Object)validator.validate(sqlNode));
    }

    @Override
    public SqlNode parseQuery(SqlTestFactory factory, String sql) throws SqlParseException {
        SqlParser parser = factory.createParser(sql);
        return parser.parseQuery();
    }

    @Override
    public SqlNode parseExpression(SqlTestFactory factory, String expr) throws SqlParseException {
        SqlParser parser = factory.createParser(expr);
        return parser.parseExpression();
    }

    @Override
    public void checkColumnType(SqlTestFactory factory, String sql, String expected) {
        this.validateAndThen(factory, StringAndPos.of((String)sql), AbstractSqlTester.checkColumnTypeAction((Matcher<String>)CoreMatchers.is((Object)expected)));
    }

    private static SqlTester.ValidatedNodeConsumer checkColumnTypeAction(Matcher<String> matcher) {
        return (sql1, validator, validatedNode) -> {
            RelDataType rowType = validator.getValidatedNodeType(validatedNode);
            List fields = rowType.getFieldList();
            MatcherAssert.assertThat((String)"expected query to return 1 field", (Object)fields, (Matcher)org.hamcrest.Matchers.hasSize((int)1));
            RelDataType actualType = ((RelDataTypeField)fields.get(0)).getType();
            String actual = SqlTests.getTypeString(actualType);
            MatcherAssert.assertThat((Object)actual, (Matcher)matcher);
        };
    }

    @Override
    public void setFor(SqlOperator operator, SqlTester.VmName ... unimplementedVmNames) {
    }

    @Override
    public void checkAgg(SqlTestFactory factory, String expr, String[] inputValues, SqlTester.ResultChecker resultChecker) {
        String query = SqlTests.generateAggQuery(expr, inputValues);
        this.check(factory, query, SqlTests.ANY_TYPE_CHECKER, resultChecker);
    }

    @Override
    public void checkWinAgg(SqlTestFactory factory, String expr, String[] inputValues, String windowSpec, String type, SqlTester.ResultChecker resultChecker) {
        String query = SqlTests.generateWinAggQuery(expr, windowSpec, inputValues);
        this.check(factory, query, SqlTests.ANY_TYPE_CHECKER, resultChecker);
    }

    @Override
    public void check(SqlTestFactory factory, String queryWithCarets, SqlTester.TypeChecker typeChecker, SqlTester.ParameterChecker parameterChecker, SqlTester.ResultChecker resultChecker) {
        Objects.requireNonNull(typeChecker, "typeChecker");
        Objects.requireNonNull(parameterChecker, "parameterChecker");
        Objects.requireNonNull(resultChecker, "resultChecker");
        RelDataType actualType = this.getColumnType(factory, queryWithCarets);
        typeChecker.checkType(() -> "Query: " + queryWithCarets, actualType);
        StringAndPos pos = StringAndPos.of((String)queryWithCarets);
        Pair<SqlValidator, SqlNode> p = this.parseAndValidate(factory, pos.sql);
        SqlValidator validator = (SqlValidator)p.left;
        SqlNode n = (SqlNode)p.right;
        RelDataType parameterRowType = validator.getParameterRowType(n);
        parameterChecker.checkParameters(parameterRowType);
    }

    @Override
    public void validateAndThen(SqlTestFactory factory, StringAndPos sap, SqlTester.ValidatedNodeConsumer consumer) {
        Pair<SqlValidator, SqlNode> p = this.parseAndValidate(factory, sap.sql);
        SqlValidator validator = (SqlValidator)p.left;
        SqlNode rewrittenNode = (SqlNode)p.right;
        consumer.accept(sap, validator, rewrittenNode);
    }

    @Override
    public <R> R validateAndApply(SqlTestFactory factory, StringAndPos sap, SqlTester.ValidatedNodeFunction<R> function) {
        Pair<SqlValidator, SqlNode> p = this.parseAndValidate(factory, sap.sql);
        SqlValidator validator = (SqlValidator)p.left;
        SqlNode rewrittenNode = (SqlNode)p.right;
        return function.apply(sap, validator, rewrittenNode);
    }

    @Override
    public void checkFails(SqlTestFactory factory, StringAndPos sap, String expectedError, boolean runtime) {
        if (runtime) {
            String sql = AbstractSqlTester.buildQuery(sap);
            Pair<SqlValidator, SqlNode> p = this.parseAndValidate(factory, sql);
            SqlNode n = (SqlNode)p.right;
            Assertions.assertNotNull((Object)n);
        } else {
            StringAndPos sap1 = StringAndPos.of((String)AbstractSqlTester.buildQuery(sap));
            this.checkQueryFails(factory, sap1, expectedError);
        }
    }

    @Override
    public void checkQueryFails(SqlTestFactory factory, StringAndPos sap, String expectedError) {
        this.assertExceptionIsThrown(factory, sap, expectedError);
    }

    @Override
    public void checkAggFails(SqlTestFactory factory, String expr, String[] inputValues, String expectedError, boolean runtime) {
        String sql = SqlTests.generateAggQuery(expr, inputValues);
        if (runtime) {
            Pair<SqlValidator, SqlNode> p = this.parseAndValidate(factory, sql);
            SqlNode n = (SqlNode)p.right;
            Assertions.assertNotNull((Object)n);
        } else {
            this.checkQueryFails(factory, StringAndPos.of((String)sql), expectedError);
        }
    }

    @Deprecated
    public static String buildQuery(String expressionWithCarets) {
        StringAndPos sap = StringAndPos.of((String)expressionWithCarets);
        return AbstractSqlTester.buildQuery(sap);
    }

    public static String buildQuery(StringAndPos sap) {
        return "values (" + sap.sql + ")";
    }

    public static StringAndPos buildQueryWithPos(StringAndPos sap) {
        return StringAndPos.of((String)("values (" + sap.addCarets() + ")"));
    }

    public static String buildQueryAgg(String expression) {
        return "select " + expression + " from (values (1)) as t(x) group by x";
    }

    protected String buildQuery2(SqlTestFactory factory, String expressionWithCarets) {
        SqlNode x;
        if (expressionWithCarets.matches("(?i).*(percentile_(cont|disc)|convert|sort_array|cast)\\(.*")) {
            return AbstractSqlTester.buildQuery(expressionWithCarets);
        }
        StringAndPos sap = StringAndPos.of((String)expressionWithCarets);
        String sql = "values (" + sap.sql + ")";
        try {
            x = this.parseQuery(factory, sql);
        }
        catch (SqlParseException e) {
            throw TestUtil.rethrow(e);
        }
        final LinkedHashSet literalSet = new LinkedHashSet();
        x.accept((SqlVisitor)new SqlShuttle(){
            private final List<SqlOperator> ops = ImmutableList.of((Object)SqlStdOperatorTable.LITERAL_CHAIN, (Object)SqlStdOperatorTable.LOCALTIME, (Object)SqlStdOperatorTable.LOCALTIMESTAMP, (Object)SqlStdOperatorTable.CURRENT_TIME, (Object)SqlStdOperatorTable.CURRENT_TIMESTAMP);

            public SqlNode visit(SqlLiteral literal) {
                if (!this.isNull((SqlNode)literal) && literal.getTypeName() != SqlTypeName.SYMBOL) {
                    literalSet.add(literal);
                }
                return literal;
            }

            public @Nullable SqlNode visit(SqlCall call) {
                SqlOperator operator = call.getOperator();
                if (operator.getKind() == SqlKind.LAMBDA) {
                    return call;
                }
                if (operator instanceof SqlUnresolvedFunction) {
                    SqlUnresolvedFunction unresolvedFunction = (SqlUnresolvedFunction)operator;
                    SqlOperator lookup = SqlValidatorUtil.lookupSqlFunctionByID((SqlOperatorTable)SqlStdOperatorTable.instance(), (SqlIdentifier)Objects.requireNonNull(unresolvedFunction.getSqlIdentifier()), (SqlFunctionCategory)unresolvedFunction.getFunctionType());
                    if (lookup != null) {
                        operator = lookup;
                        call = operator.createCall(call.getFunctionQuantifier(), call.getParserPosition(), (Iterable)call.getOperandList());
                    }
                }
                if (operator == SqlStdOperatorTable.CAST && this.isNull(call.operand(0))) {
                    literalSet.add(call);
                    return call;
                }
                if (operator == SqlStdOperatorTable.TRIM) {
                    call.operand(2).accept((SqlVisitor)this);
                    return call;
                }
                if (this.ops.contains(operator)) {
                    return call;
                }
                return super.visit(call);
            }

            private boolean isNull(SqlNode sqlNode) {
                return sqlNode instanceof SqlLiteral && ((SqlLiteral)sqlNode).getTypeName() == SqlTypeName.NULL;
            }
        });
        ArrayList nodes = new ArrayList(literalSet);
        nodes.sort((o1, o2) -> {
            SqlParserPos pos0 = o1.getParserPosition();
            SqlParserPos pos1 = o2.getParserPosition();
            int c = -Utilities.compare((int)pos0.getLineNum(), (int)pos1.getLineNum());
            if (c != 0) {
                return c;
            }
            return -Utilities.compare((int)pos0.getColumnNum(), (int)pos1.getColumnNum());
        });
        String sql2 = sql;
        PairList values = PairList.of();
        int p = 0;
        for (SqlNode literal : nodes) {
            SqlParserPos pos = literal.getParserPosition();
            int start = SqlParserUtil.lineColToIndex((String)sql, (int)pos.getLineNum(), (int)pos.getColumnNum());
            int end = SqlParserUtil.lineColToIndex((String)sql, (int)pos.getEndLineNum(), (int)pos.getEndColumnNum()) + 1;
            String param = "p" + p++;
            values.add((Object)sql2.substring(start, end), (Object)param);
            sql2 = sql2.substring(0, start) + param + sql2.substring(end);
        }
        if (values.isEmpty()) {
            values.add((Object)"1", (Object)"p0");
        }
        return "select " + sql2.substring("values (".length(), sql2.length() - 1) + " from (values (" + Util.commaList((List)values.leftList()) + ")) as t(" + Util.commaList((List)values.rightList()) + ")";
    }

    @Override
    public void forEachQuery(SqlTestFactory factory, String expressionWithCarets, Consumer<String> consumer) {
        consumer.accept("values (" + expressionWithCarets + ")");
        String query2 = this.buildQuery2(factory, expressionWithCarets);
        consumer.accept(SqlParserUtil.escapeCarets((String)query2));
    }

    @Override
    public void assertConvertsTo(SqlTestFactory factory, DiffRepository diffRepos, String sql, String plan, boolean trim, boolean expression, boolean decorrelate) {
        if (expression) {
            this.assertExprConvertsTo(factory, diffRepos, sql, plan);
        } else {
            this.assertSqlConvertsTo(factory, diffRepos, sql, plan, trim, decorrelate);
        }
    }

    private void assertExprConvertsTo(SqlTestFactory factory, DiffRepository diffRepos, String expr, String plan) {
        String expr2 = diffRepos.expand("sql", expr);
        RexNode rex = this.convertExprToRex(factory, expr2);
        Assertions.assertNotNull((Object)rex);
        String actual = NL + rex + NL;
        diffRepos.assertEquals("plan", plan, actual);
    }

    private void assertSqlConvertsTo(SqlTestFactory factory, DiffRepository diffRepos, String sql, String plan, boolean trim, boolean decorrelate) {
        String sql2 = diffRepos.expand("sql", sql);
        Pair<SqlValidator, RelRoot> pair = this.convertSqlToRel2(factory, sql2, decorrelate, trim);
        RelRoot root = (RelRoot)pair.right;
        SqlValidator validator = (SqlValidator)pair.left;
        RelNode rel = root.project();
        Assertions.assertNotNull((Object)rel);
        MatcherAssert.assertThat((Object)rel, Matchers.relIsValid());
        if (trim) {
            RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(rel.getCluster(), null);
            RelFieldTrimmer trimmer = this.createFieldTrimmer(validator, relBuilder);
            rel = trimmer.trim(rel);
            Assertions.assertNotNull((Object)rel);
            MatcherAssert.assertThat((Object)rel, Matchers.relIsValid());
        }
        String actual = NL + RelOptUtil.toString((RelNode)rel);
        diffRepos.assertEquals("plan", plan, actual);
    }

    private RexNode convertExprToRex(SqlTestFactory factory, String expr) {
        SqlNode sqlQuery;
        Objects.requireNonNull(expr, "expr");
        try {
            sqlQuery = this.parseExpression(factory, expr);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw TestUtil.rethrow(e);
        }
        SqlToRelConverter converter = factory.createSqlToRelConverter();
        SqlValidator validator = Objects.requireNonNull(converter.validator);
        SqlNode validatedQuery = validator.validate(sqlQuery);
        return converter.convertExpression(validatedQuery);
    }

    @Override
    public Pair<SqlValidator, RelRoot> convertSqlToRel2(SqlTestFactory factory, String sql, boolean decorrelate, boolean trim) {
        SqlNode sqlQuery;
        Objects.requireNonNull(sql, "sql");
        try {
            sqlQuery = this.parseQuery(factory, sql);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw TestUtil.rethrow(e);
        }
        SqlToRelConverter converter = factory.createSqlToRelConverter();
        SqlValidator validator = Objects.requireNonNull(converter.validator);
        SqlNode validatedQuery = validator.validate(sqlQuery);
        RelRoot root = converter.convertQuery(validatedQuery, false, true);
        Objects.requireNonNull(root, "root");
        if (decorrelate || trim) {
            root = root.withRel(converter.flattenTypes(root.rel, true));
        }
        if (decorrelate) {
            root = root.withRel(converter.decorrelate(sqlQuery, root.rel));
        }
        if (trim) {
            root = root.withRel(converter.trimUnusedFields(true, root.rel));
        }
        return Pair.of((Object)validator, (Object)root);
    }

    @Override
    public RelNode trimRelNode(SqlTestFactory factory, RelNode relNode) {
        SqlToRelConverter converter = factory.createSqlToRelConverter();
        RelNode r2 = converter.flattenTypes(relNode, true);
        return converter.trimUnusedFields(true, r2);
    }

    public RelFieldTrimmer createFieldTrimmer(SqlValidator validator, RelBuilder relBuilder) {
        return new RelFieldTrimmer(validator, relBuilder);
    }
}

