/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.regex.Pattern;
import org.apache.calcite.sql.test.SqlOperatorFixture;
import org.apache.calcite.test.SqlOperatorTest;
import org.apache.calcite.util.DelegatingInvocationHandler;
import org.checkerframework.checker.nullness.qual.Nullable;

class SqlOperatorFixtures {
    private SqlOperatorFixtures() {
    }

    static SqlOperatorFixture safeCastWrapper(SqlOperatorFixture fixture, String functionName) {
        return (SqlOperatorFixture)Proxy.newProxyInstance(SqlOperatorTest.class.getClassLoader(), new Class[]{SqlOperatorFixture.class}, (InvocationHandler)((Object)new SqlOperatorFixtureInvocationHandler(fixture, functionName)));
    }

    public static class SqlOperatorFixtureInvocationHandler
    extends DelegatingInvocationHandler {
        static final Pattern CAST_PATTERN = Pattern.compile("(?i)\\bCAST\\(");
        static final Pattern NOT_NULL_PATTERN = Pattern.compile(" NOT NULL");
        final SqlOperatorFixture f;
        final String functionName;

        SqlOperatorFixtureInvocationHandler(SqlOperatorFixture f, String functionName) {
            this.f = f;
            this.functionName = functionName;
        }

        protected Object getTarget() {
            return this.f;
        }

        String addSafe(String sql) {
            return CAST_PATTERN.matcher(sql).replaceAll(this.functionName + "(");
        }

        String removeNotNull(String type) {
            return NOT_NULL_PATTERN.matcher(type).replaceAll("");
        }

        public void checkCastToString(String value, @Nullable String type, @Nullable String expected, SqlOperatorFixture.CastType castType) {
            this.f.checkCastToString(this.addSafe(value), type == null ? null : this.removeNotNull(type), expected, castType);
        }

        public void checkFails(String expression, @Nullable Boolean result) {
            this.f.checkBoolean(this.addSafe(expression), result);
        }

        public void checkNull(String expression) {
            this.f.checkNull(this.addSafe(expression));
        }

        public void checkFails(String expression, String expectedError, boolean runtime) {
            this.f.checkFails(this.addSafe(expression), expectedError, runtime);
        }

        public void checkScalar(String expression, Object result, String resultType) {
            this.f.checkScalar(this.addSafe(expression), result, this.removeNotNull(resultType));
        }

        public void checkScalarExact(String expression, int result) {
            this.f.checkScalarExact(this.addSafe(expression), result);
        }

        public void checkScalarExact(String expression, String expectedType, String result) {
            this.f.checkScalarExact(this.addSafe(expression), this.removeNotNull(expectedType), result);
        }

        public void checkString(String expression, String result, String resultType) {
            this.f.checkString(this.addSafe(expression), result, this.removeNotNull(resultType));
        }
    }
}

