/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.calcite.DataContexts;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RexImplicationChecker;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.junit.jupiter.api.Assertions;

public interface RexImplicationCheckerFixtures {

    public static class Fixture {
        public final RelDataTypeFactory typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        public final RexBuilder rexBuilder = new RexBuilder(this.typeFactory);
        public final RelDataType boolRelDataType = this.typeFactory.createJavaType(Boolean.class);
        public final RelDataType intRelDataType = this.typeFactory.createJavaType(Integer.class);
        public final RelDataType decRelDataType = this.typeFactory.createJavaType(Double.class);
        public final RelDataType longRelDataType = this.typeFactory.createJavaType(Long.class);
        public final RelDataType shortDataType = this.typeFactory.createJavaType(Short.class);
        public final RelDataType byteDataType = this.typeFactory.createJavaType(Byte.class);
        public final RelDataType floatDataType = this.typeFactory.createJavaType(Float.class);
        public final RelDataType charDataType = this.typeFactory.createJavaType(Character.class);
        public final RelDataType dateDataType = this.typeFactory.createJavaType(Date.class);
        public final RelDataType timestampDataType = this.typeFactory.createJavaType(Timestamp.class);
        public final RelDataType timeDataType = this.typeFactory.createJavaType(Time.class);
        public final RelDataType stringDataType = this.typeFactory.createJavaType(String.class);
        public final RexNode bl = this.ref(0, this.boolRelDataType);
        public final RexNode i = this.ref(1, this.intRelDataType);
        public final RexNode dec = this.ref(2, this.decRelDataType);
        public final RexNode lg = this.ref(3, this.longRelDataType);
        public final RexNode sh = this.ref(4, this.shortDataType);
        public final RexNode by = this.ref(5, this.byteDataType);
        public final RexNode fl = this.ref(6, this.floatDataType);
        public final RexNode d;
        public final RexNode ch = this.ref(7, this.charDataType);
        public final RexNode ts;
        public final RexNode t;
        public final RexNode str;
        public final RexImplicationChecker checker;
        public final RelDataType rowType;
        public final RexExecutorImpl executor;
        public final RexSimplify simplify;

        public Fixture() {
            this.d = this.ref(8, this.dateDataType);
            this.ts = this.ref(9, this.timestampDataType);
            this.t = this.ref(10, this.timeDataType);
            this.str = this.ref(11, this.stringDataType);
            this.rowType = this.typeFactory.builder().add("bool", this.boolRelDataType).add("int", this.intRelDataType).add("dec", this.decRelDataType).add("long", this.longRelDataType).add("short", this.shortDataType).add("byte", this.byteDataType).add("float", this.floatDataType).add("char", this.charDataType).add("date", this.dateDataType).add("timestamp", this.timestampDataType).add("time", this.timeDataType).add("string", this.stringDataType).build();
            this.executor = (RexExecutorImpl)Frameworks.withPrepare((cluster, relOptSchema, rootSchema, statement) -> new RexExecutorImpl(DataContexts.of((CalciteConnection)statement.getConnection(), (SchemaPlus)rootSchema)));
            this.simplify = new RexSimplify(this.rexBuilder, RelOptPredicateList.EMPTY, (RexExecutor)this.executor).withParanoid(true);
            this.checker = new RexImplicationChecker(this.rexBuilder, (RexExecutor)this.executor, this.rowType);
        }

        public RexInputRef ref(int i, RelDataType type) {
            return new RexInputRef(i, this.typeFactory.createTypeWithNullability(type, true));
        }

        public RexLiteral literal(int i) {
            return this.rexBuilder.makeExactLiteral(new BigDecimal(i));
        }

        public RexNode gt(RexNode node1, RexNode node2) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{node1, node2});
        }

        public RexNode ge(RexNode node1, RexNode node2) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{node1, node2});
        }

        public RexNode eq(RexNode node1, RexNode node2) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{node1, node2});
        }

        public RexNode ne(RexNode node1, RexNode node2) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new RexNode[]{node1, node2});
        }

        public RexNode lt(RexNode node1, RexNode node2) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{node1, node2});
        }

        public RexNode le(RexNode node1, RexNode node2) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{node1, node2});
        }

        public RexNode notNull(RexNode node1) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{node1});
        }

        public RexNode isNull(RexNode node2) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{node2});
        }

        public RexNode and(RexNode ... nodes) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, nodes);
        }

        public RexNode or(RexNode ... nodes) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, nodes);
        }

        public RexNode longLiteral(long value) {
            return this.rexBuilder.makeLiteral((Object)value, this.longRelDataType, true);
        }

        public RexNode shortLiteral(short value) {
            return this.rexBuilder.makeLiteral((Object)value, this.shortDataType, true);
        }

        public RexLiteral floatLiteral(double value) {
            return this.rexBuilder.makeApproxLiteral(new BigDecimal(value));
        }

        public RexLiteral charLiteral(String z) {
            return this.rexBuilder.makeCharLiteral(new NlsString(z, null, SqlCollation.COERCIBLE));
        }

        public RexNode dateLiteral(DateString d) {
            return this.rexBuilder.makeDateLiteral(d);
        }

        public RexNode timestampLiteral(TimestampString ts) {
            return this.rexBuilder.makeTimestampLiteral(ts, this.timestampDataType.getPrecision());
        }

        public RexNode timestampLocalTzLiteral(TimestampString ts) {
            return this.rexBuilder.makeTimestampWithLocalTimeZoneLiteral(ts, this.timestampDataType.getPrecision());
        }

        public RexNode timeLiteral(TimeString t) {
            return this.rexBuilder.makeTimeLiteral(t, this.timeDataType.getPrecision());
        }

        public RexNode cast(RelDataType type, RexNode exp) {
            return this.rexBuilder.makeCast(type, exp, true, false);
        }

        void checkImplies(RexNode node1, RexNode node2) {
            Assertions.assertTrue((boolean)this.checker.implies(node1, node2), () -> node1 + " does not imply " + node2 + " when it should");
        }

        void checkNotImplies(RexNode node1, RexNode node2) {
            Assertions.assertFalse((boolean)this.checker.implies(node1, node2), () -> node1 + " does implies " + node2 + " when it should not");
        }
    }
}

