/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.test.DiffRepository;
import org.apache.calcite.test.Matchers;
import org.apache.calcite.test.RelSupplier;
import org.apache.calcite.test.SqlToRelFixture;
import org.apache.calcite.test.SqlToRelTestBase;
import org.apache.calcite.test.catalog.MockCatalogReaderDynamic;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Closer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;

public class RelOptFixture {
    static final RelOptFixture DEFAULT = new RelOptFixture(SqlToRelFixture.TESTER, SqlTestFactory.INSTANCE, null, RelSupplier.NONE, null, null, (ImmutableMap<Hook, Consumer<Object>>)ImmutableMap.of(), (f, r) -> r, (f, r) -> r, false, false).withFactory(f -> f.withValidatorConfig(c -> c.withIdentifierExpansion(true)).withSqlToRelConfig(c -> c.withExpand(false))).withRelBuilderConfig(b -> b.withPruneInputOfAggregate(false));
    final SqlTester tester;
    final RelSupplier relSupplier;
    final SqlTestFactory factory;
    final @Nullable DiffRepository diffRepos;
    final @Nullable HepProgram preProgram;
    final RelOptPlanner planner;
    final ImmutableMap<Hook, Consumer<Object>> hooks;
    final BiFunction<RelOptFixture, RelNode, RelNode> before;
    final BiFunction<RelOptFixture, RelNode, RelNode> after;
    final boolean decorrelate;
    final boolean lateDecorrelate;

    RelOptFixture(SqlTester tester, SqlTestFactory factory, @Nullable DiffRepository diffRepos, RelSupplier relSupplier, @Nullable HepProgram preProgram, RelOptPlanner planner, ImmutableMap<Hook, Consumer<Object>> hooks, BiFunction<RelOptFixture, RelNode, RelNode> before, BiFunction<RelOptFixture, RelNode, RelNode> after, boolean decorrelate, boolean lateDecorrelate) {
        this.tester = Objects.requireNonNull(tester, "tester");
        this.factory = factory;
        this.diffRepos = diffRepos;
        this.relSupplier = Objects.requireNonNull(relSupplier, "relSupplier");
        this.before = Objects.requireNonNull(before, "before");
        this.after = Objects.requireNonNull(after, "after");
        this.preProgram = preProgram;
        this.planner = planner;
        this.hooks = Objects.requireNonNull(hooks, "hooks");
        this.decorrelate = decorrelate;
        this.lateDecorrelate = lateDecorrelate;
    }

    public RelOptFixture withDiffRepos(DiffRepository diffRepos) {
        if (diffRepos.equals(this.diffRepos)) {
            return this;
        }
        return new RelOptFixture(this.tester, this.factory, diffRepos, this.relSupplier, this.preProgram, this.planner, this.hooks, this.before, this.after, this.decorrelate, this.lateDecorrelate);
    }

    public RelOptFixture withRelSupplier(RelSupplier relSupplier) {
        if (relSupplier.equals(this.relSupplier)) {
            return this;
        }
        return new RelOptFixture(this.tester, this.factory, this.diffRepos, relSupplier, this.preProgram, this.planner, this.hooks, this.before, this.after, this.decorrelate, this.lateDecorrelate);
    }

    public RelOptFixture sql(String sql) {
        return this.withRelSupplier(RelSupplier.of(sql));
    }

    RelOptFixture relFn(Function<RelBuilder, RelNode> relFn) {
        return this.withRelSupplier(RelSupplier.of(relFn));
    }

    public RelOptFixture withBefore(BiFunction<RelOptFixture, RelNode, RelNode> transform) {
        BiFunction<RelOptFixture, RelNode, RelNode> before0 = this.before;
        BiFunction<RelOptFixture, RelNode, RelNode> before = (sql, r) -> (RelNode)transform.apply(this, (RelNode)before0.apply(this, (RelNode)r));
        return new RelOptFixture(this.tester, this.factory, this.diffRepos, this.relSupplier, this.preProgram, this.planner, this.hooks, before, this.after, this.decorrelate, this.lateDecorrelate);
    }

    public RelOptFixture withAfter(BiFunction<RelOptFixture, RelNode, RelNode> transform) {
        BiFunction<RelOptFixture, RelNode, RelNode> after0 = this.after;
        BiFunction<RelOptFixture, RelNode, RelNode> after = (sql, r) -> (RelNode)transform.apply(this, (RelNode)after0.apply(this, (RelNode)r));
        return new RelOptFixture(this.tester, this.factory, this.diffRepos, this.relSupplier, this.preProgram, this.planner, this.hooks, this.before, after, this.decorrelate, this.lateDecorrelate);
    }

    public RelOptFixture withDynamicTable() {
        return this.withCatalogReaderFactory(MockCatalogReaderDynamic::create);
    }

    public RelOptFixture withFactory(UnaryOperator<SqlTestFactory> transform) {
        SqlTestFactory factory = (SqlTestFactory)transform.apply(this.factory);
        if (factory.equals(this.factory)) {
            return this;
        }
        return new RelOptFixture(this.tester, factory, this.diffRepos, this.relSupplier, this.preProgram, this.planner, this.hooks, this.before, this.after, this.decorrelate, this.lateDecorrelate);
    }

    public RelOptFixture withPre(HepProgram preProgram) {
        if (preProgram.equals(this.preProgram)) {
            return this;
        }
        return new RelOptFixture(this.tester, this.factory, this.diffRepos, this.relSupplier, preProgram, this.planner, this.hooks, this.before, this.after, this.decorrelate, this.lateDecorrelate);
    }

    public RelOptFixture withPreRule(RelOptRule ... rules) {
        HepProgramBuilder builder = HepProgram.builder();
        for (RelOptRule rule : rules) {
            builder.addRuleInstance(rule);
        }
        return this.withPre(builder.build());
    }

    public RelOptFixture withPlanner(RelOptPlanner planner) {
        if (planner.equals(this.planner)) {
            return this;
        }
        return new RelOptFixture(this.tester, this.factory, this.diffRepos, this.relSupplier, this.preProgram, planner, this.hooks, this.before, this.after, this.decorrelate, this.lateDecorrelate);
    }

    public RelOptFixture withProgram(HepProgram program) {
        return this.withPlanner((RelOptPlanner)new HepPlanner(program));
    }

    public RelOptFixture withRule(RelOptRule ... rules) {
        HepProgramBuilder builder = HepProgram.builder();
        for (RelOptRule rule : rules) {
            builder.addRuleInstance(rule);
        }
        return this.withProgram(builder.build());
    }

    public <T> RelOptFixture withHook(Hook hook, Consumer<T> handler) {
        ImmutableMap hooks = FlatLists.append(this.hooks, (Object)hook, handler);
        if (hooks.equals(this.hooks)) {
            return this;
        }
        return new RelOptFixture(this.tester, this.factory, this.diffRepos, this.relSupplier, this.preProgram, this.planner, (ImmutableMap<Hook, Consumer<Object>>)hooks, this.before, this.after, this.decorrelate, this.lateDecorrelate);
    }

    public <V> RelOptFixture withProperty(Hook hook, V value) {
        return this.withHook(hook, Hook.propertyJ(value));
    }

    public RelOptFixture withRelBuilderSimplify(boolean simplify) {
        return this.withProperty(Hook.REL_BUILDER_SIMPLIFY, simplify);
    }

    public RelOptFixture withExpand(boolean expand) {
        return this.withConfig(c -> c.withExpand(expand));
    }

    public RelOptFixture withInSubQueryThreshold(int inSubQueryThreshold) {
        return this.withConfig(c -> c.withInSubQueryThreshold(inSubQueryThreshold));
    }

    public RelOptFixture withConfig(UnaryOperator<SqlToRelConverter.Config> transform) {
        return this.withFactory(f -> f.withSqlToRelConfig(transform));
    }

    public RelOptFixture withRelBuilderConfig(UnaryOperator<RelBuilder.Config> transform) {
        return this.withConfig(c -> c.addRelBuilderConfigTransform(transform));
    }

    public RelOptFixture withLateDecorrelate(boolean lateDecorrelate) {
        if (lateDecorrelate == this.lateDecorrelate) {
            return this;
        }
        return new RelOptFixture(this.tester, this.factory, this.diffRepos, this.relSupplier, this.preProgram, this.planner, this.hooks, this.before, this.after, this.decorrelate, lateDecorrelate);
    }

    public RelOptFixture withDecorrelate(boolean decorrelate) {
        if (decorrelate == this.decorrelate) {
            return this;
        }
        return new RelOptFixture(this.tester, this.factory, this.diffRepos, this.relSupplier, this.preProgram, this.planner, this.hooks, this.before, this.after, decorrelate, this.lateDecorrelate);
    }

    public RelOptFixture withTrim(boolean trim) {
        return this.withConfig(c -> c.withTrimUnusedFields(trim));
    }

    public RelOptFixture withCatalogReaderFactory(SqlTestFactory.CatalogReaderFactory factory) {
        return this.withFactory(f -> f.withCatalogReader(factory));
    }

    public RelOptFixture withConformance(SqlConformance conformance) {
        return this.withFactory(f -> f.withValidatorConfig(c -> c.withConformance(conformance)).withOperatorTable(t -> conformance.allowGeometry() ? SqlOperatorTables.chain((SqlOperatorTable[])new SqlOperatorTable[]{t, SqlOperatorTables.spatialInstance()}) : t));
    }

    public RelOptFixture withContext(UnaryOperator<Context> transform) {
        return this.withFactory(f -> f.withPlannerContext(transform));
    }

    public RelNode toRel() {
        return this.relSupplier.apply(this);
    }

    public void check() {
        this.check(false);
    }

    public void checkUnchanged() {
        this.check(true);
    }

    private void check(boolean unchanged) {
        try (Closer closer = new Closer();){
            for (Map.Entry entry : this.hooks.entrySet()) {
                closer.add((AutoCloseable)((Hook)entry.getKey()).addThread((Consumer)entry.getValue()));
            }
            this.checkPlanning(unchanged);
        }
    }

    private void checkPlanning(boolean unchanged) {
        RelNode r4;
        RelNode r1;
        RelNode relInitial = this.toRel();
        Assertions.assertNotNull((Object)relInitial);
        ArrayList<DefaultRelMetadataProvider> list = new ArrayList<DefaultRelMetadataProvider>();
        list.add(DefaultRelMetadataProvider.INSTANCE);
        RelMetadataProvider plannerChain = ChainedRelMetadataProvider.of(list);
        RelOptCluster cluster = relInitial.getCluster();
        cluster.setMetadataProvider(plannerChain);
        if (this.preProgram == null) {
            r1 = relInitial;
        } else {
            HepPlanner prePlanner = new HepPlanner(this.preProgram);
            prePlanner.setRoot(relInitial);
            r1 = prePlanner.findBestExp();
        }
        RelNode relBefore = this.before.apply(this, r1);
        MatcherAssert.assertThat((Object)relBefore, (Matcher)CoreMatchers.notNullValue());
        String planBefore = SqlToRelTestBase.NL + RelOptFixture.relToString(relBefore);
        DiffRepository diffRepos = this.diffRepos();
        diffRepos.assertEquals("planBefore", "${planBefore}", planBefore);
        MatcherAssert.assertThat((Object)relBefore, Matchers.relIsValid());
        RelNode r2 = this.planner instanceof VolcanoPlanner ? this.planner.changeTraits(relBefore, relBefore.getTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE)) : relBefore;
        this.planner.setRoot(r2);
        RelNode r3 = this.planner.findBestExp();
        if (this.lateDecorrelate) {
            String planMid = SqlToRelTestBase.NL + RelOptFixture.relToString(r3);
            diffRepos.assertEquals("planMid", "${planMid}", planMid);
            MatcherAssert.assertThat((Object)r3, Matchers.relIsValid());
            RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(cluster, null);
            r4 = RelDecorrelator.decorrelateQuery((RelNode)r3, (RelBuilder)relBuilder);
        } else {
            r4 = r3;
        }
        RelNode relAfter = this.after.apply(this, r4);
        String planAfter = SqlToRelTestBase.NL + RelOptFixture.relToString(relAfter);
        if (unchanged) {
            String expandedPlanAfter = diffRepos.expand("planAfter", "${planAfter}");
            if (!"${planAfter}".equals(expandedPlanAfter)) {
                throw new AssertionError((Object)"Expected planAfter must not be present when using unchanged=true or calling checkUnchanged.");
            }
            MatcherAssert.assertThat((Object)planAfter, (Matcher)CoreMatchers.is((Object)planBefore));
        } else {
            diffRepos.assertEquals("planAfter", "${planAfter}", planAfter);
            if (planBefore.equals(planAfter)) {
                throw new AssertionError((Object)"Expected plan before and after is the same.\nYou must use unchanged=true or call checkUnchanged");
            }
        }
        MatcherAssert.assertThat((Object)relAfter, Matchers.relIsValid());
    }

    private static String relToString(RelNode r) {
        String s = RelOptUtil.toString((RelNode)r);
        return s.replace("-0.9238795325112868", "-0.9238795325112867").replace("4.456722804932279", "4.45672280493228").replace("0.3826834323650896", "0.3826834323650897");
    }

    public RelOptFixture withVolcanoPlanner(boolean topDown) {
        return this.withVolcanoPlanner(topDown, p -> RelOptUtil.registerDefaultRules((RelOptPlanner)p, (boolean)false, (boolean)false));
    }

    public RelOptFixture withVolcanoPlanner(boolean topDown, Consumer<VolcanoPlanner> init) {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.setTopDownOpt(topDown);
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        init.accept(planner);
        return this.withPlanner((RelOptPlanner)planner).withDecorrelate(true).withFactory(f -> f.withCluster(cluster -> RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)cluster.getRexBuilder())));
    }

    public RelOptFixture withSubQueryRules() {
        return this.withExpand(false).withRule(new RelOptRule[]{CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE, CoreRules.FILTER_SUB_QUERY_TO_CORRELATE, CoreRules.JOIN_SUB_QUERY_TO_CORRELATE});
    }

    public DiffRepository diffRepos() {
        return DiffRepository.castNonNull(this.diffRepos);
    }
}

