/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.StringAndPos;
import org.apache.calcite.sql.test.AbstractSqlTester;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTests;
import org.apache.calcite.sql.validate.SqlValidator;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.jupiter.api.Assertions;

class SqlRuntimeTester
extends AbstractSqlTester {
    SqlRuntimeTester() {
    }

    @Override
    public void checkFails(SqlTestFactory factory, StringAndPos sap, String expectedError, boolean runtime) {
        StringAndPos sap2 = StringAndPos.of((String)SqlRuntimeTester.buildQuery(sap.addCarets()));
        this.assertExceptionIsThrown(factory, sap2, expectedError, runtime);
    }

    @Override
    public void checkAggFails(SqlTestFactory factory, String expr, String[] inputValues, String expectedError, boolean runtime) {
        String query = SqlTests.generateAggQuery(expr, inputValues);
        StringAndPos sap = StringAndPos.of((String)query);
        this.assertExceptionIsThrown(factory, sap, expectedError, runtime);
    }

    @Override
    public void assertExceptionIsThrown(SqlTestFactory factory, StringAndPos sap, @Nullable String expectedMsgPattern) {
        this.assertExceptionIsThrown(factory, sap, expectedMsgPattern, false);
    }

    public void assertExceptionIsThrown(SqlTestFactory factory, StringAndPos sap, @Nullable String expectedMsgPattern, boolean runtime) {
        SqlTests.Stage stage;
        SqlNode sqlNode;
        try {
            sqlNode = this.parseQuery(factory, sap.sql);
        }
        catch (Throwable e) {
            this.checkParseEx(e, expectedMsgPattern, sap);
            return;
        }
        Throwable thrown = null;
        SqlValidator validator = factory.createValidator();
        if (runtime) {
            stage = SqlTests.Stage.RUNTIME;
            SqlNode validated = validator.validate(sqlNode);
            Assertions.assertNotNull((Object)validated);
            try {
                this.check(factory, sap.sql, SqlTests.ANY_TYPE_CHECKER, SqlTests.ANY_PARAMETER_CHECKER, SqlTests.ANY_RESULT_CHECKER);
            }
            catch (Throwable ex) {
                thrown = ex;
            }
        } else {
            stage = SqlTests.Stage.VALIDATE;
            try {
                validator.validate(sqlNode);
            }
            catch (Throwable ex) {
                thrown = ex;
            }
        }
        SqlTests.checkEx(thrown, expectedMsgPattern, sap, stage);
    }
}

