/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.test;

import com.google.common.base.Suppliers;
import java.io.Reader;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.DelegatingTypeSystem;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.advise.SqlAdvisor;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql.validate.SqlValidatorWithHints;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.ConnectionFactories;
import org.apache.calcite.test.ConnectionFactory;
import org.apache.calcite.test.MockRelOptPlanner;
import org.apache.calcite.test.MockSqlOperatorTable;
import org.apache.calcite.test.catalog.MockCatalogReaderSimple;
import org.apache.calcite.util.SourceStringReader;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlTestFactory {
    public static final SqlTestFactory INSTANCE = new SqlTestFactory(MockCatalogReaderSimple::create, SqlTestFactory::createTypeFactory, MockRelOptPlanner::new, Contexts.of((Object[])new Object[0]), UnaryOperator.identity(), SqlValidatorUtil::newValidator, ConnectionFactories.empty().with(ConnectionFactories.add(CalciteAssert.SchemaSpec.HR)), SqlParser.Config.DEFAULT, SqlValidator.Config.DEFAULT, SqlToRelConverter.CONFIG, (SqlOperatorTable)SqlStdOperatorTable.instance(), UnaryOperator.identity()).withOperatorTable(o -> MockSqlOperatorTable.of(o).extend());
    public final ConnectionFactory connectionFactory;
    public final TypeFactoryFactory typeFactoryFactory;
    private final CatalogReaderFactory catalogReaderFactory;
    private final PlannerFactory plannerFactory;
    private final Context plannerContext;
    private final UnaryOperator<RelOptCluster> clusterTransform;
    private final ValidatorFactory validatorFactory;
    private final Supplier<RelDataTypeFactory> typeFactorySupplier;
    private final SqlOperatorTable operatorTable;
    private final Supplier<SqlValidatorCatalogReader> catalogReaderSupplier;
    private final SqlParser.Config parserConfig;
    public final SqlValidator.Config validatorConfig;
    public final SqlToRelConverter.Config sqlToRelConfig;
    public final UnaryOperator<RelDataTypeSystem> typeSystemTransform;

    protected SqlTestFactory(CatalogReaderFactory catalogReaderFactory, TypeFactoryFactory typeFactoryFactory, PlannerFactory plannerFactory, Context plannerContext, UnaryOperator<RelOptCluster> clusterTransform, ValidatorFactory validatorFactory, ConnectionFactory connectionFactory, SqlParser.Config parserConfig, SqlValidator.Config validatorConfig, SqlToRelConverter.Config sqlToRelConfig, SqlOperatorTable operatorTable, UnaryOperator<RelDataTypeSystem> typeSystemTransform) {
        this.catalogReaderFactory = Objects.requireNonNull(catalogReaderFactory, "catalogReaderFactory");
        this.typeFactoryFactory = Objects.requireNonNull(typeFactoryFactory, "typeFactoryFactory");
        this.plannerFactory = Objects.requireNonNull(plannerFactory, "plannerFactory");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext");
        this.clusterTransform = Objects.requireNonNull(clusterTransform, "clusterTransform");
        this.validatorFactory = Objects.requireNonNull(validatorFactory, "validatorFactory");
        this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory");
        this.sqlToRelConfig = Objects.requireNonNull(sqlToRelConfig, "sqlToRelConfig");
        this.operatorTable = operatorTable;
        this.typeSystemTransform = typeSystemTransform;
        this.typeFactorySupplier = Suppliers.memoize(() -> typeFactoryFactory.create(validatorConfig.conformance(), (RelDataTypeSystem)typeSystemTransform.apply(RelDataTypeSystem.DEFAULT)));
        this.catalogReaderSupplier = Suppliers.memoize(() -> catalogReaderFactory.create(this.typeFactorySupplier.get(), parserConfig.caseSensitive()));
        this.parserConfig = parserConfig;
        this.validatorConfig = validatorConfig;
    }

    public SqlParser createParser(String sql) {
        SqlParser.Config parserConfig = this.parserConfig();
        return SqlParser.create((Reader)new SourceStringReader(sql), (SqlParser.Config)parserConfig);
    }

    public SqlValidator createValidator() {
        return this.validatorFactory.create(this.operatorTable, this.catalogReaderSupplier.get(), this.typeFactorySupplier.get(), this.validatorConfig);
    }

    public SqlAdvisor createAdvisor() {
        SqlValidator validator = this.createValidator();
        if (validator instanceof SqlValidatorWithHints) {
            return new SqlAdvisor((SqlValidatorWithHints)validator, this.parserConfig);
        }
        throw new UnsupportedOperationException("Validator should implement SqlValidatorWithHints, actual validator is " + validator);
    }

    public SqlTestFactory withTypeFactoryFactory(TypeFactoryFactory typeFactoryFactory) {
        if (typeFactoryFactory.equals(this.typeFactoryFactory)) {
            return this;
        }
        return new SqlTestFactory(this.catalogReaderFactory, typeFactoryFactory, this.plannerFactory, this.plannerContext, this.clusterTransform, this.validatorFactory, this.connectionFactory, this.parserConfig, this.validatorConfig, this.sqlToRelConfig, this.operatorTable, this.typeSystemTransform);
    }

    public SqlTestFactory withTypeSystem(UnaryOperator<RelDataTypeSystem> typeSystemTransform) {
        if (typeSystemTransform.equals(this.typeSystemTransform)) {
            return this;
        }
        return new SqlTestFactory(this.catalogReaderFactory, this.typeFactoryFactory, this.plannerFactory, this.plannerContext, this.clusterTransform, this.validatorFactory, this.connectionFactory, this.parserConfig, this.validatorConfig, this.sqlToRelConfig, this.operatorTable, typeSystemTransform);
    }

    public SqlTestFactory withPlannerFactory(PlannerFactory plannerFactory) {
        if (plannerFactory.equals(this.plannerFactory)) {
            return this;
        }
        return new SqlTestFactory(this.catalogReaderFactory, this.typeFactoryFactory, plannerFactory, this.plannerContext, this.clusterTransform, this.validatorFactory, this.connectionFactory, this.parserConfig, this.validatorConfig, this.sqlToRelConfig, this.operatorTable, this.typeSystemTransform);
    }

    public SqlTestFactory withPlannerContext(UnaryOperator<Context> transform) {
        Context plannerContext = (Context)transform.apply(this.plannerContext);
        if (plannerContext.equals(this.plannerContext)) {
            return this;
        }
        return new SqlTestFactory(this.catalogReaderFactory, this.typeFactoryFactory, this.plannerFactory, plannerContext, this.clusterTransform, this.validatorFactory, this.connectionFactory, this.parserConfig, this.validatorConfig, this.sqlToRelConfig, this.operatorTable, this.typeSystemTransform);
    }

    public SqlTestFactory withCluster(UnaryOperator<RelOptCluster> transform) {
        UnaryOperator clusterTransform = this.clusterTransform.andThen(transform)::apply;
        return new SqlTestFactory(this.catalogReaderFactory, this.typeFactoryFactory, this.plannerFactory, this.plannerContext, clusterTransform, this.validatorFactory, this.connectionFactory, this.parserConfig, this.validatorConfig, this.sqlToRelConfig, this.operatorTable, this.typeSystemTransform);
    }

    public SqlTestFactory withCatalogReader(CatalogReaderFactory catalogReaderFactory) {
        if (catalogReaderFactory.equals(this.catalogReaderFactory)) {
            return this;
        }
        return new SqlTestFactory(catalogReaderFactory, this.typeFactoryFactory, this.plannerFactory, this.plannerContext, this.clusterTransform, this.validatorFactory, this.connectionFactory, this.parserConfig, this.validatorConfig, this.sqlToRelConfig, this.operatorTable, this.typeSystemTransform);
    }

    public SqlTestFactory withValidator(ValidatorFactory validatorFactory) {
        if (validatorFactory.equals(this.validatorFactory)) {
            return this;
        }
        return new SqlTestFactory(this.catalogReaderFactory, this.typeFactoryFactory, this.plannerFactory, this.plannerContext, this.clusterTransform, validatorFactory, this.connectionFactory, this.parserConfig, this.validatorConfig, this.sqlToRelConfig, this.operatorTable, this.typeSystemTransform);
    }

    public SqlTestFactory withValidatorConfig(UnaryOperator<SqlValidator.Config> transform) {
        SqlValidator.Config validatorConfig = (SqlValidator.Config)transform.apply(this.validatorConfig);
        if (validatorConfig.equals(this.validatorConfig)) {
            return this;
        }
        return new SqlTestFactory(this.catalogReaderFactory, this.typeFactoryFactory, this.plannerFactory, this.plannerContext, this.clusterTransform, this.validatorFactory, this.connectionFactory, this.parserConfig, validatorConfig, this.sqlToRelConfig, this.operatorTable, this.typeSystemTransform);
    }

    public SqlTestFactory withSqlToRelConfig(UnaryOperator<SqlToRelConverter.Config> transform) {
        SqlToRelConverter.Config sqlToRelConfig = (SqlToRelConverter.Config)transform.apply(this.sqlToRelConfig);
        if (sqlToRelConfig.equals(this.sqlToRelConfig)) {
            return this;
        }
        return new SqlTestFactory(this.catalogReaderFactory, this.typeFactoryFactory, this.plannerFactory, this.plannerContext, this.clusterTransform, this.validatorFactory, this.connectionFactory, this.parserConfig, this.validatorConfig, sqlToRelConfig, this.operatorTable, this.typeSystemTransform);
    }

    private static RelDataTypeFactory createTypeFactory(SqlConformance conformance, RelDataTypeSystem typeSystem) {
        if (conformance.shouldConvertRaggedUnionTypesToVarying()) {
            typeSystem = new DelegatingTypeSystem((RelDataTypeSystem)typeSystem){

                public boolean shouldConvertRaggedUnionTypesToVarying() {
                    return true;
                }
            };
        }
        return new JavaTypeFactoryImpl(typeSystem);
    }

    public SqlTestFactory withParserConfig(UnaryOperator<SqlParser.Config> transform) {
        SqlParser.Config parserConfig = (SqlParser.Config)transform.apply(this.parserConfig);
        if (parserConfig.equals(this.parserConfig)) {
            return this;
        }
        return new SqlTestFactory(this.catalogReaderFactory, this.typeFactoryFactory, this.plannerFactory, this.plannerContext, this.clusterTransform, this.validatorFactory, this.connectionFactory, parserConfig, this.validatorConfig, this.sqlToRelConfig, this.operatorTable, this.typeSystemTransform);
    }

    public SqlTestFactory withConnectionFactory(UnaryOperator<ConnectionFactory> transform) {
        ConnectionFactory connectionFactory = (ConnectionFactory)transform.apply(this.connectionFactory);
        if (connectionFactory.equals(this.connectionFactory)) {
            return this;
        }
        return new SqlTestFactory(this.catalogReaderFactory, this.typeFactoryFactory, this.plannerFactory, this.plannerContext, this.clusterTransform, this.validatorFactory, connectionFactory, this.parserConfig, this.validatorConfig, this.sqlToRelConfig, this.operatorTable, this.typeSystemTransform);
    }

    public SqlTestFactory withOperatorTable(UnaryOperator<SqlOperatorTable> transform) {
        SqlOperatorTable operatorTable = (SqlOperatorTable)transform.apply(this.operatorTable);
        if (operatorTable.equals(this.operatorTable)) {
            return this;
        }
        return new SqlTestFactory(this.catalogReaderFactory, this.typeFactoryFactory, this.plannerFactory, this.plannerContext, this.clusterTransform, this.validatorFactory, this.connectionFactory, this.parserConfig, this.validatorConfig, this.sqlToRelConfig, operatorTable, this.typeSystemTransform);
    }

    public SqlParser.Config parserConfig() {
        return this.parserConfig;
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactorySupplier.get();
    }

    public SqlToRelConverter createSqlToRelConverter() {
        RelDataTypeFactory typeFactory = this.getTypeFactory();
        Prepare.CatalogReader catalogReader = (Prepare.CatalogReader)this.catalogReaderSupplier.get();
        SqlValidator validator = this.createValidator();
        RexBuilder rexBuilder = new RexBuilder(typeFactory);
        RelOptPlanner planner = this.plannerFactory.create(this.plannerContext);
        RelOptCluster cluster = (RelOptCluster)this.clusterTransform.apply(RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)rexBuilder));
        MockViewExpander viewExpander = new MockViewExpander(validator, catalogReader, cluster, this.sqlToRelConfig);
        return new SqlToRelConverter((RelOptTable.ViewExpander)viewExpander, validator, catalogReader, cluster, (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, this.sqlToRelConfig);
    }

    private static class MockViewExpander
    implements RelOptTable.ViewExpander {
        private final SqlValidator validator;
        private final Prepare.CatalogReader catalogReader;
        private final RelOptCluster cluster;
        private final SqlToRelConverter.Config config;

        MockViewExpander(SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster cluster, SqlToRelConverter.Config config) {
            this.validator = validator;
            this.catalogReader = catalogReader;
            this.cluster = cluster;
            this.config = config;
        }

        public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, @Nullable List<String> viewPath) {
            try {
                SqlNode parsedNode = SqlParser.create((String)queryString).parseStmt();
                SqlNode validatedNode = this.validator.validate(parsedNode);
                SqlToRelConverter converter = new SqlToRelConverter((RelOptTable.ViewExpander)this, this.validator, this.catalogReader, this.cluster, (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, this.config);
                return converter.convertQuery(validatedNode, false, true);
            }
            catch (SqlParseException e) {
                throw new RuntimeException("Error happened while expanding view.", e);
            }
        }
    }

    @FunctionalInterface
    public static interface CatalogReaderFactory {
        public SqlValidatorCatalogReader create(RelDataTypeFactory var1, boolean var2);
    }

    public static interface ValidatorFactory {
        public SqlValidator create(SqlOperatorTable var1, SqlValidatorCatalogReader var2, RelDataTypeFactory var3, SqlValidator.Config var4);
    }

    public static interface PlannerFactory {
        public RelOptPlanner create(Context var1);
    }

    public static interface TypeFactoryFactory {
        public RelDataTypeFactory create(SqlConformance var1, RelDataTypeSystem var2);
    }
}

