/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.splunk.util;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtils {
    private StringUtils() {
    }

    public static StringBuilder encodeList(List<? extends CharSequence> list, char delim) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (CharSequence charSequence : list) {
            if (!first) {
                result.append(delim);
            }
            int len = charSequence.length();
            for (int i = 0; i < len; ++i) {
                char c = charSequence.charAt(i);
                if (c == delim) {
                    result.append('\\');
                }
                result.append(c);
            }
            first = false;
        }
        return result;
    }

    public static List<String> decodeList(CharSequence encoded, char delim) {
        ArrayList<String> list = new ArrayList<String>();
        int len = encoded.length();
        int start = 0;
        int end = 0;
        boolean hasEscapedDelim = false;
        char p = '\u0000';
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            p = c;
            c = encoded.charAt(i);
            if (c == delim) {
                if (p == '\\') {
                    hasEscapedDelim = true;
                } else {
                    if (!hasEscapedDelim) {
                        list.add(encoded.subSequence(start, end).toString());
                    } else {
                        StringBuilder sb = new StringBuilder(end - start);
                        char a = '\u0000';
                        char b = '\u0000';
                        for (int j = start; j < end; ++j) {
                            b = a;
                            a = encoded.charAt(j);
                            if (b == '\\' && a != delim) {
                                sb.append(b);
                            }
                            if (a == '\\') continue;
                            sb.append(a);
                        }
                        list.add(sb.toString());
                    }
                    start = end + 1;
                    hasEscapedDelim = false;
                }
            }
            ++i;
            ++end;
        }
        if (!hasEscapedDelim) {
            list.add(encoded.subSequence(start, end).toString());
        } else {
            StringBuilder sb = new StringBuilder(end - start);
            char a = '\u0000';
            char b = '\u0000';
            for (int j = start; j < end; ++j) {
                b = a;
                a = encoded.charAt(j);
                if (b == '\\' && a != delim) {
                    sb.append(b);
                }
                if (a == '\\') continue;
                sb.append(a);
            }
            list.add(sb.toString());
        }
        return list;
    }

    public static boolean parseBoolean(String str, boolean defaultVal, boolean missingVal) {
        if (str == null || str.isEmpty()) {
            return missingVal;
        }
        if (str.equalsIgnoreCase("t") || str.equalsIgnoreCase("true") || str.equalsIgnoreCase("yes") || str.equals("1")) {
            return true;
        }
        if (str.equalsIgnoreCase("f") || str.equalsIgnoreCase("false") || str.equalsIgnoreCase("no") || str.equals("0")) {
            return false;
        }
        return defaultVal;
    }

    public static void main(String[] args) {
        List<Object> list = new ArrayList<String>();
        list.add("test");
        list.add("test,with,comma");
        list.add("");
        list.add(",");
        System.out.println("=============");
        StringBuilder sb = StringUtils.encodeList(list, ',');
        System.out.println(sb);
        list.clear();
        list = StringUtils.decodeList(sb, ',');
        for (String string : list) {
            System.out.println(string);
        }
        System.out.println("=============");
    }

    public static Logger getClassTracer(Class clazz) {
        return LoggerFactory.getLogger((Class)clazz);
    }
}

