/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.redis;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.redis.RedisSchema;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;

public class RedisSchemaFactory
implements SchemaFactory {
    public Schema create(SchemaPlus schema, String name, Map<String, Object> operand) {
        Preconditions.checkArgument((operand.get("tables") != null ? 1 : 0) != 0, (Object)"tables must be specified");
        Preconditions.checkArgument((operand.get("host") != null ? 1 : 0) != 0, (Object)"host must be specified");
        Preconditions.checkArgument((operand.get("port") != null ? 1 : 0) != 0, (Object)"port must be specified");
        Preconditions.checkArgument((operand.get("database") != null ? 1 : 0) != 0, (Object)"database must be specified");
        List tables = (List)operand.get("tables");
        String host = operand.get("host").toString();
        int port = (Integer)operand.get("port");
        int database = Integer.parseInt(operand.get("database").toString());
        String password = operand.get("password") == null ? null : operand.get("password").toString();
        return new RedisSchema(host, port, database, password, tables);
    }
}

