/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.redis;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.redis.RedisConfig;
import org.apache.calcite.adapter.redis.RedisTable;
import org.apache.calcite.adapter.redis.RedisTableFieldInfo;
import org.apache.calcite.model.JsonCustomTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.commons.lang3.StringUtils;

class RedisSchema
extends AbstractSchema {
    public final String host;
    public final int port;
    public final int database;
    public final String password;
    public final List<Map<String, Object>> tables;

    RedisSchema(String host, int port, int database, String password, List<Map<String, Object>> tables) {
        this.host = host;
        this.port = port;
        this.database = database;
        this.password = password;
        this.tables = tables;
    }

    protected Map<String, Table> getTableMap() {
        JsonCustomTable[] jsonCustomTables = new JsonCustomTable[this.tables.size()];
        Set tableNames = Arrays.stream(this.tables.toArray(jsonCustomTables)).map(e -> e.name).collect(Collectors.toSet());
        return Maps.asMap((Set)ImmutableSet.copyOf(tableNames), (Function)CacheBuilder.newBuilder().build(CacheLoader.from(this::table)));
    }

    private Table table(String tableName) {
        RedisConfig redisConfig = new RedisConfig(this.host, this.port, this.database, this.password);
        return RedisTable.create(this, tableName, redisConfig, null);
    }

    public RedisTableFieldInfo getTableFieldInfo(String tableName) {
        RedisTableFieldInfo tableFieldInfo = new RedisTableFieldInfo();
        List<LinkedHashMap<String, Object>> fields = new ArrayList<LinkedHashMap<String, Object>>();
        String dataFormat = "";
        String keyDelimiter = "";
        List<Map<String, Object>> jsonCustomTables = this.tables;
        for (JsonCustomTable jsonCustomTable : jsonCustomTables) {
            if (!jsonCustomTable.name.equals(tableName)) continue;
            Map map = Objects.requireNonNull(jsonCustomTable.operand, "operand");
            if (map.get("dataFormat") == null) {
                throw new RuntimeException("dataFormat is null");
            }
            if (map.get("fields") == null) {
                throw new RuntimeException("fields is null");
            }
            dataFormat = map.get("dataFormat").toString();
            fields = (List)map.get("fields");
            if (map.get("keyDelimiter") == null) break;
            keyDelimiter = map.get("keyDelimiter").toString();
            break;
        }
        tableFieldInfo.setTableName(tableName);
        tableFieldInfo.setDataFormat(dataFormat);
        tableFieldInfo.setFields(fields);
        if (StringUtils.isNotEmpty((CharSequence)keyDelimiter)) {
            tableFieldInfo.setKeyDelimiter(keyDelimiter);
        }
        return tableFieldInfo;
    }
}

