/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.os;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.os.AbstractBaseScannableTable;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StdinTableFunction {
    private StdinTableFunction() {
    }

    public static ScannableTable eval(boolean b) {
        return new AbstractBaseScannableTable(){

            public Enumerable<@Nullable Object[]> scan(DataContext root) {
                final InputStream is = (InputStream)DataContext.Variable.STDIN.get(root);
                return new AbstractEnumerable<Object[]>(){
                    final InputStreamReader in;
                    final BufferedReader br;
                    {
                        this.in = new InputStreamReader(is, StandardCharsets.UTF_8);
                        this.br = new BufferedReader(this.in);
                    }

                    public Enumerator<Object[]> enumerator() {
                        return new Enumerator<Object[]>(){
                            @Nullable String line;
                            int i;

                            public Object[] current() {
                                if (this.line == null) {
                                    throw new NoSuchElementException();
                                }
                                return new Object[]{this.i, this.line};
                            }

                            public boolean moveNext() {
                                try {
                                    this.line = br.readLine();
                                    ++this.i;
                                    return this.line != null;
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            }

                            public void reset() {
                                throw new UnsupportedOperationException();
                            }

                            public void close() {
                                try {
                                    br.close();
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        };
                    }
                };
            }

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add("ordinal", SqlTypeName.INTEGER).add("line", SqlTypeName.VARCHAR).build();
            }
        };
    }
}

