/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.os;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.os.AbstractBaseScannableTable;
import org.apache.calcite.adapter.os.Processes;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PsTableFunction {
    private static final Pattern MINUTE_SECOND_MILLIS_PATTERN = Pattern.compile("([0-9]+):([0-9]+):([0-9]+)");
    private static final Pattern HOUR_MINUTE_SECOND_PATTERN = Pattern.compile("([0-9]+):([0-9]+)\\.([0-9]+)");
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("(\\d+)");
    private static final ImmutableMap<String, String> UNIX_TO_MAC_PS_FIELDS = ImmutableMap.builder().put((Object)"pgrp", (Object)"pgid").put((Object)"start_time", (Object)"lstart").put((Object)"euid", (Object)"uid").build();
    private static final List<String> PS_FIELD_NAMES = ImmutableList.of((Object)"user", (Object)"pid", (Object)"ppid", (Object)"pgrp", (Object)"tpgid", (Object)"stat", (Object)"pcpu", (Object)"pmem", (Object)"vsz", (Object)"rss", (Object)"tty", (Object)"start_time", (Object[])new String[]{"time", "euid", "ruid", "sess", "comm"});

    private PsTableFunction() {
        throw new AssertionError((Object)"Utility class should not be instantiated");
    }

    public static ScannableTable eval(boolean b) {
        return new AbstractBaseScannableTable(){

            public Enumerable<@Nullable Object[]> scan(DataContext root) {
                String[] args;
                RelDataType rowType = this.getRowType((RelDataTypeFactory)root.getTypeFactory());
                ImmutableList fieldNames = ImmutableList.copyOf((Collection)rowType.getFieldNames());
                String osName = System.getProperty("os.name");
                String osVersion = System.getProperty("os.version");
                Util.discard((Object)osVersion);
                switch (osName) {
                    case "Mac OS X": {
                        args = new String[]{"ps", "ax", "-o", fieldNames.stream().map(s -> (String)UNIX_TO_MAC_PS_FIELDS.getOrDefault(s, s) + "=").collect(Collectors.joining(","))};
                        break;
                    }
                    default: {
                        args = new String[]{"ps", "--no-headers", "axo", String.join((CharSequence)",", (Iterable<? extends CharSequence>)fieldNames)};
                    }
                }
                return Processes.processLines(args).select((Function1)new LineParser());
            }

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add((String)PS_FIELD_NAMES.get(0), SqlTypeName.VARCHAR).add((String)PS_FIELD_NAMES.get(1), SqlTypeName.INTEGER).add((String)PS_FIELD_NAMES.get(2), SqlTypeName.INTEGER).add((String)PS_FIELD_NAMES.get(3), SqlTypeName.INTEGER).add((String)PS_FIELD_NAMES.get(4), SqlTypeName.INTEGER).add((String)PS_FIELD_NAMES.get(5), SqlTypeName.VARCHAR).add((String)PS_FIELD_NAMES.get(6), SqlTypeName.DECIMAL, 3, 1).add((String)PS_FIELD_NAMES.get(7), SqlTypeName.DECIMAL, 3, 1).add((String)PS_FIELD_NAMES.get(8), SqlTypeName.INTEGER).add((String)PS_FIELD_NAMES.get(9), SqlTypeName.INTEGER).add((String)PS_FIELD_NAMES.get(10), SqlTypeName.VARCHAR).add((String)PS_FIELD_NAMES.get(11), SqlTypeName.VARCHAR).add((String)PS_FIELD_NAMES.get(12), TimeUnit.HOUR, -1, TimeUnit.SECOND, 0).add((String)PS_FIELD_NAMES.get(13), SqlTypeName.VARCHAR).add((String)PS_FIELD_NAMES.get(14), SqlTypeName.VARCHAR).add((String)PS_FIELD_NAMES.get(15), SqlTypeName.VARCHAR).add((String)PS_FIELD_NAMES.get(16), SqlTypeName.VARCHAR).build();
            }
        };
    }

    @VisibleForTesting
    protected static class LineParser
    implements Function1<String, Object[]> {
        protected LineParser() {
        }

        public Object[] apply(String line) {
            StringBuilder sb;
            String[] tokens = line.trim().split(" +");
            Object[] values = new Object[PS_FIELD_NAMES.size()];
            if (tokens.length < PS_FIELD_NAMES.size()) {
                throw new IllegalArgumentException("Expected at least " + PS_FIELD_NAMES.size() + ", got " + tokens.length);
            }
            int fieldIdx = 0;
            int processedTokens = 0;
            if (tokens.length > PS_FIELD_NAMES.size()) {
                sb = new StringBuilder();
                for (String field : tokens) {
                    if (NUMERIC_PATTERN.matcher(field).matches()) break;
                    ++processedTokens;
                    sb.append(field).append(" ");
                }
                values[fieldIdx] = LineParser.field((String)PS_FIELD_NAMES.get(fieldIdx), sb.deleteCharAt(sb.length() - 1).toString());
                ++fieldIdx;
            }
            while (fieldIdx < values.length - 1) {
                try {
                    values[fieldIdx] = LineParser.field((String)PS_FIELD_NAMES.get(fieldIdx), tokens[processedTokens++]);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("while parsing value [" + tokens[fieldIdx] + "] of field [" + (String)PS_FIELD_NAMES.get(fieldIdx) + "] in line [" + line + "]");
                }
                ++fieldIdx;
            }
            if (processedTokens < tokens.length - 1) {
                sb = new StringBuilder();
                while (processedTokens < tokens.length) {
                    sb.append(tokens[processedTokens++]).append(" ");
                }
                values[fieldIdx] = LineParser.field((String)PS_FIELD_NAMES.get(fieldIdx), sb.deleteCharAt(sb.length() - 1).toString());
            } else {
                values[fieldIdx] = LineParser.field((String)PS_FIELD_NAMES.get(fieldIdx), tokens[processedTokens]);
            }
            return values;
        }

        private static Object field(String field, String value) {
            switch (field) {
                case "pid": 
                case "ppid": 
                case "pgrp": 
                case "pgid": 
                case "tpgid": {
                    return Integer.valueOf(value);
                }
                case "pcpu": 
                case "pmem": {
                    return (int)(Float.parseFloat(value) * 10.0f);
                }
                case "time": {
                    Matcher m1 = MINUTE_SECOND_MILLIS_PATTERN.matcher(value);
                    if (m1.matches()) {
                        long h = Long.parseLong(m1.group(1));
                        long m = Long.parseLong(m1.group(2));
                        long s = Long.parseLong(m1.group(3));
                        return h * 3600000L + m * 60000L + s * 1000L;
                    }
                    Matcher m2 = HOUR_MINUTE_SECOND_PATTERN.matcher(value);
                    if (m2.matches()) {
                        long m = Long.parseLong(m2.group(1));
                        long s = Long.parseLong(m2.group(2));
                        StringBuilder g3 = new StringBuilder(m2.group(3));
                        while (g3.length() < 3) {
                            g3.append("0");
                        }
                        long millis = Long.parseLong(g3.toString());
                        return m * 60000L + s * 1000L + millis;
                    }
                    return 0L;
                }
            }
            return value;
        }
    }
}

