/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.os;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.os.AbstractBaseScannableTable;
import org.apache.calcite.adapter.os.Processes;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FilesTableFunction {
    private static final BigDecimal THOUSAND = BigDecimal.valueOf(1000L);

    private FilesTableFunction() {
    }

    public static ScannableTable eval(final String path) {
        return new AbstractBaseScannableTable(){

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add("access_time", SqlTypeName.TIMESTAMP).add("block_count", SqlTypeName.INTEGER).add("change_time", SqlTypeName.TIMESTAMP).add("depth", SqlTypeName.INTEGER).add("device", SqlTypeName.INTEGER).add("file_name", SqlTypeName.VARCHAR).add("fstype", SqlTypeName.VARCHAR).add("gname", SqlTypeName.VARCHAR).add("gid", SqlTypeName.INTEGER).add("dir_name", SqlTypeName.VARCHAR).add("inode", SqlTypeName.BIGINT).add("link", SqlTypeName.VARCHAR).add("perm", SqlTypeName.CHAR, 4).add("hard", SqlTypeName.INTEGER).add("path", SqlTypeName.VARCHAR).add("size", SqlTypeName.BIGINT).add("mod_time", SqlTypeName.TIMESTAMP).add("user", SqlTypeName.VARCHAR).add("uid", SqlTypeName.INTEGER).add("type", SqlTypeName.CHAR, 1).build();
            }

            private Enumerable<String> sourceLinux() {
                String[] args = new String[]{"find", path, "-printf", "%A@\\0%b\\0%C@\\0%d\\0%D\\0%f\\0%F\\0%g\\0%G\\0%h\\0%i\\0%l\\0%#m\\0%n\\0%P\\0%s\\0%T@\\0%u\\0%U\\0%Y\\0"};
                return Processes.processLines('\u0000', args);
            }

            private Enumerable<String> sourceMacOs() {
                if (path.contains("'")) {
                    throw new IllegalArgumentException();
                }
                String[] args = new String[]{"/bin/sh", "-c", "find '" + path + "' | xargs stat -f %a%n%b%n%c%n0%n%Hd%nfilename%nfstype%n%Sg%n%g%ndir_name%n%i%n%Y%n%Lp%n%l%n%SN%n%z%n%m%n%Su%n%u%n%LT%n"};
                return Processes.processLines('\n', args);
            }

            public Enumerable<@Nullable Object[]> scan(DataContext root) {
                Enumerable<String> enumerable;
                JavaTypeFactory typeFactory = root.getTypeFactory();
                RelDataType rowType = this.getRowType((RelDataTypeFactory)typeFactory);
                ImmutableList fieldNames = ImmutableList.copyOf((Collection)rowType.getFieldNames());
                String osName = System.getProperty("os.name");
                String osVersion = System.getProperty("os.version");
                Util.discard((Object)osVersion);
                switch (osName) {
                    case "Mac OS X": {
                        enumerable = this.sourceMacOs();
                        break;
                    }
                    default: {
                        enumerable = this.sourceLinux();
                    }
                }
                return new AbstractEnumerable<Object[]>((List)fieldNames, osName){
                    final /* synthetic */ List val$fieldNames;
                    final /* synthetic */ String val$osName;
                    {
                        this.val$fieldNames = list;
                        this.val$osName = string;
                    }

                    public Enumerator<@Nullable Object[]> enumerator() {
                        final Enumerator e = enumerable.enumerator();
                        return new Enumerator<Object[]>(){
                            @Nullable Object @Nullable [] current;

                            public Object[] current() {
                                return Objects.requireNonNull(this.current, "current");
                            }

                            public boolean moveNext() {
                                this.current = new Object[val$fieldNames.size()];
                                for (int i = 0; i < this.current.length; ++i) {
                                    if (!e.moveNext()) {
                                        return false;
                                    }
                                    String v = (String)e.current();
                                    try {
                                        this.current[i] = this.field((String)val$fieldNames.get(i), v);
                                        continue;
                                    }
                                    catch (RuntimeException e2) {
                                        throw new RuntimeException("while parsing value [" + v + "] of field [" + (String)val$fieldNames.get(i) + "] in line [" + Arrays.toString(this.current) + "]", e2);
                                    }
                                }
                                switch (val$osName) {
                                    case "Mac OS X": {
                                        String path = Objects.requireNonNull((String)this.current[14]);
                                        if (".".equals(path)) {
                                            path = "";
                                            this.current[14] = "";
                                            this.current[3] = 0;
                                        } else if (path.startsWith("./")) {
                                            path = path.substring(2);
                                            this.current[14] = path;
                                            this.current[3] = this.count(path, '/') + 1;
                                        } else {
                                            this.current[3] = this.count(path, '/');
                                        }
                                        int slash = path.lastIndexOf(47);
                                        if (slash >= 0) {
                                            this.current[5] = path.substring(slash + 1);
                                            this.current[9] = path.substring(0, slash);
                                        } else {
                                            this.current[5] = path;
                                            this.current[9] = "";
                                        }
                                        String type = (String)this.current[19];
                                        this.current[19] = "/".equals(type) ? "d" : ("".equals(type) || "*".equals(type) ? "f" : ("@".equals(type) ? "l" : type));
                                        break;
                                    }
                                }
                                return true;
                            }

                            private int count(String s, char c) {
                                int n = 0;
                                int len = s.length();
                                for (int i = 0; i < len; ++i) {
                                    if (s.charAt(i) != c) continue;
                                    ++n;
                                }
                                return n;
                            }

                            public void reset() {
                                throw new UnsupportedOperationException();
                            }

                            public void close() {
                                e.close();
                            }

                            private Object field(String field, String value) {
                                switch (field) {
                                    case "block_count": 
                                    case "depth": 
                                    case "device": 
                                    case "gid": 
                                    case "uid": 
                                    case "hard": {
                                        return Integer.valueOf(value);
                                    }
                                    case "inode": 
                                    case "size": {
                                        return Long.valueOf(value);
                                    }
                                    case "access_time": 
                                    case "change_time": 
                                    case "mod_time": {
                                        return new BigDecimal(value).multiply(THOUSAND).longValue();
                                    }
                                }
                                return value;
                            }
                        };
                    }
                };
            }
        };
    }
}

