/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.mongodb.MongoRel;
import org.apache.calcite.adapter.mongodb.MongoRules;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.JsonBuilder;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MongoFilter
extends Filter
implements MongoRel {
    public MongoFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
        super(cluster, traitSet, child, condition);
        assert (this.getConvention() == MongoRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    public MongoFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new MongoFilter(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public void implement(MongoRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        Translator translator = new Translator(implementor.rexBuilder, MongoRules.mongoFieldNames(this.getRowType()));
        String match = translator.translateMatch(this.condition);
        implementor.add(null, match);
    }

    static class Translator {
        final JsonBuilder builder = new JsonBuilder();
        private final RexBuilder rexBuilder;
        private final List<String> fieldNames;

        Translator(RexBuilder rexBuilder, List<String> fieldNames) {
            this.rexBuilder = rexBuilder;
            this.fieldNames = fieldNames;
        }

        private String translateMatch(RexNode condition) {
            Map map = this.builder.map();
            map.put("$match", this.translateOr(condition));
            return this.builder.toJsonString((Object)map);
        }

        private Map<String, Object> translateOr(RexNode condition) {
            RexNode condition2 = RexUtil.expandSearch((RexBuilder)this.rexBuilder, null, (RexNode)condition);
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (RexNode node : RelOptUtil.disjunctions((RexNode)condition2)) {
                list.add(this.translateAnd(node));
            }
            switch (list.size()) {
                case 1: {
                    return (Map)list.get(0);
                }
            }
            Map map = this.builder.map();
            map.put("$or", list);
            return map;
        }

        private Map<String, Object> translateAnd(RexNode node0) {
            HashMultimap multimap = HashMultimap.create();
            LinkedHashMap<String, RexLiteral> eqMap = new LinkedHashMap<String, RexLiteral>();
            ArrayList<Map<String, Object>> orMapList = new ArrayList<Map<String, Object>>();
            for (Object node : RelOptUtil.conjunctions((RexNode)node0)) {
                this.translateMatch2((RexNode)node, orMapList, (Multimap<String, Pair<String, RexLiteral>>)multimap, eqMap);
            }
            Map map = this.builder.map();
            for (Map.Entry entry : eqMap.entrySet()) {
                multimap.removeAll(entry.getKey());
                map.put(entry.getKey(), Translator.literalValue((RexLiteral)entry.getValue()));
            }
            for (Map.Entry entry : multimap.asMap().entrySet()) {
                Map map2 = this.builder.map();
                for (Pair s : (Collection)entry.getValue()) {
                    Translator.addPredicate(map2, (String)s.left, Translator.literalValue((RexLiteral)s.right));
                }
                map.put(entry.getKey(), map2);
            }
            if (!orMapList.isEmpty()) {
                Map andMap = this.builder.map();
                if (!map.isEmpty()) {
                    orMapList.add(map);
                }
                andMap.put("$and", orMapList);
                return andMap;
            }
            return map;
        }

        private static void addPredicate(Map<String, Object> map, String op, Object v) {
            if (map.containsKey(op) && Translator.stronger(op, map.get(op), v)) {
                return;
            }
            map.put(op, v);
        }

        private static boolean stronger(String key, Object v0, Object v1) {
            if (key.equals("$lt") || key.equals("$lte")) {
                if (v0 instanceof Number && v1 instanceof Number) {
                    return ((Number)v0).doubleValue() < ((Number)v1).doubleValue();
                }
                if (v0 instanceof String && v1 instanceof String) {
                    return v0.toString().compareTo(v1.toString()) < 0;
                }
            }
            if (key.equals("$gt") || key.equals("$gte")) {
                return Translator.stronger("$lt", v1, v0);
            }
            return false;
        }

        private static Object literalValue(RexLiteral literal) {
            return literal.getValue2();
        }

        private Void translateMatch2(RexNode node, List<Map<String, Object>> orMapList, Multimap<String, Pair<String, RexLiteral>> multimap, Map<String, RexLiteral> eqMap) {
            switch (node.getKind()) {
                case EQUALS: {
                    return this.translateBinary(null, null, (RexCall)node, multimap, eqMap);
                }
                case LESS_THAN: {
                    return this.translateBinary("$lt", "$gt", (RexCall)node, multimap, eqMap);
                }
                case LESS_THAN_OR_EQUAL: {
                    return this.translateBinary("$lte", "$gte", (RexCall)node, multimap, eqMap);
                }
                case NOT_EQUALS: {
                    return this.translateBinary("$ne", "$ne", (RexCall)node, multimap, eqMap);
                }
                case GREATER_THAN: {
                    return this.translateBinary("$gt", "$lt", (RexCall)node, multimap, eqMap);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return this.translateBinary("$gte", "$lte", (RexCall)node, multimap, eqMap);
                }
                case OR: {
                    return this.translateOrAddToList(node, orMapList);
                }
            }
            throw new AssertionError((Object)("cannot translate " + node));
        }

        private Void translateOrAddToList(RexNode node, List<Map<String, Object>> orMapList) {
            Map<String, Object> or = this.translateOr(node);
            orMapList.add(or);
            return null;
        }

        private Void translateBinary(String op, String rop, RexCall call, Multimap<String, Pair<String, RexLiteral>> multimap, Map<String, RexLiteral> eqMap) {
            RexNode right;
            RexNode left = (RexNode)call.operands.get(0);
            boolean b = this.translateBinary2(op, left, right = (RexNode)call.operands.get(1), multimap, eqMap);
            if (b) {
                return null;
            }
            b = this.translateBinary2(rop, right, left, multimap, eqMap);
            if (b) {
                return null;
            }
            throw new AssertionError((Object)("cannot translate op " + op + " call " + call));
        }

        private boolean translateBinary2(String op, RexNode left, RexNode right, Multimap<String, Pair<String, RexLiteral>> multimap, Map<String, RexLiteral> eqMap) {
            switch (right.getKind()) {
                case LITERAL: {
                    break;
                }
                default: {
                    return false;
                }
            }
            RexLiteral rightLiteral = (RexLiteral)right;
            switch (left.getKind()) {
                case INPUT_REF: {
                    RexInputRef left1 = (RexInputRef)left;
                    String name = this.fieldNames.get(left1.getIndex());
                    this.translateOp2(op, name, rightLiteral, multimap, eqMap);
                    return true;
                }
                case CAST: {
                    return this.translateBinary2(op, (RexNode)((RexCall)left).operands.get(0), right, multimap, eqMap);
                }
                case ITEM: {
                    String itemName = MongoRules.isItem((RexCall)left);
                    if (itemName == null) break;
                    this.translateOp2(op, itemName, rightLiteral, multimap, eqMap);
                    return true;
                }
            }
            return false;
        }

        private void translateOp2(String op, String name, RexLiteral right, Multimap<String, Pair<String, RexLiteral>> multimap, Map<String, RexLiteral> eqMap) {
            if (op == null) {
                eqMap.put(name, right);
            } else {
                multimap.put((Object)name, (Object)Pair.of((Object)op, (Object)right));
            }
        }
    }
}

