/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.simple;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.calcite.adapter.geode.simple.GeodeSimpleScannableTable;
import org.apache.calcite.adapter.geode.util.GeodeUtils;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.ClientCache;

public class GeodeSimpleSchema
extends AbstractSchema {
    private final String[] regionNames;
    private final ClientCache clientCache;
    private ImmutableMap<String, Table> tableMap;

    public GeodeSimpleSchema(String locatorHost, int locatorPort, String[] regionNames, String pdxAutoSerializerPackageExp) {
        this.regionNames = regionNames;
        this.clientCache = GeodeUtils.createClientCache(locatorHost, locatorPort, pdxAutoSerializerPackageExp, true);
    }

    protected Map<String, Table> getTableMap() {
        if (this.tableMap == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String regionName : this.regionNames) {
                Region region = GeodeUtils.createRegion((GemFireCache)this.clientCache, regionName);
                GeodeSimpleScannableTable table = new GeodeSimpleScannableTable(regionName, GeodeUtils.autodetectRelTypeFromRegion(region), this.clientCache);
                builder.put((Object)regionName, (Object)table);
            }
            this.tableMap = builder.build();
        }
        return this.tableMap;
    }
}

