/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.adapter.geode.rel.GeodeRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GeodeAggregate
extends Aggregate
implements GeodeRel {
    public GeodeAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traitSet, (List)ImmutableList.of(), input, groupSet, groupSets, aggCalls);
        assert (this.getConvention() == GeodeRel.CONVENTION);
        assert (this.getConvention() == this.input.getConvention());
        assert (this.getConvention() == input.getConvention());
        assert (this.groupSets.size() == 1) : "Grouping sets not supported";
        for (AggregateCall aggCall : aggCalls) {
            if (!aggCall.isDistinct()) continue;
            System.out.println("DISTINCT based aggregation!");
        }
    }

    @Deprecated
    public GeodeAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        this(cluster, traitSet, input, groupSet, groupSets, aggCalls);
        GeodeAggregate.checkIndicator((boolean)indicator);
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new GeodeAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = Objects.requireNonNull(super.computeSelfCost(planner, mq));
        return cost.multiplyBy(0.1);
    }

    @Override
    public void implement(GeodeRel.GeodeImplementContext geodeImplementContext) {
        geodeImplementContext.visitChild(this.getInput());
        List<String> inputFields = GeodeAggregate.fieldNames(this.getInput().getRowType());
        ArrayList<String> groupByFields = new ArrayList<String>();
        Iterator iterator = this.groupSet.iterator();
        while (iterator.hasNext()) {
            int group = (Integer)iterator.next();
            groupByFields.add(inputFields.get(group));
        }
        geodeImplementContext.addGroupBy(groupByFields);
        ImmutableMap.Builder aggregateFunctionMap = ImmutableMap.builder();
        for (AggregateCall aggCall : this.aggCalls) {
            ArrayList<String> aggCallFieldNames = new ArrayList<String>();
            Iterator iterator2 = aggCall.getArgList().iterator();
            while (iterator2.hasNext()) {
                int i = (Integer)iterator2.next();
                aggCallFieldNames.add(inputFields.get(i));
            }
            String functionName = aggCall.getAggregation().getName();
            if ("COUNT".equalsIgnoreCase(functionName) && aggCallFieldNames.isEmpty()) {
                aggCallFieldNames.add(inputFields.get(0));
            }
            String oqlAggregateCall = Util.toString(aggCallFieldNames, (String)(functionName + "("), (String)", ", (String)")");
            aggregateFunctionMap.put((Object)aggCall.getName(), (Object)oqlAggregateCall);
        }
        geodeImplementContext.addAggregateFunctions((Map<String, String>)aggregateFunctionMap.build());
    }

    private static List<String> fieldNames(RelDataType relDataType) {
        ArrayList<String> names = new ArrayList<String>();
        for (RelDataTypeField rdtf : relDataType.getFieldList()) {
            names.add(rdtf.getName());
        }
        return names;
    }
}

