/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.geode.rel.GeodeRel;
import org.apache.calcite.adapter.geode.rel.GeodeRules;
import org.apache.calcite.adapter.geode.rel.GeodeTable;
import org.apache.calcite.adapter.geode.rel.GeodeToEnumerableConverterRule;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GeodeTableScan
extends TableScan
implements GeodeRel {
    final GeodeTable geodeTable;
    final @Nullable RelDataType projectRowType;

    GeodeTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, GeodeTable geodeTable, @Nullable RelDataType projectRowType) {
        super(cluster, traitSet, (List)ImmutableList.of(), table);
        this.geodeTable = Objects.requireNonNull(geodeTable, "geodeTable");
        this.projectRowType = projectRowType;
        Preconditions.checkArgument((this.getConvention() == GeodeRel.CONVENTION ? 1 : 0) != 0);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    public RelDataType deriveRowType() {
        return this.projectRowType != null ? this.projectRowType : super.deriveRowType();
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)GeodeToEnumerableConverterRule.INSTANCE);
        for (RelOptRule rule : GeodeRules.RULES) {
            planner.addRule(rule);
        }
    }

    @Override
    public void implement(GeodeRel.GeodeImplementContext geodeImplementContext) {
        geodeImplementContext.geodeTable = this.geodeTable;
        geodeImplementContext.table = this.table;
    }
}

