/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.adapter.geode.rel.GeodeEnumerator;
import org.apache.calcite.adapter.geode.rel.GeodeRel;
import org.apache.calcite.adapter.geode.rel.GeodeSchema;
import org.apache.calcite.adapter.geode.rel.GeodeTableScan;
import org.apache.calcite.adapter.geode.util.GeodeUtils;
import org.apache.calcite.adapter.geode.util.JavaTypeFactoryExtImpl;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeodeTable
extends AbstractQueryableTable
implements TranslatableTable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GeodeTable.class.getName());
    private final String regionName;
    private final RelDataType rowType;

    GeodeTable(Region<?, ?> region) {
        super(Object[].class);
        this.regionName = region.getName();
        this.rowType = GeodeUtils.autodetectRelTypeFromRegion(region);
    }

    public String toString() {
        return "GeodeTable {" + this.regionName + "}";
    }

    /*
     * WARNING - void declaration
     */
    public Enumerable<Object> query(final GemFireCache clientCache, List<Map.Entry<String, Class>> fields, List<Map.Entry<String, String>> selectFields, List<Map.Entry<String, String>> aggregateFunctions, List<String> groupByFields, List<String> predicates, List<String> orderByFields, @Nullable Long limit) {
        void var15_32;
        JavaTypeFactoryExtImpl typeFactory = new JavaTypeFactoryExtImpl();
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        for (Map.Entry<String, Class> field : fields) {
            Iterator<Object> type;
            SqlTypeName typeName = typeFactory.createJavaType(field.getValue()).getSqlTypeName();
            if (typeName == SqlTypeName.ARRAY) {
                type = typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.ANY), -1L);
            } else if (typeName == SqlTypeName.MULTISET) {
                type = typeFactory.createMultisetType(typeFactory.createSqlType(SqlTypeName.ANY), -1L);
            } else if (typeName == SqlTypeName.MAP) {
                RelDataType relDataType = typeFactory.createSqlType(SqlTypeName.ANY);
                type = typeFactory.createMapType(relDataType, relDataType);
            } else {
                type = typeFactory.createSqlType(typeName);
            }
            fieldInfo.add(field.getKey(), type).nullable(true);
        }
        final RelProtoDataType resultRowType = RelDataTypeImpl.proto((RelDataType)fieldInfo.build());
        ImmutableMap aggFuncMap = ImmutableMap.of();
        if (!aggregateFunctions.isEmpty()) {
            ImmutableMap.Builder aggFuncMapBuilder = ImmutableMap.builder();
            for (Map.Entry entry : aggregateFunctions) {
                aggFuncMapBuilder.put(entry.getKey(), entry.getValue());
            }
            aggFuncMap = aggFuncMapBuilder.build();
        }
        ImmutableList.Builder selectBuilder = ImmutableList.builder();
        if (!groupByFields.isEmpty()) {
            for (String string : groupByFields) {
                selectBuilder.add((Object)(string + " AS " + string));
            }
            if (!aggFuncMap.isEmpty()) {
                for (Map.Entry entry : aggFuncMap.entrySet()) {
                    selectBuilder.add((Object)((String)entry.getValue() + " AS " + (String)entry.getKey()));
                }
            }
        } else if (selectFields.isEmpty()) {
            if (!aggFuncMap.isEmpty()) {
                for (Map.Entry entry : aggFuncMap.entrySet()) {
                    selectBuilder.add((Object)((String)entry.getValue() + " AS " + (String)entry.getKey()));
                }
            } else {
                selectBuilder.add((Object)"*");
            }
        } else if (!aggFuncMap.isEmpty()) {
            for (Map.Entry entry : aggFuncMap.entrySet()) {
                selectBuilder.add((Object)((String)entry.getValue() + " AS " + (String)entry.getKey()));
            }
        } else {
            for (Map.Entry entry : selectFields) {
                selectBuilder.add((Object)((String)entry.getKey() + " AS " + (String)entry.getValue()));
            }
        }
        String oqlSelectStatement = Util.toString((Iterable)selectBuilder.build(), (String)"", (String)", ", (String)"");
        String string = "";
        if (!predicates.isEmpty()) {
            String string3 = " WHERE ";
            string3 = string3 + Util.toString(predicates, (String)"", (String)" AND ", (String)"");
        }
        StringBuilder queryBuilder = new StringBuilder("SELECT ");
        queryBuilder.append(oqlSelectStatement).append(" FROM /").append(this.regionName).append((String)var15_32);
        if (!groupByFields.isEmpty()) {
            queryBuilder.append(Util.toString(groupByFields, (String)" GROUP BY ", (String)", ", (String)""));
        }
        if (!orderByFields.isEmpty()) {
            queryBuilder.append(Util.toString(orderByFields, (String)" ORDER BY ", (String)", ", (String)""));
        }
        if (limit != null) {
            queryBuilder.append(" LIMIT ").append(limit);
        }
        final String oqlQuery = queryBuilder.toString();
        Hook.QUERY_PLAN.run((Object)oqlQuery);
        LOGGER.info("OQL: " + oqlQuery);
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                QueryService queryService = clientCache.getQueryService();
                try {
                    SelectResults results = (SelectResults)queryService.newQuery(oqlQuery).execute();
                    return new GeodeEnumerator(results, resultRowType);
                }
                catch (Exception e) {
                    String message = String.format(Locale.ROOT, "Failed to execute query [%s] on %s", oqlQuery, clientCache.getName());
                    throw new RuntimeException(message, e);
                }
            }
        };
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new GeodeQueryable(queryProvider, schema, this, tableName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new GeodeTableScan(cluster, cluster.traitSetOf((RelTrait)GeodeRel.CONVENTION), relOptTable, this, null);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.rowType;
    }

    public static class GeodeQueryable<T>
    extends AbstractTableQueryable<T> {
        public GeodeQueryable(QueryProvider queryProvider, SchemaPlus schema, GeodeTable table, String tableName) {
            super(queryProvider, schema, (QueryableTable)table, tableName);
        }

        public Enumerator<T> enumerator() {
            throw new UnsupportedOperationException("Enumerator on Queryable should never be called");
        }

        private GeodeTable getTable() {
            return (GeodeTable)this.table;
        }

        private GemFireCache getClientCache() {
            GeodeSchema geodeSchema = (GeodeSchema)((Object)Objects.requireNonNull(this.schema.unwrap(GeodeSchema.class)));
            return geodeSchema.cache;
        }

        public Enumerable<Object> query(List<Map.Entry<String, Class>> fields, List<Map.Entry<String, String>> selectFields, List<Map.Entry<String, String>> aggregateFunctions, List<String> groupByFields, List<String> predicates, List<String> order, Long limit) {
            return this.getTable().query(this.getClientCache(), fields, selectFields, aggregateFunctions, groupByFields, predicates, order, limit);
        }
    }
}

