/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.file;

import com.google.common.collect.ImmutableMap;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.type.RelDataType;

enum FileFieldType {
    STRING(null, String.class),
    BOOLEAN(Primitive.BOOLEAN),
    BYTE(Primitive.BYTE),
    CHAR(Primitive.CHAR),
    SHORT(Primitive.SHORT),
    INT(Primitive.INT),
    LONG(Primitive.LONG),
    FLOAT(Primitive.FLOAT),
    DOUBLE(Primitive.DOUBLE),
    DATE(null, Date.class),
    TIME(null, Time.class),
    TIMESTAMP(null, Timestamp.class);

    private final Primitive primitive;
    private final Class clazz;
    private static final Map<String, FileFieldType> MAP;

    private FileFieldType(Primitive primitive) {
        this(primitive, primitive.boxClass);
    }

    private FileFieldType(Primitive primitive, Class clazz) {
        this.primitive = primitive;
        this.clazz = clazz;
    }

    public RelDataType toType(JavaTypeFactory typeFactory) {
        return typeFactory.createJavaType(this.clazz);
    }

    public static FileFieldType of(String typeString) {
        return MAP.get(typeString);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (FileFieldType value : FileFieldType.values()) {
            builder.put((Object)value.clazz.getSimpleName(), (Object)value);
            if (value.primitive == null) continue;
            builder.put((Object)value.primitive.primitiveName, (Object)value);
        }
        MAP = builder.build();
    }
}

