/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.file;

import java.util.List;
import org.apache.calcite.adapter.file.CsvTableScan;
import org.apache.calcite.adapter.file.ImmutableCsvProjectTableScanRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.immutables.value.Value;

@Value.Enclosing
public class CsvProjectTableScanRule
extends RelRule<Config> {
    protected CsvProjectTableScanRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        CsvTableScan scan = (CsvTableScan)call.rel(1);
        int[] fields = CsvProjectTableScanRule.getProjectFields(project.getProjects());
        if (fields == null) {
            return;
        }
        call.transformTo((RelNode)new CsvTableScan(scan.getCluster(), scan.getTable(), scan.csvTable, fields));
    }

    private static int[] getProjectFields(List<RexNode> exps) {
        int[] fields = new int[exps.size()];
        for (int i = 0; i < exps.size(); ++i) {
            RexNode exp = exps.get(i);
            if (!(exp instanceof RexInputRef)) {
                return null;
            }
            fields[i] = ((RexInputRef)exp).getIndex();
        }
        return fields;
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableCsvProjectTableScanRule.Config.builder().withOperandSupplier(b0 -> b0.operand(LogicalProject.class).oneInput(b1 -> b1.operand(CsvTableScan.class).noInputs())).build();

        default public CsvProjectTableScanRule toRule() {
            return new CsvProjectTableScanRule(this);
        }
    }
}

