/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.arrow;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.arrow.ArrowRules;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.DateTimeStringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

class ArrowTranslator {
    final RexBuilder rexBuilder;
    final RelDataType rowType;
    final List<String> fieldNames;

    ArrowTranslator(RexBuilder rexBuilder, RelDataType rowType) {
        this.rexBuilder = rexBuilder;
        this.rowType = rowType;
        this.fieldNames = ArrowRules.arrowFieldNames(rowType);
    }

    public static ArrowTranslator create(RexBuilder rexBuilder, RelDataType rowType) {
        return new ArrowTranslator(rexBuilder, rowType);
    }

    List<String> translateMatch(RexNode condition) {
        List disjunctions = RelOptUtil.disjunctions((RexNode)condition);
        if (disjunctions.size() == 1) {
            return this.translateAnd((RexNode)disjunctions.get(0));
        }
        throw new UnsupportedOperationException("Unsupported disjunctive condition " + condition);
    }

    private static Object literalValue(RexLiteral literal) {
        switch (literal.getTypeName()) {
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                SimpleDateFormat dateFormatter = DateTimeStringUtils.getDateFormatter((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                Long millis = (Long)literal.getValueAs(Long.class);
                return dateFormatter.format(Objects.requireNonNull(millis, "millis"));
            }
            case DATE: {
                DateString dateString = (DateString)literal.getValueAs(DateString.class);
                return Objects.requireNonNull(dateString, "dateString").toString();
            }
        }
        return Objects.requireNonNull(literal.getValue3());
    }

    private List<String> translateAnd(RexNode condition) {
        ArrayList<String> predicates = new ArrayList<String>();
        for (RexNode node : RelOptUtil.conjunctions((RexNode)condition)) {
            if (node.getKind() == SqlKind.SEARCH) {
                RexNode node2 = RexUtil.expandSearch((RexBuilder)this.rexBuilder, null, (RexNode)node);
                predicates.addAll(this.translateMatch(node2));
                continue;
            }
            predicates.add(this.translateMatch2(node));
        }
        return predicates;
    }

    private String translateMatch2(RexNode node) {
        switch (node.getKind()) {
            case EQUALS: {
                return this.translateBinary("equal", "=", (RexCall)node);
            }
            case NOT_EQUALS: {
                return this.translateBinary("not_equal", "<>", (RexCall)node);
            }
            case LESS_THAN: {
                return this.translateBinary("less_than", ">", (RexCall)node);
            }
            case LESS_THAN_OR_EQUAL: {
                return this.translateBinary("less_than_or_equal_to", ">=", (RexCall)node);
            }
            case GREATER_THAN: {
                return this.translateBinary("greater_than", "<", (RexCall)node);
            }
            case GREATER_THAN_OR_EQUAL: {
                return this.translateBinary("greater_than_or_equal_to", "<=", (RexCall)node);
            }
            case IS_NULL: {
                return this.translateUnary("isnull", (RexCall)node);
            }
            case IS_NOT_NULL: {
                return this.translateUnary("isnotnull", (RexCall)node);
            }
            case IS_NOT_TRUE: {
                return this.translateUnary("isnottrue", (RexCall)node);
            }
            case IS_NOT_FALSE: {
                return this.translateUnary("isnotfalse", (RexCall)node);
            }
            case INPUT_REF: {
                RexInputRef inputRef = (RexInputRef)node;
                return this.fieldNames.get(inputRef.getIndex()) + " istrue";
            }
            case NOT: {
                return this.translateUnary("isfalse", (RexCall)node);
            }
        }
        throw new UnsupportedOperationException("Unsupported operator " + node);
    }

    private String translateBinary(String op, String rop, RexCall call) {
        RexNode right;
        RexNode left = (RexNode)call.operands.get(0);
        @Nullable String expression = this.translateBinary2(op, left, right = (RexNode)call.operands.get(1));
        if (expression != null) {
            return expression;
        }
        expression = this.translateBinary2(rop, right, left);
        if (expression != null) {
            return expression;
        }
        throw new UnsupportedOperationException("Unsupported binary operator " + call);
    }

    private @Nullable String translateBinary2(String op, RexNode left, RexNode right) {
        if (right.getKind() != SqlKind.LITERAL) {
            return null;
        }
        RexLiteral rightLiteral = (RexLiteral)right;
        switch (left.getKind()) {
            case INPUT_REF: {
                RexInputRef left1 = (RexInputRef)left;
                String name = this.fieldNames.get(left1.getIndex());
                return this.translateOp2(op, name, rightLiteral);
            }
            case CAST: {
                return this.translateBinary2(op, (RexNode)((RexCall)left).operands.get(0), right);
            }
        }
        return null;
    }

    private String translateOp2(String op, String name, RexLiteral right) {
        RelDataTypeField field;
        SqlTypeName typeName;
        Object value = ArrowTranslator.literalValue(right);
        String valueString = value.toString();
        String valueType = ArrowTranslator.getLiteralType(right.getType());
        if (value instanceof String && (typeName = (field = Objects.requireNonNull(this.rowType.getField(name, true, false), "field")).getType().getSqlTypeName()) != SqlTypeName.CHAR) {
            valueString = "'" + valueString + "'";
        }
        return name + " " + op + " " + valueString + " " + valueType;
    }

    private String translateUnary(String op, RexCall call) {
        RexNode opNode = (RexNode)call.operands.get(0);
        @Nullable String expression = this.translateUnary2(op, opNode);
        if (expression != null) {
            return expression;
        }
        throw new UnsupportedOperationException("Unsupported unary operator " + call);
    }

    private @Nullable String translateUnary2(String op, RexNode opNode) {
        if (opNode.getKind() == SqlKind.INPUT_REF) {
            RexInputRef inputRef = (RexInputRef)opNode;
            String name = this.fieldNames.get(inputRef.getIndex());
            return ArrowTranslator.translateUnaryOp(op, name);
        }
        return null;
    }

    private static String translateUnaryOp(String op, String name) {
        return name + " " + op;
    }

    private static String getLiteralType(RelDataType type) {
        if (type.getSqlTypeName() == SqlTypeName.DECIMAL) {
            return "decimal(" + type.getPrecision() + "," + type.getScale() + ")";
        }
        if (type.getSqlTypeName() == SqlTypeName.REAL) {
            return "float";
        }
        if (type.getSqlTypeName() == SqlTypeName.DOUBLE) {
            return "double";
        }
        if (type.getSqlTypeName() == SqlTypeName.INTEGER) {
            return "integer";
        }
        if (type.getSqlTypeName() == SqlTypeName.VARCHAR || type.getSqlTypeName() == SqlTypeName.CHAR) {
            return "string";
        }
        throw new UnsupportedOperationException("Unsupported type " + type);
    }
}

