/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.arrow;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.gandiva.evaluator.Filter;
import org.apache.arrow.gandiva.evaluator.Projector;
import org.apache.arrow.gandiva.exceptions.GandivaException;
import org.apache.arrow.gandiva.expression.Condition;
import org.apache.arrow.gandiva.expression.ExpressionTree;
import org.apache.arrow.gandiva.expression.TreeBuilder;
import org.apache.arrow.gandiva.expression.TreeNode;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.arrow.ArrowEnumerable;
import org.apache.calcite.adapter.arrow.ArrowFieldTypeFactory;
import org.apache.calcite.adapter.arrow.ArrowRel;
import org.apache.calcite.adapter.arrow.ArrowTableScan;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ArrowTable
extends AbstractTable
implements TranslatableTable,
QueryableTable {
    private final @Nullable RelProtoDataType protoRowType;
    private final Schema schema;
    private final ArrowFileReader arrowFileReader;

    ArrowTable(@Nullable RelProtoDataType protoRowType, ArrowFileReader arrowFileReader) {
        try {
            this.schema = arrowFileReader.getVectorSchemaRoot().getSchema();
        }
        catch (IOException e) {
            throw Util.toUnchecked((Exception)e);
        }
        this.protoRowType = protoRowType;
        this.arrowFileReader = arrowFileReader;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.protoRowType != null) {
            return (RelDataType)this.protoRowType.apply((Object)typeFactory);
        }
        return ArrowTable.deduceRowType(this.schema, (JavaTypeFactory)typeFactory);
    }

    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
        return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
    }

    public Enumerable<Object> query(DataContext root, ImmutableIntList fields, List<String> conditions) {
        Condition filterCondition;
        Projector projector;
        Filter filter;
        Objects.requireNonNull(fields, "fields");
        if (conditions.isEmpty()) {
            filter = null;
            ArrayList<ExpressionTree> expressionTrees = new ArrayList<ExpressionTree>();
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                int fieldOrdinal = (Integer)iterator.next();
                Field field = (Field)this.schema.getFields().get(fieldOrdinal);
                TreeNode node = TreeBuilder.makeField((Field)field);
                expressionTrees.add(TreeBuilder.makeExpression((TreeNode)node, (Field)field));
            }
            try {
                projector = Projector.make((Schema)this.schema, expressionTrees);
            }
            catch (GandivaException e) {
                throw Util.toUnchecked((Exception)((Object)e));
            }
        }
        projector = null;
        ArrayList<TreeNode> conditionNodes = new ArrayList<TreeNode>(conditions.size());
        for (String condition : conditions) {
            String[] data = condition.split(" ");
            ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(2);
            treeNodes.add(TreeBuilder.makeField((Field)((Field)this.schema.getFields().get(this.schema.getFields().indexOf(this.schema.findField(data[0]))))));
            if (data.length > 2) {
                treeNodes.add(ArrowTable.makeLiteralNode(data[2], data[3]));
            }
            String operator = data[1];
            conditionNodes.add(TreeBuilder.makeFunction((String)operator, treeNodes, (ArrowType)new ArrowType.Bool()));
        }
        if (conditionNodes.size() == 1) {
            filterCondition = TreeBuilder.makeCondition((TreeNode)((TreeNode)conditionNodes.get(0)));
        } else {
            TreeNode treeNode = TreeBuilder.makeAnd(conditionNodes);
            filterCondition = TreeBuilder.makeCondition((TreeNode)treeNode);
        }
        try {
            filter = Filter.make((Schema)this.schema, (Condition)filterCondition);
        }
        catch (GandivaException e) {
            throw Util.toUnchecked((Exception)((Object)e));
        }
        return new ArrowEnumerable(this.arrowFileReader, fields, projector, filter);
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        throw new UnsupportedOperationException();
    }

    public Type getElementType() {
        return Object[].class;
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        int fieldCount = relOptTable.getRowType().getFieldCount();
        ImmutableIntList fields = ImmutableIntList.copyOf((Iterable)Util.range((int)fieldCount));
        RelOptCluster cluster = context.getCluster();
        return new ArrowTableScan(cluster, cluster.traitSetOf((RelTrait)ArrowRel.CONVENTION), relOptTable, this, fields);
    }

    private static RelDataType deduceRowType(Schema schema, JavaTypeFactory typeFactory) {
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        for (Field field : schema.getFields()) {
            builder.add(field.getName(), ArrowFieldTypeFactory.toType(field.getType(), typeFactory));
        }
        return builder.build();
    }

    private static TreeNode makeLiteralNode(String literal, String type) {
        if (type.startsWith("decimal")) {
            String[] typeParts = type.substring(type.indexOf(40) + 1, type.indexOf(41)).split(",");
            int precision = Integer.parseInt(typeParts[0]);
            int scale = Integer.parseInt(typeParts[1]);
            return TreeBuilder.makeDecimalLiteral((String)literal, (int)precision, (int)scale);
        }
        if (type.equals("integer")) {
            return TreeBuilder.makeLiteral((Integer)Integer.parseInt(literal));
        }
        if (type.equals("long")) {
            return TreeBuilder.makeLiteral((Long)Long.parseLong(literal));
        }
        if (type.equals("float")) {
            return TreeBuilder.makeLiteral((Float)Float.valueOf(Float.parseFloat(literal)));
        }
        if (type.equals("double")) {
            return TreeBuilder.makeLiteral((Double)Double.parseDouble(literal));
        }
        if (type.equals("string")) {
            return TreeBuilder.makeStringLiteral((String)literal.substring(1, literal.length() - 1));
        }
        throw new IllegalArgumentException("Invalid literal " + literal + ", type " + type);
    }
}

