/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.arrow;

import java.io.IOException;
import org.apache.arrow.gandiva.evaluator.Projector;
import org.apache.arrow.gandiva.exceptions.GandivaException;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.calcite.adapter.arrow.AbstractArrowEnumerator;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;

class ArrowProjectEnumerator
extends AbstractArrowEnumerator {
    private final Projector projector;

    ArrowProjectEnumerator(ArrowFileReader arrowFileReader, ImmutableIntList fields, Projector projector) {
        super(arrowFileReader, fields);
        this.projector = projector;
    }

    @Override
    protected void evaluateOperator(ArrowRecordBatch arrowRecordBatch) {
        try {
            this.projector.evaluate(arrowRecordBatch, this.valueVectors);
        }
        catch (GandivaException e) {
            throw Util.toUnchecked((Exception)((Object)e));
        }
    }

    public boolean moveNext() {
        if (this.currRowIndex >= this.rowCount - 1) {
            boolean hasNextBatch;
            try {
                hasNextBatch = this.arrowFileReader.loadNextBatch();
            }
            catch (IOException e) {
                throw Util.toUnchecked((Exception)e);
            }
            if (hasNextBatch) {
                this.currRowIndex = 0;
                this.valueVectors.clear();
                this.loadNextArrowBatch();
            }
            return hasNextBatch;
        }
        ++this.currRowIndex;
        return true;
    }

    public void close() {
        try {
            this.projector.close();
        }
        catch (GandivaException e) {
            throw Util.toUnchecked((Exception)((Object)e));
        }
    }
}

