/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.arrow;

import com.google.common.primitives.Ints;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.arrow.ArrowMethod;
import org.apache.calcite.adapter.arrow.ArrowRel;
import org.apache.calcite.adapter.arrow.ArrowTable;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.BuiltInMethod;

class ArrowToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    protected ArrowToEnumerableConverter(RelOptCluster cluster, RelTraitSet traitSet, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traitSet, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new ArrowToEnumerableConverter(this.getCluster(), traitSet, (RelNode)ArrowToEnumerableConverter.sole(inputs));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = super.computeSelfCost(planner, mq);
        return Objects.requireNonNull(cost, "cost").multiplyBy(0.1);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        ArrowRel.Implementor arrowImplementor = new ArrowRel.Implementor();
        arrowImplementor.visitInput(0, this.getInput());
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)pref.preferArray());
        RelOptTable table = Objects.requireNonNull(arrowImplementor.table, "table");
        int fieldCount = table.getRowType().getFieldCount();
        return implementor.result(physType, Blocks.toBlock((Node)Expressions.call((Expression)table.getExpression(ArrowTable.class), (Method)ArrowMethod.ARROW_QUERY.method, (Expression[])new Expression[]{implementor.getRootExpression(), arrowImplementor.selectFields != null ? Expressions.call((Method)BuiltInMethod.IMMUTABLE_INT_LIST_COPY_OF.method, (Expression[])new Expression[]{Expressions.constant((Object)Ints.toArray(arrowImplementor.selectFields))}) : Expressions.call((Method)BuiltInMethod.IMMUTABLE_INT_LIST_IDENTITY.method, (Expression[])new Expression[]{Expressions.constant((Object)fieldCount)}), Expressions.constant(arrowImplementor.whereClause)})));
    }
}

