/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.arrow;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.adapter.arrow.ArrowRel;
import org.apache.calcite.adapter.arrow.ArrowRules;
import org.apache.calcite.adapter.arrow.ArrowTable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.util.ImmutableIntList;

class ArrowTableScan
extends TableScan
implements ArrowRel {
    private final ArrowTable arrowTable;
    private final ImmutableIntList fields;

    ArrowTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable relOptTable, ArrowTable arrowTable, ImmutableIntList fields) {
        super(cluster, traitSet, (List)ImmutableList.of(), relOptTable);
        this.arrowTable = arrowTable;
        this.fields = fields;
        assert (this.getConvention() == ArrowRel.CONVENTION);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        Preconditions.checkArgument((boolean)inputs.isEmpty());
        return this;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("fields", (Object)this.fields);
    }

    public RelDataType deriveRowType() {
        List fieldList = this.table.getRowType().getFieldList();
        RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            builder.add((RelDataTypeField)fieldList.get(field));
        }
        return builder.build();
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)ArrowRules.TO_ENUMERABLE);
        for (RelOptRule rule : ArrowRules.RULES) {
            planner.addRule(rule);
        }
    }

    @Override
    public void implement(ArrowRel.Implementor implementor) {
        implementor.arrowTable = this.arrowTable;
        implementor.table = this.table;
    }
}

