/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.arrow;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.channels.SeekableByteChannel;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.SeekableReadChannel;
import org.apache.calcite.adapter.arrow.ArrowTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.util.Sources;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArrowSchema
extends AbstractSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrowSchema.class);
    private final Supplier<Map<String, Table>> tableMapSupplier;

    ArrowSchema(File baseDirectory) {
        Objects.requireNonNull(baseDirectory, "baseDirectory");
        this.tableMapSupplier = Suppliers.memoize(() -> ArrowSchema.deduceTableMap(baseDirectory));
    }

    private static String trim(String s, String suffix) {
        String trimmed = ArrowSchema.trimOrNull(s, suffix);
        return trimmed != null ? trimmed : s;
    }

    private static @Nullable String trimOrNull(String s, String suffix) {
        return s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : null;
    }

    protected Map<String, Table> getTableMap() {
        return this.tableMapSupplier.get();
    }

    private static Map<String, Table> deduceTableMap(File baseDirectory) {
        File[] files = baseDirectory.listFiles((dir, name) -> name.endsWith(".arrow"));
        if (files == null) {
            LOGGER.info("directory " + baseDirectory + " not found");
            return ImmutableMap.of();
        }
        HashMap<String, ArrowTable> tables = new HashMap<String, ArrowTable>();
        for (File file : files) {
            FileInputStream fileInputStream;
            File arrowFile = new File(Sources.of((File)file).path());
            try {
                fileInputStream = new FileInputStream(arrowFile);
            }
            catch (FileNotFoundException e) {
                throw Util.toUnchecked((Exception)e);
            }
            SeekableReadChannel seekableReadChannel = new SeekableReadChannel((SeekableByteChannel)fileInputStream.getChannel());
            RootAllocator allocator = new RootAllocator();
            ArrowFileReader arrowFileReader = new ArrowFileReader(seekableReadChannel, (BufferAllocator)allocator);
            String tableName = ArrowSchema.trim(file.getName(), ".arrow").toUpperCase(Locale.ROOT);
            ArrowTable table = new ArrowTable(null, arrowFileReader);
            tables.put(tableName, table);
        }
        return ImmutableMap.copyOf(tables);
    }
}

