/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.arrow;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.adapter.arrow.ArrowFilter;
import org.apache.calcite.adapter.arrow.ArrowProject;
import org.apache.calcite.adapter.arrow.ArrowRel;
import org.apache.calcite.adapter.arrow.ArrowTableScan;
import org.apache.calcite.adapter.arrow.ArrowToEnumerableConverter;
import org.apache.calcite.adapter.arrow.ImmutableConfig;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

public class ArrowRules {
    public static final ArrowProjectRule PROJECT_SCAN = (ArrowProjectRule)ArrowProjectRule.DEFAULT_CONFIG.toRule(ArrowProjectRule.class);
    public static final ArrowFilterRule FILTER_SCAN = ArrowFilterRule.Config.DEFAULT.toRule();
    public static final ConverterRule TO_ENUMERABLE = ArrowToEnumerableConverterRule.DEFAULT_CONFIG.toRule(ArrowToEnumerableConverterRule.class);
    public static final List<RelOptRule> RULES = ImmutableList.of((Object)((Object)PROJECT_SCAN), (Object)((Object)FILTER_SCAN));

    private ArrowRules() {
    }

    static List<String> arrowFieldNames(RelDataType rowType) {
        return SqlValidatorUtil.uniquify((List)rowType.getFieldNames(), (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)true);
    }

    static class ArrowToEnumerableConverterRule
    extends ConverterRule {
        public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(RelNode.class, (RelTrait)ArrowRel.CONVENTION, (RelTrait)EnumerableConvention.INSTANCE, "ArrowToEnumerableConverterRule").withRuleFactory(ArrowToEnumerableConverterRule::new);

        protected ArrowToEnumerableConverterRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode rel) {
            RelTraitSet newTraitSet = rel.getTraitSet().replace((RelTrait)this.getOutConvention());
            return new ArrowToEnumerableConverter(rel.getCluster(), newTraitSet, rel);
        }
    }

    public static class ArrowProjectRule
    extends ArrowConverterRule {
        protected static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalProject.class, (RelTrait)Convention.NONE, (RelTrait)ArrowRel.CONVENTION, "ArrowProjectRule").withRuleFactory(ArrowProjectRule::new);

        protected ArrowProjectRule(ConverterRule.Config config) {
            super(config);
        }

        public @Nullable RelNode convert(RelNode rel) {
            Project project = (Project)rel;
            @Nullable List<Integer> fields = ArrowProject.getProjectFields(project.getProjects());
            if (fields == null) {
                return null;
            }
            RelTraitSet traitSet = project.getTraitSet().replace((RelTrait)ArrowRel.CONVENTION);
            return new ArrowProject(project.getCluster(), traitSet, ArrowProjectRule.convert((RelNode)project.getInput(), (RelTrait)ArrowRel.CONVENTION), project.getProjects(), project.getRowType());
        }
    }

    public static class ArrowFilterRule
    extends RelRule<Config> {
        protected ArrowFilterRule(Config config) {
            super((RelRule.Config)config);
        }

        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            if (filter.getTraitSet().contains((RelTrait)Convention.NONE)) {
                try {
                    RelNode converted = this.convert(filter);
                    call.transformTo(converted);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }

        RelNode convert(Filter filter) {
            RelTraitSet traitSet = filter.getTraitSet().replace((RelTrait)ArrowRel.CONVENTION);
            return new ArrowFilter(filter.getCluster(), traitSet, ArrowFilterRule.convert((RelNode)filter.getInput(), (RelTrait)ArrowRel.CONVENTION), filter.getCondition());
        }

        @Value.Immutable
        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = ImmutableConfig.builder().withOperandSupplier(b0 -> b0.operand(LogicalFilter.class).oneInput(b1 -> b1.operand(ArrowTableScan.class).noInputs())).build();

            default public ArrowFilterRule toRule() {
                return new ArrowFilterRule(this);
            }
        }
    }

    static abstract class ArrowConverterRule
    extends ConverterRule {
        ArrowConverterRule(ConverterRule.Config config) {
            super(config);
        }
    }
}

