/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.arrow;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.arrow.ArrowTable;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.ImmutableIntList;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ArrowRel
extends RelNode {
    public static final Convention CONVENTION = new Convention.Impl("ARROW", ArrowRel.class);

    public void implement(Implementor var1);

    public static class Implementor {
        @Nullable List<Integer> selectFields;
        final List<String> whereClause = new ArrayList<String>();
        @Nullable RelOptTable table;
        @Nullable ArrowTable arrowTable;

        void addFilters(List<String> predicates) {
            this.whereClause.addAll(predicates);
        }

        void addProjectFields(List<Integer> fields) {
            this.selectFields = ImmutableIntList.copyOf(fields);
        }

        public void visitInput(int ordinal, RelNode input) {
            Preconditions.checkArgument((ordinal == 0 ? 1 : 0) != 0);
            ((ArrowRel)input).implement(this);
        }
    }
}

