/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.arrow;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.adapter.arrow.ArrowRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.nullness.qual.Nullable;

class ArrowProject
extends Project
implements ArrowRel {
    ArrowProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traitSet, (List)ImmutableList.of(), input, projects, rowType, (Set)ImmutableSet.of());
        assert (this.getConvention() == ArrowRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new ArrowProject(this.getCluster(), traitSet, input, projects, rowType);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = super.computeSelfCost(planner, mq);
        return Objects.requireNonNull(cost, "cost").multiplyBy(0.1);
    }

    @Override
    public void implement(ArrowRel.Implementor implementor) {
        implementor.visitInput(0, this.getInput());
        List<Integer> projectedFields = ArrowProject.getProjectFields(this.getProjects());
        if (projectedFields != null) {
            implementor.addProjectFields(projectedFields);
        }
    }

    static @Nullable List<Integer> getProjectFields(List<RexNode> exps) {
        ArrayList<Integer> fields = new ArrayList<Integer>();
        for (RexNode exp : exps) {
            if (exp instanceof RexInputRef) {
                fields.add(((RexInputRef)exp).getIndex());
                continue;
            }
            return null;
        }
        return fields;
    }
}

