/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.ElementType;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.bval.jsr303.ConstraintViolationImpl;
import org.apache.bval.jsr303.GroupValidationContext;
import org.apache.bval.jsr303.util.PathImpl;
import org.apache.bval.model.ValidationContext;
import org.apache.bval.model.ValidationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstraintValidationListener<T>
implements ValidationListener {
    private final Set<ConstraintViolation<T>> constraintViolations = new HashSet<ConstraintViolation<T>>();
    private final T rootBean;
    private final Class<T> rootBeanType;
    private final AtomicInteger compositeDepth = new AtomicInteger(0);
    private boolean hasCompositeError;

    public ConstraintValidationListener(T aRootBean, Class<T> rootBeanType) {
        this.rootBean = aRootBean;
        this.rootBeanType = rootBeanType;
    }

    public <VL extends ValidationListener> void addError(String reason, ValidationContext<VL> context) {
        this.addError(reason, null, context);
    }

    public <VL extends ValidationListener> void addError(ValidationListener.Error error, ValidationContext<VL> context) {
        if (error.getOwner() instanceof Path) {
            this.addError(error.getReason(), (Path)error.getOwner(), context);
        } else {
            this.addError(error.getReason(), null, context);
        }
    }

    private void addError(String messageTemplate, Path propPath, ValidationContext<?> context) {
        ConstraintDescriptor<?> descriptor;
        String message;
        Object value;
        if (this.compositeDepth.get() > 0) {
            this.hasCompositeError |= true;
            return;
        }
        if (context instanceof GroupValidationContext) {
            GroupValidationContext gcontext = (GroupValidationContext)context;
            value = gcontext.getValidatedValue();
            message = gcontext instanceof MessageInterpolator.Context ? gcontext.getMessageResolver().interpolate(messageTemplate, (MessageInterpolator.Context)gcontext) : gcontext.getMessageResolver().interpolate(messageTemplate, null);
            descriptor = gcontext.getConstraintValidation().asSerializableDescriptor();
            if (propPath == null) {
                propPath = gcontext.getPropertyPath();
            }
        } else {
            value = context.getMetaProperty() == null ? context.getBean() : context.getPropertyValue();
            message = messageTemplate;
            if (propPath == null) {
                propPath = PathImpl.createPathFromString(context.getPropertyName());
            }
            descriptor = null;
        }
        ElementType elementType = context.getAccess() != null ? context.getAccess().getElementType() : null;
        ConstraintViolationImpl<T> ic = new ConstraintViolationImpl<T>(messageTemplate, message, this.rootBean, context.getBean(), propPath, value, descriptor, this.rootBeanType, elementType);
        this.constraintViolations.add(ic);
    }

    public Set<ConstraintViolation<T>> getConstraintViolations() {
        return this.constraintViolations;
    }

    public boolean isEmpty() {
        return this.constraintViolations.isEmpty();
    }

    public T getRootBean() {
        return this.rootBean;
    }

    public Class<T> getRootBeanType() {
        return this.rootBeanType;
    }

    public int violationsSize() {
        return this.constraintViolations.size();
    }

    public boolean hasViolations() {
        return this.compositeDepth.get() == 0 ? !this.constraintViolations.isEmpty() : this.hasCompositeError;
    }

    public boolean beginReportAsSingle() {
        return this.compositeDepth.incrementAndGet() == 1;
    }

    public boolean endReportAsSingle() {
        return this.compositeDepth.decrementAndGet() == 0;
    }
}

