/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.bval.MetaBeanFactory;
import org.apache.bval.model.FeaturesCapable;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.routines.StandardValidation;
import org.apache.bval.xml.XMLFeaturesCapable;
import org.apache.bval.xml.XMLMetaBean;
import org.apache.bval.xml.XMLMetaBeanInfos;
import org.apache.bval.xml.XMLMetaBeanLoader;
import org.apache.bval.xml.XMLMetaBeanReference;
import org.apache.bval.xml.XMLMetaElement;
import org.apache.bval.xml.XMLMetaProperty;
import org.apache.bval.xml.XMLMetaValidator;
import org.apache.bval.xml.XMLMetaValidatorReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLMetaBeanFactory
implements MetaBeanFactory {
    private static final Log log = LogFactory.getLog(XMLMetaBeanFactory.class);
    private final Map<XMLMetaBeanLoader, XMLMetaBeanInfos> resources = new LinkedHashMap<XMLMetaBeanLoader, XMLMetaBeanInfos>();
    private StandardValidation standardValidation = StandardValidation.getInstance();

    @Override
    public void buildMetaBean(final MetaBean metaBean) throws Exception {
        if (metaBean.getId() == null) {
            return;
        }
        this.visitXMLBeanMeta(metaBean.getId(), new Visitor(){

            public void visit(XMLMetaBean xmlMeta, XMLMetaBeanInfos xmlInfos) throws Exception {
                XMLMetaBeanFactory.this.enrichMetaBean(metaBean, new XMLResult(xmlMeta, xmlInfos));
            }

            public MetaBean getMetaBean() {
                return metaBean;
            }
        });
    }

    public Collection<XMLMetaBeanLoader> getLoaders() {
        return this.resources.keySet();
    }

    public void addLoader(XMLMetaBeanLoader loader) {
        this.resources.put(loader, null);
    }

    public StandardValidation getStandardValidation() {
        return this.standardValidation;
    }

    public void setStandardValidation(StandardValidation standardValidation) {
        this.standardValidation = standardValidation;
    }

    public void enrichMetaBean(MetaBean meta, XMLResult result) throws Exception {
        if (result.xmlMeta.getId() != null) {
            meta.setId(result.xmlMeta.getId());
        }
        if (result.xmlMeta.getName() != null) {
            meta.setName(result.xmlMeta.getName());
        }
        result.xmlMeta.mergeFeaturesInto(meta);
        this.enrichValidations(meta, result.xmlMeta, result, false);
        if (result.xmlMeta.getProperties() != null) {
            for (XMLMetaProperty xmlProp : result.xmlMeta.getProperties()) {
                this.enrichElement(meta, xmlProp, result);
            }
        }
        if (result.xmlMeta.getBeanRefs() != null) {
            for (XMLMetaBeanReference xmlRef : result.xmlMeta.getBeanRefs()) {
                this.enrichElement(meta, xmlRef, result);
            }
        }
    }

    protected void enrichValidations(FeaturesCapable prop, XMLFeaturesCapable xmlProp, XMLResult result, boolean addStandard) throws Exception {
        if (xmlProp.getValidators() != null) {
            String[] func = (String[])prop.getFeature("jsFunctions");
            ArrayList<String> jsValidators = new ArrayList<String>(xmlProp.getValidators().size() + (func == null ? 0 : func.length));
            if (func != null && func.length > 0) {
                jsValidators.addAll(Arrays.asList(func));
            }
            boolean useStandard = prop instanceof MetaProperty;
            for (XMLMetaValidatorReference valRef : xmlProp.getValidators()) {
                XMLMetaValidator validator;
                if (this.standardValidation != null && valRef.getRefId().equals(this.standardValidation.getValidationId())) {
                    useStandard = false;
                }
                if ((validator = result.xmlInfos.getValidator(valRef.getRefId())) == null) continue;
                if (validator.getValidation() != null) {
                    prop.addValidation(validator.getValidation());
                }
                if (validator.getJsFunction() == null || jsValidators.contains(validator.getJsFunction())) continue;
                jsValidators.add(validator.getJsFunction());
            }
            if (!jsValidators.isEmpty()) {
                prop.putFeature("jsFunctions", jsValidators.toArray(new String[jsValidators.size()]));
            }
            if (useStandard && this.standardValidation != null && !prop.hasValidation(this.standardValidation)) {
                prop.addValidation(this.standardValidation);
            }
        } else if (addStandard && this.standardValidation != null && !prop.hasValidation(this.standardValidation)) {
            prop.addValidation(this.standardValidation);
        }
    }

    protected MetaProperty enrichElement(MetaBean meta, XMLMetaElement xmlProp, XMLResult result) throws Exception {
        MetaProperty prop = meta.getProperty(xmlProp.getName());
        if (prop == null) {
            prop = new MetaProperty();
            prop.setName(xmlProp.getName());
            meta.putProperty(xmlProp.getName(), prop);
        }
        xmlProp.mergeInto(prop);
        this.enrichValidations(prop, xmlProp, result, true);
        return prop;
    }

    public void visitXMLBeanMeta(String beanId, Visitor visitor) throws Exception {
        for (Map.Entry<XMLMetaBeanLoader, XMLMetaBeanInfos> entry : this.resources.entrySet()) {
            if (entry.getValue() == null) {
                try {
                    entry.setValue(entry.getKey().load());
                }
                catch (IOException e) {
                    this.handleLoadException(entry.getKey(), e);
                }
            }
            if (entry.getValue() == null) continue;
            if (beanId == null) {
                visitor.visit(null, entry.getValue());
                continue;
            }
            XMLMetaBean found = entry.getValue().getBean(beanId);
            if (found == null) continue;
            visitor.visit(found, entry.getValue());
        }
    }

    protected XMLResult findXMLBeanMeta(String beanId) {
        for (Map.Entry<XMLMetaBeanLoader, XMLMetaBeanInfos> entry : this.resources.entrySet()) {
            XMLMetaBean found;
            if (entry.getValue() == null) {
                try {
                    entry.setValue(entry.getKey().load());
                }
                catch (IOException e) {
                    this.handleLoadException(entry.getKey(), e);
                }
            }
            if (entry.getValue() == null || (found = entry.getValue().getBean(beanId)) == null) continue;
            return new XMLResult(found, entry.getValue());
        }
        return null;
    }

    public void handleLoadException(Object loader, IOException e) {
        log.error((Object)("error loading " + loader), (Throwable)e);
    }

    public static class XMLResult {
        public XMLMetaBean xmlMeta;
        public XMLMetaBeanInfos xmlInfos;

        public XMLResult(XMLMetaBean metaBean, XMLMetaBeanInfos metaInfos) {
            this.xmlMeta = metaBean;
            this.xmlInfos = metaInfos;
        }

        public XMLResult() {
        }
    }

    public static interface Visitor {
        public void visit(XMLMetaBean var1, XMLMetaBeanInfos var2) throws Exception;

        public MetaBean getMetaBean();
    }
}

