/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.model;

import java.io.Serializable;
import java.util.Map;
import org.apache.bval.model.Validation;
import org.apache.commons.collections.FastHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FeaturesCapable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FastHashMap features = new FastHashMap();
    private Validation[] validations = new Validation[0];

    public FeaturesCapable() {
        this.features.setFast(true);
    }

    public Map<String, Object> getFeatures() {
        return this.features;
    }

    public void optimizeRead(boolean fast) {
        this.features.setFast(fast);
    }

    public <T> T getFeature(String key) {
        return (T)this.features.get((Object)key);
    }

    public <T> T getFeature(String key, T defaultValue) {
        Object v = this.features.get((Object)key);
        if (v == null) {
            return this.features.containsKey((Object)key) ? null : (T)defaultValue;
        }
        return (T)v;
    }

    public <T> void putFeature(String key, T value) {
        this.features.put((Object)key, value);
    }

    public <T extends FeaturesCapable> T copy() {
        try {
            FeaturesCapable self = (FeaturesCapable)this.clone();
            this.copyInto(self);
            return (T)self;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("cannot clone() " + this, e);
        }
    }

    protected <T extends FeaturesCapable> void copyInto(T target) {
        target.features = (FastHashMap)this.features.clone();
        if (this.validations != null) {
            target.validations = (Validation[])this.validations.clone();
        }
    }

    public Validation[] getValidations() {
        return this.validations;
    }

    public void addValidation(Validation validation) {
        if (this.validations.length == 0) {
            this.validations = new Validation[1];
        } else {
            Validation[] newvalidations = new Validation[this.validations.length + 1];
            System.arraycopy(this.validations, 0, newvalidations, 0, this.validations.length);
            this.validations = newvalidations;
        }
        this.validations[this.validations.length - 1] = validation;
    }

    public boolean hasValidation(Validation aValidation) {
        if (this.validations == null) {
            return false;
        }
        for (Validation validation : this.validations) {
            if (!validation.equals(aValidation)) continue;
            return true;
        }
        return false;
    }
}

