/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ConfigurationState;
import javax.validation.spi.ValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;
import org.apache.bval.jsr303.DefaultConstraintValidatorFactory;
import org.apache.bval.jsr303.DefaultMessageInterpolator;
import org.apache.bval.jsr303.resolver.DefaultTraversableResolver;
import org.apache.bval.jsr303.xml.ValidationParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationImpl
implements ApacheValidatorConfiguration,
ConfigurationState {
    private static final Log log = LogFactory.getLog(ConfigurationImpl.class);
    protected final ValidationProvider provider;
    protected final ValidationProviderResolver providerResolver;
    protected Class<? extends ValidationProvider<?>> providerClass;
    protected MessageInterpolator messageInterpolator;
    protected ConstraintValidatorFactory constraintValidatorFactory;
    private TraversableResolver traversableResolver;
    private boolean prepared = false;
    private final TraversableResolver defaultTraversableResolver = new DefaultTraversableResolver();
    protected final MessageInterpolator defaultMessageInterpolator = new DefaultMessageInterpolator();
    private final ConstraintValidatorFactory defaultConstraintValidatorFactory = new DefaultConstraintValidatorFactory();
    private Set<InputStream> mappingStreams = new HashSet<InputStream>();
    private Map<String, String> properties = new HashMap<String, String>();
    private boolean ignoreXmlConfiguration = false;

    public ConfigurationImpl(BootstrapState aState, ValidationProvider aProvider) {
        if (aProvider != null) {
            this.provider = aProvider;
            this.providerResolver = null;
        } else if (aState != null) {
            this.provider = null;
            this.providerResolver = aState.getValidationProviderResolver() == null ? aState.getDefaultValidationProviderResolver() : aState.getValidationProviderResolver();
        } else {
            throw new ValidationException("either provider or state are required");
        }
    }

    public ApacheValidatorConfiguration traversableResolver(TraversableResolver resolver) {
        this.traversableResolver = resolver;
        this.prepared = false;
        return this;
    }

    public ApacheValidatorConfiguration ignoreXmlConfiguration() {
        this.ignoreXmlConfiguration = true;
        return this;
    }

    public ConfigurationImpl messageInterpolator(MessageInterpolator resolver) {
        this.messageInterpolator = resolver;
        this.prepared = false;
        return this;
    }

    public ConfigurationImpl constraintValidatorFactory(ConstraintValidatorFactory constraintFactory) {
        this.constraintValidatorFactory = constraintFactory;
        this.prepared = false;
        return this;
    }

    public ApacheValidatorConfiguration addMapping(InputStream stream) {
        this.mappingStreams.add(stream);
        return this;
    }

    public ApacheValidatorConfiguration addProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isIgnoreXmlConfiguration() {
        return this.ignoreXmlConfiguration;
    }

    public Set<InputStream> getMappingStreams() {
        return this.mappingStreams;
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public MessageInterpolator getDefaultMessageInterpolator() {
        return this.defaultMessageInterpolator;
    }

    public TraversableResolver getDefaultTraversableResolver() {
        return this.defaultTraversableResolver;
    }

    public ConstraintValidatorFactory getDefaultConstraintValidatorFactory() {
        return this.defaultConstraintValidatorFactory;
    }

    public ValidatorFactory buildValidatorFactory() {
        this.prepare();
        if (this.provider != null) {
            return this.provider.buildValidatorFactory((ConfigurationState)this);
        }
        return this.findProvider().buildValidatorFactory((ConfigurationState)this);
    }

    private void prepare() {
        if (this.prepared) {
            return;
        }
        this.parseValidationXml();
        this.applyDefaults();
        this.prepared = true;
    }

    private void parseValidationXml() {
        if (this.isIgnoreXmlConfiguration()) {
            log.info((Object)"ignoreXmlConfiguration == true");
        } else {
            new ValidationParser(this.getProperties().get("apache.bval.validation-xml-path")).processValidationConfig(this);
        }
    }

    private void applyDefaults() {
        if (this.traversableResolver == null) {
            this.traversableResolver = this.getDefaultTraversableResolver();
        }
        if (this.messageInterpolator == null) {
            this.messageInterpolator = this.getDefaultMessageInterpolator();
        }
        if (this.constraintValidatorFactory == null) {
            this.constraintValidatorFactory = this.getDefaultConstraintValidatorFactory();
        }
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public ValidationProvider getProvider() {
        return this.provider;
    }

    private ValidationProvider findProvider() {
        if (this.providerClass != null) {
            for (ValidationProvider provider : this.providerResolver.getValidationProviders()) {
                if (!this.providerClass.isAssignableFrom(provider.getClass())) continue;
                return provider;
            }
            throw new ValidationException("Unable to find suitable provider: " + this.providerClass);
        }
        List providers = this.providerResolver.getValidationProviders();
        return (ValidationProvider)providers.get(0);
    }

    public void setProviderClass(Class<? extends ValidationProvider<?>> providerClass) {
        this.providerClass = providerClass;
    }
}

