/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval;

import java.util.Iterator;
import java.util.Map;
import org.apache.bval.DynamicMetaBean;
import org.apache.bval.MetaBeanBuilder;
import org.apache.bval.MetaBeanCache;
import org.apache.bval.MetaBeanEnricher;
import org.apache.bval.MetaBeanFinder;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.util.PrivilegedActions;
import org.apache.bval.xml.XMLMetaBeanInfos;
import org.apache.bval.xml.XMLMetaBeanLoader;
import org.apache.bval.xml.XMLMetaBeanRegistry;
import org.apache.bval.xml.XMLMetaBeanURLLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaBeanManager
implements MetaBeanFinder,
XMLMetaBeanRegistry,
MetaBeanEnricher {
    protected final MetaBeanCache cache = new MetaBeanCache();
    protected final MetaBeanBuilder builder;
    private boolean complete = false;

    public MetaBeanManager() {
        this.builder = new MetaBeanBuilder();
    }

    public MetaBeanManager(MetaBeanBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void addResourceLoader(String resource) {
        this.addLoader(new XMLMetaBeanURLLoader(PrivilegedActions.getClassLoader(this.getClass()).getResource(resource)));
    }

    @Override
    public synchronized void addLoader(XMLMetaBeanLoader loader) {
        this.builder.addLoader(loader);
        this.cache.clear();
        this.complete = false;
    }

    public MetaBeanBuilder getBuilder() {
        return this.builder;
    }

    public MetaBeanCache getCache() {
        return this.cache;
    }

    @Override
    public Map<String, MetaBean> findAll() {
        if (!this.complete) {
            try {
                Map<String, MetaBean> allBuilt = this.builder.buildAll();
                for (MetaBean meta : allBuilt.values()) {
                    MetaBean cached = this.cache.findForId(meta.getId());
                    if (cached != null) continue;
                    this.cache.cache(meta);
                }
                Map<String, MetaBean> map = this.cache.findAll();
                Iterator<MetaBean> i$ = map.values().iterator();
                while (i$.hasNext()) {
                    MetaBean oentry;
                    MetaBean meta = oentry = i$.next();
                    this.computeRelationships(meta, map);
                }
                this.complete = true;
                return map;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("error creating beanInfos", e);
            }
        }
        return this.cache.findAll();
    }

    @Override
    public Map<String, MetaBean> enrichCopies(XMLMetaBeanInfos ... infos) {
        Map<String, MetaBean> cached = this.findAll();
        try {
            Map<String, MetaBean> patched = this.builder.enrichCopies(cached, infos);
            Iterator<MetaBean> i$ = patched.values().iterator();
            while (i$.hasNext()) {
                MetaBean oentry;
                MetaBean meta = oentry = i$.next();
                this.computeRelationships(meta, patched);
            }
            return patched;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error enriching beanInfos", e);
        }
    }

    @Override
    public MetaBean findForId(String beanInfoId) {
        MetaBean beanInfo = this.cache.findForId(beanInfoId);
        if (beanInfo != null) {
            return beanInfo;
        }
        try {
            beanInfo = this.builder.buildForId(beanInfoId);
            this.cache.cache(beanInfo);
            this.computeRelationships(beanInfo);
            return beanInfo;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error creating beanInfo with id: " + beanInfoId, e);
        }
    }

    @Override
    public MetaBean findForClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        MetaBean beanInfo = this.cache.findForClass(clazz);
        if (beanInfo != null) {
            return beanInfo;
        }
        try {
            beanInfo = this.builder.buildForClass(clazz);
            this.cache.cache(beanInfo);
            this.computeRelationships(beanInfo);
            return beanInfo;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error creating beanInfo for " + clazz, e);
        }
    }

    protected void computeRelationships(MetaBean beanInfo) {
        for (MetaProperty prop : beanInfo.getProperties()) {
            String beanRef = (String)prop.getFeature("refBeanId");
            if (beanRef != null) {
                prop.setMetaBean(this.findForId(beanRef));
                continue;
            }
            Class beanType = (Class)prop.getFeature("refBeanType");
            if (beanType != null) {
                prop.setMetaBean(this.findForClass(beanType));
                continue;
            }
            if (prop.getFeature("refCascade") == null) continue;
            prop.setMetaBean(new DynamicMetaBean(this));
        }
    }

    private void computeRelationships(MetaBean beanInfo, Map<String, MetaBean> cached) {
        for (MetaProperty prop : beanInfo.getProperties()) {
            String beanRef = (String)prop.getFeature("refBeanId");
            if (beanRef == null) continue;
            prop.setMetaBean(cached.get(beanRef));
        }
    }
}

