/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.json;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.bval.model.MetaBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONGenerator {
    private final Template template;

    public JSONGenerator() throws IOException {
        this("bean-infos-json.ftl");
    }

    public JSONGenerator(String templateName) throws IOException {
        Configuration freemarker = new Configuration();
        freemarker.setNumberFormat("0.######");
        freemarker.setClassForTemplateLoading(this.getClass(), "");
        this.template = freemarker.getTemplate(templateName);
    }

    public JSONGenerator(Template template) {
        this.template = template;
    }

    public String toJSON(MetaBean metaBean) throws IOException, TemplateException {
        ArrayList<MetaBean> metaBeans = new ArrayList<MetaBean>(1);
        metaBeans.add(metaBean);
        return this.toJSON(metaBeans);
    }

    public String toJSON(Collection<MetaBean> metaBeans) throws IOException, TemplateException {
        StringWriter out = new StringWriter();
        this.toJSON(metaBeans, out);
        return out.toString();
    }

    public void toJSON(Collection<MetaBean> metaBeans, Writer out) throws IOException, TemplateException {
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("metaBeans", metaBeans);
        rootMap.put("generator", this);
        this.template.process(rootMap, out);
    }
}

