/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.jawk;

import com.sun.script.jawk.JawkScriptEngineFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.jawk.Awk;

public class JawkScriptEngine
extends AbstractScriptEngine {
    public static final String FS = "FS";
    public static final String ARGUMENTS = "arguments";
    public static final String STDIN = "stdin";
    public static final String STDOUT = "stdout";
    public static final String STDERR = "stderr";
    private static final String[] EMPTY_ARGUMENTS = new String[0];
    private volatile ScriptEngineFactory factory;

    public JawkScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    JawkScriptEngine(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    public Object eval(String script, ScriptContext ctx) throws ScriptException {
        int index;
        Object tmp = ctx.getAttribute(STDIN);
        InputStream stdin = tmp instanceof InputStream ? (InputStream)tmp : System.in;
        tmp = ctx.getAttribute(STDOUT);
        PrintStream stdout = tmp instanceof PrintStream ? (PrintStream)tmp : System.out;
        tmp = ctx.getAttribute(STDERR);
        PrintStream stderr = tmp instanceof PrintStream ? (PrintStream)tmp : System.err;
        tmp = ctx.getAttribute(ARGUMENTS);
        String[] arguments = tmp instanceof String[] ? (String[])tmp : EMPTY_ARGUMENTS;
        tmp = ctx.getAttribute(FS);
        String fs = tmp instanceof String ? (String)tmp : null;
        int len = arguments.length + 1 + (fs != null ? 2 : 0);
        String[] args = new String[len];
        if (fs != null) {
            args[0] = "-F";
            args[1] = fs;
            index = 2;
        } else {
            index = 0;
        }
        args[index] = script;
        System.arraycopy(arguments, 0, args, index + 1, arguments.length);
        try {
            new Awk(args, stdin, stdout, stderr);
            return stdout;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        return this.eval(this.readFully(reader), ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngineFactory getFactory() {
        if (this.factory == null) {
            JawkScriptEngine jawkScriptEngine = this;
            synchronized (jawkScriptEngine) {
                if (this.factory == null) {
                    this.factory = new JawkScriptEngineFactory();
                }
            }
        }
        return this.factory;
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuffer buf = new StringBuffer();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }
}

