/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stats {
    static final Logger LOG = LoggerFactory.getLogger(Stats.class);
    public static final String STATS_PROVIDER_CLASS = "statsProviderClass";
    static StatsProvider prov = new NullStatsProvider();

    public static void loadStatsProvider(Configuration conf) {
        String className = conf.getString(STATS_PROVIDER_CLASS);
        if (className != null) {
            try {
                Class<?> cls = Class.forName(className);
                Constructor<?> cons = cls.getDeclaredConstructor(new Class[0]);
                prov = (StatsProvider)cons.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error("Couldn't find configured class(" + className + ")", (Throwable)cnfe);
            }
            catch (NoSuchMethodException nsme) {
                LOG.error("Couldn't find default constructor for class (" + className + ")", (Throwable)nsme);
            }
            catch (InstantiationException ie) {
                LOG.error("Couldn't construct class (" + className + ")", (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                LOG.error("Couldn't construct class (" + className + ")," + " Is the constructor private?", (Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                LOG.error("Constructor threw an exception. It should not have.", (Throwable)ite);
            }
        }
    }

    public static StatsProvider get() {
        return prov;
    }
}

