/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.xml.JAXBCoder;
import org.apache.beam.sdk.io.xml.XmlIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.codehaus.stax2.XMLInputFactory2;

public class XmlSource<@UnknownKeyFor T>
extends FileBasedSource<T> {
    private static final @UnknownKeyFor @NonNull @Initialized String XML_VERSION = "1.1";
    private final @UnknownKeyFor @NonNull @Initialized XmlIO.MappingConfiguration<T> configuration;

    XmlSource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> spec, @UnknownKeyFor @NonNull @Initialized XmlIO.MappingConfiguration<T> configuration, @UnknownKeyFor @NonNull @Initialized long minBundleSizeBytes) {
        super(spec, minBundleSizeBytes);
        this.configuration = configuration;
    }

    private XmlSource(@UnknownKeyFor @NonNull @Initialized XmlIO.MappingConfiguration<T> configuration, @UnknownKeyFor @NonNull @Initialized long minBundleSizeBytes, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized long startOffset, @UnknownKeyFor @NonNull @Initialized long endOffset) {
        super(metadata, minBundleSizeBytes, startOffset, endOffset);
        this.configuration = configuration;
    }

    protected @UnknownKeyFor @NonNull @Initialized FileBasedSource<T> createForSubrangeOfFile(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
        return new XmlSource<T>(this.configuration, this.getMinBundleSize(), metadata, start, end);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized FileBasedSource.FileBasedReader<T> createSingleFileReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new XMLReader(this);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getOutputCoder() {
        return JAXBCoder.of(this.configuration.getRecordClass());
    }

    private static class XMLReader<@UnknownKeyFor T>
    extends FileBasedSource.FileBasedReader<T> {
        private static final @UnknownKeyFor @NonNull @Initialized int BUF_SIZE = 1024;
        private static final @UnknownKeyFor @NonNull @Initialized int MAX_CHAR_BYTES = 4;
        private @UnknownKeyFor @NonNull @Initialized long parserBaseOffset = 0L;
        private @UnknownKeyFor @NonNull @Initialized boolean readingStarted = false;
        private @UnknownKeyFor @NonNull @Initialized boolean emptyBundle = false;
        private @UnknownKeyFor @NonNull @Initialized Unmarshaller jaxbUnmarshaller = null;
        private @UnknownKeyFor @NonNull @Initialized XMLStreamReader parser = null;
        private T currentRecord = null;
        private @UnknownKeyFor @NonNull @Initialized long currentByteOffset = 0L;

        XMLReader(@UnknownKeyFor @NonNull @Initialized XmlSource<T> source) {
            super(source);
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{((XmlSource)this.getCurrentSource()).configuration.getRecordClass()});
                this.jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                if (((XmlSource)this.getCurrentSource()).configuration.getValidationEventHandler() != null) {
                    this.jaxbUnmarshaller.setEventHandler(((XmlSource)this.getCurrentSource()).configuration.getValidationEventHandler());
                }
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }

        public synchronized @UnknownKeyFor @NonNull @Initialized XmlSource<T> getCurrentSource() {
            return (XmlSource)super.getCurrentSource();
        }

        protected void startReading(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            ByteArrayOutputStream preambleByteBuffer = new ByteArrayOutputStream();
            byte[] dummyStartDocumentBytes = String.format("<?xml version=\"%s\" encoding=\"" + ((XmlSource)this.getCurrentSource()).configuration.getCharset() + "\"?><%s>", XmlSource.XML_VERSION, ((XmlSource)this.getCurrentSource()).configuration.getRootElement()).getBytes(Charset.forName(((XmlSource)this.getCurrentSource()).configuration.getCharset()));
            preambleByteBuffer.write(dummyStartDocumentBytes);
            long offsetInFileOfRecordElement = this.getFirstOccurenceOfRecordElement(channel, preambleByteBuffer);
            if (offsetInFileOfRecordElement < 0L) {
                this.emptyBundle = true;
                return;
            }
            byte[] preambleBytes = preambleByteBuffer.toByteArray();
            this.currentByteOffset = offsetInFileOfRecordElement;
            this.setUpXMLParser(channel, preambleBytes);
            this.parserBaseOffset = offsetInFileOfRecordElement - (long)dummyStartDocumentBytes.length;
            this.readingStarted = true;
        }

        private @UnknownKeyFor @NonNull @Initialized long getFirstOccurenceOfRecordElement(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel, @UnknownKeyFor @NonNull @Initialized ByteArrayOutputStream preambleByteBuffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
            int byteIndexInRecordElementToMatch = 0;
            boolean recordStartBytesMatched = false;
            boolean fullyMatched = false;
            long offsetInFileOfCurrentByte = this.getCurrentSource().getStartOffset() - 1L;
            long startingOffsetInFileOfCurrentMatch = -1L;
            boolean matchStarted = false;
            byte[] charBytes = new byte[4];
            int charBytesFound = 0;
            ByteBuffer buf = ByteBuffer.allocate(1024);
            boolean bufSizeChanged = false;
            byte[] recordStartBytes = ("<" + ((XmlSource)this.getCurrentSource()).configuration.getRecordElement()).getBytes(StandardCharsets.UTF_8);
            block0: while (channel.read(buf) > 0) {
                buf.flip();
                while (buf.hasRemaining()) {
                    ++offsetInFileOfCurrentByte;
                    byte b = buf.get();
                    boolean reset = false;
                    if (recordStartBytesMatched) {
                        ByteBuffer newbuf;
                        charBytes[charBytesFound] = b;
                        Character c = null;
                        if (++charBytesFound != charBytes.length) continue;
                        CharBuffer charBuf = CharBuffer.allocate(1);
                        ByteArrayInputStream charBufStream = new ByteArrayInputStream(charBytes);
                        InputStreamReader reader = new InputStreamReader((InputStream)charBufStream, StandardCharsets.UTF_8);
                        int read = ((Reader)reader).read();
                        if (read <= 0) {
                            return -1L;
                        }
                        charBuf.flip();
                        c = Character.valueOf((char)read);
                        if (Character.isWhitespace(c.charValue()) || c.charValue() == '>' || c.charValue() == '/') {
                            fullyMatched = true;
                            preambleByteBuffer.write(recordStartBytes);
                            preambleByteBuffer.write(charBytes);
                            while (buf.hasRemaining()) {
                                preambleByteBuffer.write(buf.get());
                            }
                            break block0;
                        }
                        int bytesToWrite = buf.remaining() + charBytes.length;
                        if (bytesToWrite > 1024) {
                            newbuf = ByteBuffer.allocate(bytesToWrite);
                            bufSizeChanged = true;
                        } else {
                            newbuf = ByteBuffer.allocate(1024);
                        }
                        newbuf.put(charBytes);
                        offsetInFileOfCurrentByte -= (long)charBytes.length;
                        while (buf.hasRemaining()) {
                            newbuf.put(buf.get());
                        }
                        newbuf.flip();
                        buf = newbuf;
                        reset = true;
                    } else if (b == recordStartBytes[byteIndexInRecordElementToMatch]) {
                        if (!matchStarted) {
                            matchStarted = true;
                            startingOffsetInFileOfCurrentMatch = offsetInFileOfCurrentByte;
                        }
                        ++byteIndexInRecordElementToMatch;
                    } else {
                        reset = true;
                    }
                    if (reset) {
                        byteIndexInRecordElementToMatch = 0;
                        startingOffsetInFileOfCurrentMatch = -1L;
                        matchStarted = false;
                        recordStartBytesMatched = false;
                        charBytes = new byte[4];
                        charBytesFound = 0;
                    }
                    if (byteIndexInRecordElementToMatch != recordStartBytes.length) continue;
                    recordStartBytesMatched = true;
                }
                if (bufSizeChanged) {
                    buf = ByteBuffer.allocate(1024);
                    bufSizeChanged = false;
                    continue;
                }
                buf.clear();
            }
            if (!fullyMatched) {
                return -1L;
            }
            return startingOffsetInFileOfCurrentMatch;
        }

        private void setUpXMLParser(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] lookAhead) throws @UnknownKeyFor @NonNull @Initialized IOException {
            try {
                String localName;
                int event;
                XMLInputFactory2 xmlInputFactory = (XMLInputFactory2)XMLInputFactory.newInstance();
                this.parser = xmlInputFactory.createXMLStreamReader((InputStream)new SequenceInputStream(new ByteArrayInputStream(lookAhead), Channels.newInputStream(channel)), ((XmlSource)this.getCurrentSource()).configuration.getCharset());
                while ((event = this.parser.next()) != 1 || !(localName = this.parser.getLocalName()).equals(((XmlSource)this.getCurrentSource()).configuration.getRecordElement())) {
                }
            }
            catch (FactoryConfigurationError | XMLStreamException e) {
                throw new IOException(e);
            }
        }

        protected @UnknownKeyFor @NonNull @Initialized boolean readNextRecord() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.emptyBundle) {
                this.currentByteOffset = Long.MAX_VALUE;
                return false;
            }
            try {
                this.currentByteOffset = this.parserBaseOffset + (long)this.parser.getLocation().getCharacterOffset();
                while (this.parser.getEventType() != 1) {
                    this.parser.next();
                    this.currentByteOffset = this.parserBaseOffset + (long)this.parser.getLocation().getCharacterOffset();
                    if (this.parser.getEventType() != 8) continue;
                    this.currentByteOffset = Long.MAX_VALUE;
                    return false;
                }
                JAXBElement jb = this.jaxbUnmarshaller.unmarshal(this.parser, ((XmlSource)this.getCurrentSource()).configuration.getRecordClass());
                this.currentRecord = jb.getValue();
                return true;
            }
            catch (JAXBException | XMLStreamException e) {
                throw new IOException(e);
            }
        }

        public T getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (!this.readingStarted) {
                throw new NoSuchElementException();
            }
            return this.currentRecord;
        }

        protected @UnknownKeyFor @NonNull @Initialized boolean isAtSplitPoint() {
            return true;
        }

        protected @UnknownKeyFor @NonNull @Initialized long getCurrentOffset() {
            return this.currentByteOffset;
        }
    }
}

