/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.tika;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_sdks_java_io_tika.com.google.common.base.MoreObjects;
import org.apache.beam.repackaged.beam_sdks_java_io_tika.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_io_tika.com.google.common.base.Throwables;
import org.apache.beam.sdk.util.SerializableThrowable;
import org.apache.tika.metadata.Metadata;

public class ParseResult
implements Serializable {
    private final String fileLocation;
    private final String content;
    private final Metadata metadata;
    private final String[] metadataNames;
    @Nullable
    private final SerializableThrowable error;

    public static ParseResult success(String fileLocation, String content, Metadata metadata) {
        return new ParseResult(fileLocation, content, metadata, null);
    }

    public static ParseResult success(String fileLocation, String content) {
        return new ParseResult(fileLocation, content, new Metadata(), null);
    }

    public static ParseResult failure(String fileLocation, String partialContent, Metadata partialMetadata, Throwable error) {
        return new ParseResult(fileLocation, partialContent, partialMetadata, error);
    }

    private ParseResult(String fileLocation, String content, Metadata metadata, Throwable error) {
        Preconditions.checkArgument(fileLocation != null, "fileLocation can not be null");
        Preconditions.checkArgument(content != null, "content can not be null");
        Preconditions.checkArgument(metadata != null, "metadata can not be null");
        this.fileLocation = fileLocation;
        this.content = content;
        this.metadata = metadata;
        this.metadataNames = metadata.names();
        this.error = error == null ? null : new SerializableThrowable(error);
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    public Throwable getError() {
        Preconditions.checkState(this.error != null, "This is a successful ParseResult");
        return this.error.getThrowable();
    }

    public String getErrorAsString() {
        return Throwables.getStackTraceAsString(this.getError());
    }

    public String getContent() {
        return this.content;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return Objects.hash(this.getFileLocation(), this.getContent(), this.getMetadataHashCode(), this.isSuccess() ? "" : Throwables.getStackTraceAsString(this.getError()));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParseResult)) {
            return false;
        }
        ParseResult other = (ParseResult)obj;
        return Objects.equals(this.getFileLocation(), other.getFileLocation()) && Objects.equals(this.getContent(), other.getContent()) && Objects.equals(this.getMetadata(), other.getMetadata()) && (this.isSuccess() ? other.isSuccess() : !other.isSuccess() && Objects.equals(this.getErrorAsString(), other.getErrorAsString()));
    }

    private int getMetadataHashCode() {
        int hashCode = 0;
        for (String name : this.metadataNames) {
            hashCode += name.hashCode() ^ Arrays.hashCode(this.metadata.getValues(name));
        }
        return hashCode;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("fileLocation", this.fileLocation).add("content", "<" + this.content.length() + " chars>").add("metadata", this.metadata).add("error", this.getError() == null ? null : Throwables.getStackTraceAsString(this.getError())).toString();
    }
}

