/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.tika;

import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.tika.AutoValue_TikaIO_Read;
import org.apache.beam.sdk.io.tika.TikaOptions;
import org.apache.beam.sdk.io.tika.TikaSource;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdks.java.io.tika.repackaged.com.google.common.base.Preconditions;
import org.apache.tika.metadata.Metadata;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class TikaIO {
    public static Read read() {
        return new AutoValue_TikaIO_Read.Builder().setQueuePollTime(50L).setQueueMaxPollTime(3000L).build();
    }

    public static abstract class Read
    extends PTransform<PBegin, PCollection<String>> {
        private static final long serialVersionUID = 2198301984784351829L;
        public static final long DEFAULT_QUEUE_POLL_TIME = 50L;
        public static final long DEFAULT_QUEUE_MAX_POLL_TIME = 3000L;

        @Nullable
        abstract ValueProvider<String> getFilepattern();

        @Nullable
        abstract ValueProvider<String> getTikaConfigPath();

        @Nullable
        abstract Metadata getInputMetadata();

        @Nullable
        abstract Boolean getReadOutputMetadata();

        @Nullable
        abstract Long getQueuePollTime();

        @Nullable
        abstract Long getQueueMaxPollTime();

        @Nullable
        abstract Integer getMinimumTextLength();

        @Nullable
        abstract Boolean getParseSynchronously();

        abstract Builder toBuilder();

        public Read from(String filepattern) {
            Preconditions.checkNotNull(filepattern, "Filepattern cannot be empty.");
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filepattern));
        }

        public Read from(ValueProvider<String> filepattern) {
            Preconditions.checkNotNull(filepattern, "Filepattern cannot be empty.");
            return this.toBuilder().setFilepattern(filepattern).setQueuePollTime(50L).setQueueMaxPollTime(3000L).build();
        }

        public Read withTikaConfigPath(String tikaConfigPath) {
            Preconditions.checkNotNull(tikaConfigPath, "TikaConfigPath cannot be empty.");
            return this.withTikaConfigPath((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tikaConfigPath));
        }

        public Read withTikaConfigPath(ValueProvider<String> tikaConfigPath) {
            Preconditions.checkNotNull(tikaConfigPath, "TikaConfigPath cannot be empty.");
            return this.toBuilder().setTikaConfigPath(tikaConfigPath).build();
        }

        public Read withContentTypeHint(String contentType) {
            Preconditions.checkNotNull(contentType, "ContentType cannot be empty.");
            Metadata metadata = new Metadata();
            metadata.add("Content-Type", contentType);
            return this.withInputMetadata(metadata);
        }

        public Read withInputMetadata(Metadata metadata) {
            Metadata inputMetadata = this.getInputMetadata();
            if (inputMetadata != null) {
                for (String name : metadata.names()) {
                    inputMetadata.set(name, metadata.get(name));
                }
            } else {
                inputMetadata = metadata;
            }
            return this.toBuilder().setInputMetadata(inputMetadata).build();
        }

        public Read withReadOutputMetadata(Boolean value) {
            return this.toBuilder().setReadOutputMetadata(value).build();
        }

        public Read withQueuePollTime(Long value) {
            return this.toBuilder().setQueuePollTime(value).build();
        }

        public Read withQueueMaxPollTime(Long value) {
            return this.toBuilder().setQueueMaxPollTime(value).build();
        }

        public Read withMinimumTextlength(Integer value) {
            return this.toBuilder().setMinimumTextLength(value).build();
        }

        public Read withParseSynchronously(Boolean value) {
            return this.toBuilder().setParseSynchronously(value).build();
        }

        public Read withOptions(TikaOptions options) {
            Preconditions.checkNotNull(options, "TikaOptions cannot be empty.");
            Builder builder = this.toBuilder();
            builder.setFilepattern((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)options.getInput())).setQueuePollTime(options.getQueuePollTime()).setQueueMaxPollTime(options.getQueueMaxPollTime()).setMinimumTextLength(options.getMinimumTextLength()).setParseSynchronously(options.getParseSynchronously());
            if (options.getContentTypeHint() != null) {
                Metadata metadata = this.getInputMetadata();
                if (metadata == null) {
                    metadata = new Metadata();
                }
                metadata.add("Content-Type", options.getContentTypeHint());
                builder.setInputMetadata(metadata);
            }
            if (options.getTikaConfigPath() != null) {
                builder.setTikaConfigPath((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)options.getTikaConfigPath()));
            }
            if (Boolean.TRUE.equals(options.getReadOutputMetadata())) {
                builder.setReadOutputMetadata(options.getReadOutputMetadata());
            }
            return builder.build();
        }

        public PCollection<String> expand(PBegin input) {
            Preconditions.checkNotNull(this.getFilepattern(), "Filepattern cannot be empty.");
            Read.Bounded read = org.apache.beam.sdk.io.Read.from((BoundedSource)new TikaSource(this));
            PCollection pcol = (PCollection)input.getPipeline().apply((PTransform)read);
            pcol.setCoder(this.getDefaultOutputCoder());
            return pcol;
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            Metadata metadata;
            super.populateDisplayData(builder);
            String filepatternDisplay = this.getFilepattern().isAccessible() ? (String)this.getFilepattern().get() : this.getFilepattern().toString();
            builder.addIfNotNull(DisplayData.item((String)"filePattern", (String)filepatternDisplay).withLabel("File Pattern"));
            if (this.getTikaConfigPath() != null) {
                String tikaConfigPathDisplay = this.getTikaConfigPath().isAccessible() ? (String)this.getTikaConfigPath().get() : this.getTikaConfigPath().toString();
                builder.add(DisplayData.item((String)"tikaConfigPath", (String)tikaConfigPathDisplay).withLabel("TikaConfig Path"));
            }
            if ((metadata = this.getInputMetadata()) != null) {
                StringBuilder sb = new StringBuilder();
                sb.append('[');
                for (String name : metadata.names()) {
                    if (sb.length() > 1) {
                        sb.append(',');
                    }
                    sb.append(name).append('=').append(metadata.get(name));
                }
                sb.append(']');
                builder.add(DisplayData.item((String)"inputMetadata", (String)sb.toString()).withLabel("Input Metadata"));
            }
            if (Boolean.TRUE.equals(this.getParseSynchronously())) {
                builder.add(DisplayData.item((String)"parseMode", (String)"synchronous").withLabel("Parse Mode"));
            } else {
                builder.add(DisplayData.item((String)"parseMode", (String)"asynchronous").withLabel("Parse Mode"));
                builder.add(DisplayData.item((String)"queuePollTime", (String)this.getQueuePollTime().toString()).withLabel("Queue Poll Time")).add(DisplayData.item((String)"queueMaxPollTime", (String)this.getQueueMaxPollTime().toString()).withLabel("Queue Max Poll Time"));
            }
            Integer minTextLen = this.getMinimumTextLength();
            if (minTextLen != null && minTextLen > 0) {
                builder.add(DisplayData.item((String)"minTextLen", (String)this.getMinimumTextLength().toString()).withLabel("Minimum Text Length"));
            }
            if (Boolean.TRUE.equals(this.getReadOutputMetadata())) {
                builder.add(DisplayData.item((String)"readOutputMetadata", (String)"true").withLabel("Read Output Metadata"));
            }
        }

        protected Coder<String> getDefaultOutputCoder() {
            return StringUtf8Coder.of();
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setFilepattern(ValueProvider<String> var1);

            abstract Builder setTikaConfigPath(ValueProvider<String> var1);

            abstract Builder setInputMetadata(Metadata var1);

            abstract Builder setReadOutputMetadata(Boolean var1);

            abstract Builder setQueuePollTime(Long var1);

            abstract Builder setQueueMaxPollTime(Long var1);

            abstract Builder setMinimumTextLength(Integer var1);

            abstract Builder setParseSynchronously(Boolean var1);

            abstract Read build();
        }
    }
}

