/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.thrift;

import com.google.auto.value.AutoValue;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.thrift.AutoValue_ThriftIO_ReadFiles;
import org.apache.beam.sdk.io.thrift.AutoValue_ThriftIO_Sink;
import org.apache.beam.sdk.io.thrift.ThriftCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.thrift.TBase;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TSimpleJSONProtocol;
import org.apache.thrift.transport.AutoExpandingBufferReadTransport;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ThriftIO.class);

    private ThriftIO() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ReadFiles<T> readFiles(@UnknownKeyFor @NonNull @Initialized Class<T> recordClass) {
        return new AutoValue_ThriftIO_ReadFiles.Builder<T>().setRecordClass(recordClass).build();
    }

    public static <T extends TBase<?, ?>> @UnknownKeyFor @NonNull @Initialized Sink<T> sink(@UnknownKeyFor @NonNull @Initialized TProtocolFactory factory) {
        return new AutoValue_ThriftIO_Sink.Builder().setProtocolFactory(factory).build();
    }

    protected static class ThriftWriter<@UnknownKeyFor T/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized TBase<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> {
        private @UnknownKeyFor @NonNull @Initialized OutputStream stream;
        private @UnknownKeyFor @NonNull @Initialized TProtocolFactory protocolFactory;

        ThriftWriter(@UnknownKeyFor @NonNull @Initialized OutputStream stream, @UnknownKeyFor @NonNull @Initialized TProtocolFactory protocolFactory) {
            this.stream = stream;
            this.protocolFactory = protocolFactory;
        }

        public void write(T element) throws @UnknownKeyFor @NonNull @Initialized IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                TProtocol protocol = this.protocolFactory.getProtocol((TTransport)new TIOStreamTransport((OutputStream)baos));
                element.write(protocol);
            }
            catch (TTransportException tte) {
                LOG.error("Error in transport to TIOStreamTransport: " + (Object)((Object)tte));
                throw new RuntimeException(tte);
            }
            catch (TException te) {
                LOG.error("Error in writing element to TProtocol: " + (Object)((Object)te));
                throw new RuntimeException(te);
            }
            this.stream.write(baos.toByteArray());
        }

        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.stream.flush();
            this.stream.close();
        }
    }

    @AutoValue
    public static abstract class Sink<@UnknownKeyFor T/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized TBase<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>
    implements FileIO.Sink<T> {
        private transient @UnknownKeyFor @NonNull @Initialized ThriftWriter<T> writer;

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        abstract @Nullable @UnknownKeyFor @Initialized TProtocolFactory getProtocolFactory();

        public void open(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.writer = new ThriftWriter(Channels.newOutputStream(channel), this.getProtocolFactory());
        }

        public void write(T element) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Preconditions.checkNotNull(this.writer, (Object)"Writer cannot be null");
            this.writer.write(element);
        }

        public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.writer.close();
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T/*
         * Issues handling annotations - annotations may be inaccurate
         */
         extends @UnknownKeyFor @NonNull @Initialized TBase<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setProtocolFactory(@UnknownKeyFor @NonNull @Initialized TProtocolFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized TProtocolFactory getProtocolFactory();

            abstract @UnknownKeyFor @NonNull @Initialized Sink<T> autoBuild();

            public @UnknownKeyFor @NonNull @Initialized Sink<T> build() {
                Preconditions.checkArgument((this.getProtocolFactory() != null ? 1 : 0) != 0, (Object)"TProtocol is required for sink.");
                return this.autoBuild();
            }
        }
    }

    @AutoValue
    public static abstract class ReadFiles<@UnknownKeyFor T>
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<T>> {
        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        abstract @Nullable @UnknownKeyFor @Initialized Class<T> getRecordClass();

        abstract @Nullable @UnknownKeyFor @Initialized TProtocolFactory getTProtocolFactory();

        public @UnknownKeyFor @NonNull @Initialized ReadFiles<T> withProtocol(@UnknownKeyFor @NonNull @Initialized TProtocolFactory protocol) {
            Preconditions.checkArgument((!(protocol instanceof TSimpleJSONProtocol.Factory) ? 1 : 0) != 0, (Object)"TSimpleJSONProtocol is a write only protocol");
            return this.toBuilder().setTProtocolFactory(protocol).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile> input) {
            Preconditions.checkNotNull(this.getRecordClass(), (Object)"Record class cannot be null");
            Preconditions.checkNotNull((Object)this.getTProtocolFactory(), (Object)"Thrift protocol cannot be null");
            return ((PCollection)input.apply((PTransform)ParDo.of(new ReadFn<T>(this.getRecordClass(), this.getTProtocolFactory())))).setCoder(ThriftCoder.of(this.getRecordClass(), this.getTProtocolFactory()));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"Thrift class", (String)this.getRecordClass().toString()).withLabel("Thrift class"));
            builder.add(DisplayData.item((String)"Thrift Protocol", (String)this.getTProtocolFactory().toString()).withLabel("Protocol Type"));
        }

        static class ReadFn<@UnknownKeyFor T>
        extends DoFn<FileIO.ReadableFile, T> {
            final @UnknownKeyFor @NonNull @Initialized Class<T> tBaseType;
            final @UnknownKeyFor @NonNull @Initialized TProtocolFactory tProtocol;

            ReadFn(@UnknownKeyFor @NonNull @Initialized Class<T> tBaseType, @UnknownKeyFor @NonNull @Initialized TProtocolFactory tProtocol) {
                this.tBaseType = tBaseType;
                this.tProtocol = tProtocol;
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile file, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> out) {
                try {
                    InputStream inputStream = Channels.newInputStream(file.open());
                    TIOStreamTransport streamTransport = new TIOStreamTransport((InputStream)new BufferedInputStream(inputStream));
                    AutoExpandingBufferReadTransport readTransport = new AutoExpandingBufferReadTransport(new TConfiguration(), 0xFA00000);
                    readTransport.fill((TTransport)streamTransport, inputStream.available());
                    TProtocol protocol = this.tProtocol.getProtocol((TTransport)readTransport);
                    while (protocol.getTransport().getBytesRemainingInBuffer() > 0) {
                        TBase tb = (TBase)this.tBaseType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        tb.read(protocol);
                        out.output((Object)tb);
                    }
                }
                catch (Exception ioe) {
                    String filename = file.getMetadata().resourceId().toString();
                    LOG.error(String.format("Error in reading file: %1$s%n%2$s", filename, ioe));
                    throw new RuntimeException(ioe);
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRecordClass(@UnknownKeyFor @NonNull @Initialized Class<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized TProtocolFactory getTProtocolFactory();

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTProtocolFactory(@UnknownKeyFor @NonNull @Initialized TProtocolFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadFiles<T> build();
        }
    }
}

